/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_VIEWWINDOW_H
#define INCLUDED_VIEWWINDOW_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

#ifndef INCLUDED_QCOLOR_H
#include <qcolor.h>
#define INCLUDED_QCOLOR_H
#endif // INCLUDED_QCOLOR_H

#ifndef INCLUDED_QDIR_H
#include <qdir.h>
#define INCLUDED_QDIR_H
#endif // INCLUDED_QDIR_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

#ifndef INCLUDED_SET
#include <set>
#define INCLUDED_SET
#endif // INCLUDED_SET

#ifndef INCLUDED_QSTRINGLIST_H
#include <qstringlist.h> 
#define INCLUDED_QSTRINGLIST_H
#endif // INCLUDED_QSTRINGLIST_H

#ifndef INCLUDED_QTIMER_H
#include <qtimer.h>
#define INCLUDED_QTIMER_H
#endif // INCLUDED_QTIMER_H


#ifndef INCLUDED_SELECTION_H
#include "Selection.h"
#endif // INCLUDED_SELECTION_H

#ifndef INCLUDED_FTPSERVERINFO_H
#include "FtpServerInfo.h"
#endif // INCLUDED_FTPSERVERINFO_H

#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H


/*------- forward declarations:
-------------------------------------------------------------------*/
class QComboBox;
class InfoField;
class Searcher;
class ViewTableItem;
class QFtp;
class QLineEdit;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class ViewWindow : public QFrame
{
	Q_OBJECT

/******* TYPES *******/
public:
	typedef enum {
		REMOVE_SELECTION = 1,
		STAY_SELECTION
	} SELECTION_CHANGE;
	typedef enum {
		FTP_CMD_NONE = 0,
		FTP_CMD_LOGIN,
		FTP_CMD_CLOSE,
		FTP_CMD_CD,
		FTP_CMD_LIST,
		FTP_CMD_PWD,
		FTP_CMD_RENAME,
		FTP_CMD_MKDIR,
		FTP_CMD_REMOVE
	} FTP_CMD;
	typedef enum {
		NO_PACKED = 0,
		TAR,
		GZIP,
		BZIP2,
		ZIP
	} CompressType;

/******* CONSTRUCTION *******/
public:
	ViewWindow( QWidget* const in_parent );
	~ViewWindow();
private:
	ViewWindow( const ViewWindow& );
	ViewWindow& operator=( const ViewWindow& );
	
/******* MEMBERS *******/
private:
	static const int     OVER_STRETCH;
	static const int     SPACING_WIDTH;
	static const int     MARGIN_WIDTH;
	static const int     MAX_ITEMS_ON_LIST;
	static const QString DIR_INFO_LABEL;
	static const QString FILE_INFO_LABEL;
	static const QString SELECTION_INFO_LABEL;
	static const QString UP_PIXNAME;
	static const QString MSGBOX_DEL_QUEST_CAPTION;
	static const QString MSGBOX_DEL_QUEST_MSG;
	static const QString MSGBOX_EMPTY_QUEST_CAPTION;
	static const QString MSGBOX_EMPTY_QUEST_MSG;
	static const QString INDLG_F6_CAPTION;
	static const QString INDLG_F6_MSG;
	static const QString MSGBOX_F6_CAPTION;
	static const QString MSGBOX_F6_MSG;
	static const QString INDLG_F7_CAPTION;
	static const QString INDLG_F7_MSG;
	static const QString MSGBOX_F7_CAPTION;
	static const QString MSGBOX_F7_MSG;
	static const QString CANT_SAVE_FILE;
	static const QString CANT_READ_FILE;
	static const QString BINARY_FILE;
	static const QString TOUCH_CAPTION;
	static const QString TOUCH_PROMPT;
	static const QString TOUCH_FILE_EXISTS;
	static const QString TOUCH_CANT_CREATE;
	static const QString FTP_MSG_CAPTION;
	static const QString KDE_EXECUTE;
	static const QString MD5Caption;
	static const QString MD5Msg;
	static const QString MD5Ok;
	static const QString MD5Error;
	static const QString TarExt;
	static const QString GzipExt;
	static const QString Bzip2Ext;
	static const QString ZipExt;
	static const QString DeletingCaption;
	static const QString PleaseWaitMsg;
public:
	static const QString CONFIG_KEY_PATH;
	static const QString CONFIG_KEY_FILE;
	static const QString CONFIG_KEY_COMBO;

	//....................................
	static int    s_pack_idx;
	//....................................
	QComboBox* const d_path;
	QComboBox* const d_fstab;
	ViewTable*       d_table;
	QLineEdit* const d_status;
	QFtp*      const d_ftp;
	QDir             d_dir;
	QLabel*          d_dir_info_lbl;
	QLabel*          d_file_info_lbl;
	QLabel*          d_sel_info_lbl;
	InfoField*       d_dir_number;
	InfoField*       d_file_number;
	InfoField*       d_selection_number;
	int              d_dir_counter;
	int              d_file_counter;
	QString          d_tmp_packed_path;
	QString          d_src_packed_path;
	CompressType     d_compress_type;
	bool             d_is_ftp_dir;
	bool             d_is_ftp_root;
	QString          d_prv_dir;
	QString          d_prv_item;
	int              d_max_items_on_list;
	FTP_CMD          d_ftp_cmd;
	FtpServerInfo    d_fsi;
	int              d_pwd_cmd_id;
	QTimer           d_timer;
	bool             d_loop;
	QString          d_devname;

/******* METHODS *******/
public:
	void    disp_this_location  ( const QString& in_dname, const QString& in_fname );
	QString get_dir             ();
	QString get_current_fname   ();
	QStringList get_combox_items();
	ViewTableItem* current_item () { return d_table->current_item(); }
	void    set_combox_items    ( const QStringList& in_data );
	const ViewTable::SelectedItems& selections() { return d_table->selections(); }
	void    update_view         ( const SELECTION_CHANGE in_selection_change );
	bool    has_focus           () const { return d_table->hasFocus(); }
	void    set_focus           () { d_table->setFocus(); }
	bool    is_ftp_dir          () const { return d_is_ftp_dir; }
	const FtpServerInfo& get_fsi() const { return d_fsi; }
	void    wait_start          () { d_timer.start( 2000 ); }
	void    wait_stop           () { d_timer.stop();        }
	void    lang_changed        ();
	void    looks_refresh       ();
private:
	void     ctrl_return      ();
	void     ctrl_K           ();
	void     ctrl_L           ();
	Q_ULLONG read_dir_size    ( const QString& );
	QWidget* make_info_area   ();
	void     keyPressEvent    ( QKeyEvent* e );
	void     open_packed      ( const QString&, const CompressType );
	void     close_packed     ();
	void     start_finder     ( const char in_char );
	void     finish_finder    ();
	void     read_dir         ();
	void     refresh_dir      ();
	void     update_start     ();
	void     next_item        ( const QFileInfo& in_fi );
	void     update_finish    ();
	void     start_searcher   ();
	void     read_fstab       ();
	bool     is_mounted       ( const QString& );
	void     F6_ftp           ( const QString&, const QString& );
	void     F6_lfs           ( const QString&, const QString& );
	void     F7_ftp           ( const QString& );
	void     F7_lfs           ( const QString& );
	void     F8_ftp           ( const ViewTable::SelectedItems& );
	void     F8_lfs           ( const ViewTable::SelectedItems&, const bool, QDialog* );
	// FTP
	void ftp_connect       ();
	void ftp_cd            ( const QString&, const bool = TRUE );
	void ftp_list          ( const bool = TRUE );
	void ftp_pwd           ( const bool = TRUE );
private slots:
    void break_work        ();
	void filter            ( bool in_on );
	void cd_up             ();
	void cd_home           ();
	void cd_root           ();
	void cd_refresh        ();
	void execute           ( QListViewItem* );
	void execute           ( QListViewItem*, const QPoint&, int );
	void return_pressed    ();
	void activated         ( int );
	void fstab             ( int );
	void touch             ();
	void slot_ftp_start    ();
	void slot_ftp_end      ();
	// OBSLUGA LICZNIKOW
	void selections_changed( int );
	void inc_dir_counter   ();
	void inc_file_counter  ();
	// OBSLUGA ZAZNACZEN
	void slot_select       ();
	void slot_unselect     ();
	void slot_revers       ();
	// OBSLUGA KLAWISZY FUNKCYJNYCH
	void F2                ();
	void F3                ();
	void F4                ();
	void F6                ();
	void F7                ();
	void F8                ();
	void empty             ();
	void disp_dir_size     ( ViewTableItem* );
	// FTP
	void ftp_done          ( bool );
	void ftp_state_changed ( int );
	void ftp_list_info     ( const QUrlInfo& );
	void ftp_cmd_finish    ( int, bool );
	void ftp_cmd_reply     ( int, const QString& );
	void timeout           ();
	void tree              ();
	void md5_create        ();
	void md5_check         ();
signals:
	void F5                ();
	void F9                ();
	void ftp_rejected      ();
	void selection_changed ();
	void tab_update        ( const QString& );
	void open_new_tab      ( const QString& );
};

#endif // INCLUDED_VIEWWINDOW_H
