/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPCOPYTO_H
#define INCLUDED_FTPCOPYTO_H


/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_FTPSERVERLIST_H
#include "FtpServersList.h"
#endif // INCLUDED_FTPSERVERLIST_H

#ifndef INCLUDED_FTPCOPYDIALOG_H
#include "CopyDialog.h"
#endif // INCLUDED_FTPCOPYDIALOG_H

#ifndef INCLUDED_QFTP_H
#include <qftp.h>
#define INCLUDED_QFTP_H
#endif // INCLUDED_QFTP_H

#ifndef INCLUDED_STACK
#include <stack>
#define INCLUDED_STACK
#endif // INCLUDED_STACK

#ifndef INCLUDED_QDIR_H
#include <qdir.h>
#define INCLUDED_QDIR_H
#endif // INCLUDED_QDIR_H

#ifndef INCLUDED_QFILE_H
#include <qfile.h>
#define INCLUDED_QFILE_H
#endif // INCLUDED_QFILE_H


/*------- forward declarations:
-------------------------------------------------------------------*/
class SelectedItems;


/*------- class declaration:
-------------------------------------------------------------------*/
class FTPCopyTo : public CopyDialog
{
    Q_OBJECT

// ******* TYPES *******
private:
    enum {
        CMD_NONE = 0,
        CMD_LOGIN,
        CMD_CDUP,
        CMD_MKDIR,
        CMD_CD,
        CMD_PUT,
        CMD_CLOSE
    };
    
// ******** CONSTRUCTION/DESTRUCTION *******
public:
    FTPCopyTo( QWidget*, const FtpServerInfo&,  const ViewTable::SelectedItems&, const QString& );
    ~FTPCopyTo();
private:
    FTPCopyTo( const FTPCopyTo& );
    FTPCopyTo& operator=( const FTPCopyTo& );

// ******* MEMBERS *******
private:
    const FtpServerInfo d_fsi;
	QString             d_path;
	QString             d_dir_name;
	int                 d_cmd;
    int                 d_pwd_cmd_id;
    bool                d_running;
    bool                d_break;
	std::stack<QString> d_dirs;
	std::stack<QString> d_files_on_dir;
	std::stack<QString> d_dirs_on_dir;
    QFtp                d_ftp;
    QDir                d_dir;
    QFile               d_file;

// ******* METHODS *******
private:
    void doit             ();
    void read_directory   ();
    void put              ();
    void cd_up            ();
    void cd               ( const QString& );
    void pwd              ();
    void check_dir        ( const QString& );
    void close            ();
private slots:
    void run              ();
    void cancel           ();
    void done             ( bool );
    void raw_cmd_finish   ( int, bool );
    void raw_cmd_reply    ( int, const QString& );
    void transfer_progress( int, int );
signals:
    void done             ();
};


#endif // INCLUDED_FTPCOPYTO_H
