#ifdef NECDSP_CPP

uint8 NECDSP::sr_read(unsigned) {
  cpu.synchronize_coprocessors();
  return regs.sr >> 8;
}

void NECDSP::sr_write(unsigned, uint8 data) {
  cpu.synchronize_coprocessors();
}

uint8 NECDSP::dr_read(unsigned) {
  cpu.synchronize_coprocessors();
  if(regs.sr.drc == 0) {
    //16-bit
    if(regs.sr.drs == 0) {
      regs.sr.drs = 1;
      return regs.dr >> 0;
    } else {
      regs.sr.rqm = 0;
      regs.sr.drs = 0;
      return regs.dr >> 8;
    }
  } else {
    //8-bit
    regs.sr.rqm = 0;
    return regs.dr >> 0;
  }
}

void NECDSP::dr_write(unsigned, uint8 data) {
  cpu.synchronize_coprocessors();
  if(regs.sr.drc == 0) {
    //16-bit
    if(regs.sr.drs == 0) {
      regs.sr.drs = 1;
      regs.dr = (regs.dr & 0xff00) | (data << 0);
    } else {
      regs.sr.rqm = 0;
      regs.sr.drs = 0;
      regs.dr = (data << 8) | (regs.dr & 0x00ff);
    }
  } else {
    //8-bit
    regs.sr.rqm = 0;
    regs.dr = (regs.dr & 0xff00) | (data << 0);
  }
}

uint8 NECDSP::dp_read(unsigned addr) {
  cpu.synchronize_coprocessors();
  bool hi = addr & 1;
  addr = (addr >> 1) & 2047;

  if(hi == false) {
    return dataRAM[addr] >> 0;
  } else {
    return dataRAM[addr] >> 8;
  }
}

void NECDSP::dp_write(unsigned addr, uint8 data) {
  cpu.synchronize_coprocessors();
  bool hi = addr & 1;
  addr = (addr >> 1) & 2047;

  if(hi == false) {
    dataRAM[addr] = (dataRAM[addr] & 0xff00) | (data << 0);
  } else {
    dataRAM[addr] = (dataRAM[addr] & 0x00ff) | (data << 8);
  }
}

#endif
