/* endsession.c generated by valac 0.32.1, the Vala compiler
 * generated from endsession.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define BUDGIE_TYPE_INHIBITOR (budgie_inhibitor_get_type ())
#define BUDGIE_INHIBITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_INHIBITOR, BudgieInhibitor))
#define BUDGIE_IS_INHIBITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_INHIBITOR))
#define BUDGIE_INHIBITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_INHIBITOR, BudgieInhibitorIface))

typedef struct _BudgieInhibitor BudgieInhibitor;
typedef struct _BudgieInhibitorIface BudgieInhibitorIface;

#define BUDGIE_TYPE_INHIBITOR_PROXY (budgie_inhibitor_proxy_get_type ())
typedef GDBusProxy BudgieInhibitorProxy;
typedef GDBusProxyClass BudgieInhibitorProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_DIALOG_TYPE (budgie_dialog_type_get_type ())

#define BUDGIE_TYPE_END_SESSION_DIALOG (budgie_end_session_dialog_get_type ())
#define BUDGIE_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog))
#define BUDGIE_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))
#define BUDGIE_IS_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_IS_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_END_SESSION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))

typedef struct _BudgieEndSessionDialog BudgieEndSessionDialog;
typedef struct _BudgieEndSessionDialogClass BudgieEndSessionDialogClass;
typedef struct _BudgieEndSessionDialogPrivate BudgieEndSessionDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieInhibitorIface {
	GTypeInterface parent_iface;
	gchar* (*GetAppId) (BudgieInhibitor* self, GError** error);
	gchar* (*GetReason) (BudgieInhibitor* self, GError** error);
};

typedef enum  {
	BUDGIE_DIALOG_TYPE_LOGOUT = 0,
	BUDGIE_DIALOG_TYPE_SHUTDOWN = 1,
	BUDGIE_DIALOG_TYPE_RESTART = 2,
	BUDGIE_DIALOG_TYPE_UPDATE_RESTART = 3
} BudgieDialogType;

struct _BudgieEndSessionDialog {
	GtkWindow parent_instance;
	BudgieEndSessionDialogPrivate * priv;
};

struct _BudgieEndSessionDialogClass {
	GtkWindowClass parent_class;
};

struct _BudgieEndSessionDialogPrivate {
	GtkButton* button_cancel;
	GtkButton* button_logout;
	GtkButton* button_restart;
	GtkButton* button_shutdown;
	GtkLabel* label_end_title;
	gboolean showing;
};


static gpointer budgie_end_session_dialog_parent_class = NULL;

GType budgie_inhibitor_proxy_get_type (void) G_GNUC_CONST;
guint budgie_inhibitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_inhibitor_get_type (void) G_GNUC_CONST;
gchar* budgie_inhibitor_GetAppId (BudgieInhibitor* self, GError** error);
gchar* budgie_inhibitor_GetReason (BudgieInhibitor* self, GError** error);
static void budgie_inhibitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* budgie_inhibitor_proxy_GetAppId (BudgieInhibitor* self, GError** error);
static gchar* budgie_inhibitor_proxy_GetReason (BudgieInhibitor* self, GError** error);
static void budgie_inhibitor_proxy_budgie_inhibitor_interface_init (BudgieInhibitorIface* iface);
static void _dbus_budgie_inhibitor_GetAppId (BudgieInhibitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_inhibitor_GetReason (BudgieInhibitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_inhibitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_inhibitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_inhibitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_inhibitor_unregister_object (gpointer user_data);
GType budgie_dialog_type_get_type (void) G_GNUC_CONST;
GType budgie_end_session_dialog_get_type (void) G_GNUC_CONST;
guint budgie_end_session_dialog_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define BUDGIE_END_SESSION_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogPrivate))
enum  {
	BUDGIE_END_SESSION_DIALOG_DUMMY_PROPERTY
};
static void budgie_end_session_dialog_cancel_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_end_session_dialog_logout_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_logout_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_end_session_dialog_restart_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_restart_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_end_session_dialog_shutdown_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void budgie_end_session_dialog_on_bus_acquired (BudgieEndSessionDialog* self, GDBusConnection* conn);
BudgieEndSessionDialog* budgie_end_session_dialog_new (void);
BudgieEndSessionDialog* budgie_end_session_dialog_construct (GType object_type);
static void _budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static gboolean __lambda4_ (BudgieEndSessionDialog* self);
static gboolean ___lambda4__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
void budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1);
void budgie_end_session_dialog_Close (BudgieEndSessionDialog* self);
static void budgie_end_session_dialog_finalize (GObject* obj);
static void _dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_canceled (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_closed (GObject* _sender, gpointer* _data);
static void _budgie_end_session_dialog_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _budgie_inhibitor_dbus_arg_info_GetAppId_result = {-1, "result", "s"};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetAppId_in[] = {NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetAppId_out[] = {&_budgie_inhibitor_dbus_arg_info_GetAppId_result, NULL};
static const GDBusMethodInfo _budgie_inhibitor_dbus_method_info_GetAppId = {-1, "GetAppId", (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetAppId_in), (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetAppId_out)};
static const GDBusArgInfo _budgie_inhibitor_dbus_arg_info_GetReason_result = {-1, "result", "s"};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetReason_in[] = {NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetReason_out[] = {&_budgie_inhibitor_dbus_arg_info_GetReason_result, NULL};
static const GDBusMethodInfo _budgie_inhibitor_dbus_method_info_GetReason = {-1, "GetReason", (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetReason_in), (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetReason_out)};
static const GDBusMethodInfo * const _budgie_inhibitor_dbus_method_info[] = {&_budgie_inhibitor_dbus_method_info_GetAppId, &_budgie_inhibitor_dbus_method_info_GetReason, NULL};
static const GDBusSignalInfo * const _budgie_inhibitor_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_inhibitor_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_inhibitor_dbus_interface_info = {-1, "org.gnome.SessionManager.Inhibitor", (GDBusMethodInfo **) (&_budgie_inhibitor_dbus_method_info), (GDBusSignalInfo **) (&_budgie_inhibitor_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_inhibitor_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_inhibitor_dbus_interface_vtable = {budgie_inhibitor_dbus_interface_method_call, budgie_inhibitor_dbus_interface_get_property, budgie_inhibitor_dbus_interface_set_property};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_type = {-1, "type", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_open_length = {-1, "open_length", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_inhibiters = {-1, "inhibiters", "ao"};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_in[] = {&_budgie_end_session_dialog_dbus_arg_info_Open_type, &_budgie_end_session_dialog_dbus_arg_info_Open_timestamp, &_budgie_end_session_dialog_dbus_arg_info_Open_open_length, &_budgie_end_session_dialog_dbus_arg_info_Open_inhibiters, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Open = {-1, "Open", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_out)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_out)};
static const GDBusMethodInfo * const _budgie_end_session_dialog_dbus_method_info[] = {&_budgie_end_session_dialog_dbus_method_info_Open, &_budgie_end_session_dialog_dbus_method_info_Close, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_logout[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_logout = {-1, "ConfirmedLogout", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_logout)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_reboot[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_reboot = {-1, "ConfirmedReboot", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_reboot)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown = {-1, "ConfirmedShutdown", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_canceled[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_canceled = {-1, "Canceled", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_canceled)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_closed[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_closed = {-1, "Closed", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_closed)};
static const GDBusSignalInfo * const _budgie_end_session_dialog_dbus_signal_info[] = {&_budgie_end_session_dialog_dbus_signal_info_confirmed_logout, &_budgie_end_session_dialog_dbus_signal_info_confirmed_reboot, &_budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown, &_budgie_end_session_dialog_dbus_signal_info_canceled, &_budgie_end_session_dialog_dbus_signal_info_closed, NULL};
static const GDBusPropertyInfo * const _budgie_end_session_dialog_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_end_session_dialog_dbus_interface_info = {-1, "com.solus_project.Session.EndSessionDialog", (GDBusMethodInfo **) (&_budgie_end_session_dialog_dbus_method_info), (GDBusSignalInfo **) (&_budgie_end_session_dialog_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_end_session_dialog_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_end_session_dialog_dbus_interface_vtable = {budgie_end_session_dialog_dbus_interface_method_call, budgie_end_session_dialog_dbus_interface_get_property, budgie_end_session_dialog_dbus_interface_set_property};

gchar* budgie_inhibitor_GetAppId (BudgieInhibitor* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return BUDGIE_INHIBITOR_GET_INTERFACE (self)->GetAppId (self, error);
}


gchar* budgie_inhibitor_GetReason (BudgieInhibitor* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return BUDGIE_INHIBITOR_GET_INTERFACE (self)->GetReason (self, error);
}


static void budgie_inhibitor_base_init (BudgieInhibitorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType budgie_inhibitor_get_type (void) {
	static volatile gsize budgie_inhibitor_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_inhibitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieInhibitorIface), (GBaseInitFunc) budgie_inhibitor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_inhibitor_type_id;
		budgie_inhibitor_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieInhibitor", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_inhibitor_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_inhibitor_proxy_get_type);
		g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.Inhibitor");
		g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_inhibitor_dbus_interface_info));
		g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_inhibitor_register_object);
		g_once_init_leave (&budgie_inhibitor_type_id__volatile, budgie_inhibitor_type_id);
	}
	return budgie_inhibitor_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieInhibitorProxy, budgie_inhibitor_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_INHIBITOR, budgie_inhibitor_proxy_budgie_inhibitor_interface_init) )
static void budgie_inhibitor_proxy_class_init (BudgieInhibitorProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_inhibitor_proxy_g_signal;
}


static void budgie_inhibitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void budgie_inhibitor_proxy_init (BudgieInhibitorProxy* self) {
}


static gchar* budgie_inhibitor_proxy_GetAppId (BudgieInhibitor* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp0_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.Inhibitor", "GetAppId");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* budgie_inhibitor_proxy_GetReason (BudgieInhibitor* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp1_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.Inhibitor", "GetReason");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_object_unref (_reply_message);
	return _result;
}


static void budgie_inhibitor_proxy_budgie_inhibitor_interface_init (BudgieInhibitorIface* iface) {
	iface->GetAppId = budgie_inhibitor_proxy_GetAppId;
	iface->GetReason = budgie_inhibitor_proxy_GetReason;
}


static void _dbus_budgie_inhibitor_GetAppId (BudgieInhibitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_inhibitor_GetAppId (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_inhibitor_GetReason (BudgieInhibitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_inhibitor_GetReason (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_inhibitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetAppId") == 0) {
		_dbus_budgie_inhibitor_GetAppId (object, parameters, invocation);
	} else if (strcmp (method_name, "GetReason") == 0) {
		_dbus_budgie_inhibitor_GetReason (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_inhibitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_inhibitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_inhibitor_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_inhibitor_dbus_interface_info), &_budgie_inhibitor_dbus_interface_vtable, data, _budgie_inhibitor_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_inhibitor_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


GType budgie_dialog_type_get_type (void) {
	static volatile gsize budgie_dialog_type_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_dialog_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BUDGIE_DIALOG_TYPE_LOGOUT, "BUDGIE_DIALOG_TYPE_LOGOUT", "logout"}, {BUDGIE_DIALOG_TYPE_SHUTDOWN, "BUDGIE_DIALOG_TYPE_SHUTDOWN", "shutdown"}, {BUDGIE_DIALOG_TYPE_RESTART, "BUDGIE_DIALOG_TYPE_RESTART", "restart"}, {BUDGIE_DIALOG_TYPE_UPDATE_RESTART, "BUDGIE_DIALOG_TYPE_UPDATE_RESTART", "update-restart"}, {0, NULL, NULL}};
		GType budgie_dialog_type_type_id;
		budgie_dialog_type_type_id = g_enum_register_static ("BudgieDialogType", values);
		g_once_init_leave (&budgie_dialog_type_type_id__volatile, budgie_dialog_type_type_id);
	}
	return budgie_dialog_type_type_id__volatile;
}


static void budgie_end_session_dialog_cancel_clicked (BudgieEndSessionDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "canceled");
	g_signal_emit_by_name (self, "closed");
	gtk_widget_hide ((GtkWidget*) self);
}


static void _budgie_end_session_dialog_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_end_session_dialog_cancel_clicked ((BudgieEndSessionDialog*) self);
}


static void budgie_end_session_dialog_logout_clicked (BudgieEndSessionDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "closed");
	g_signal_emit_by_name (self, "confirmed-logout");
}


static void _budgie_end_session_dialog_logout_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_end_session_dialog_logout_clicked ((BudgieEndSessionDialog*) self);
}


static void budgie_end_session_dialog_restart_clicked (BudgieEndSessionDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "closed");
	g_signal_emit_by_name (self, "confirmed-reboot");
}


static void _budgie_end_session_dialog_restart_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_end_session_dialog_restart_clicked ((BudgieEndSessionDialog*) self);
}


static void budgie_end_session_dialog_shutdown_clicked (BudgieEndSessionDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "closed");
	g_signal_emit_by_name (self, "confirmed-shutdown");
}


static void _budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	budgie_end_session_dialog_shutdown_clicked ((BudgieEndSessionDialog*) self);
}


static void budgie_end_session_dialog_on_bus_acquired (BudgieEndSessionDialog* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		_tmp0_ = conn;
		budgie_end_session_dialog_register_object (self, _tmp0_, "/com/solus_project/Session/EndSessionDialog", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("endsession.vala:97: Cannot register EndSessionDialog");
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_end_session_dialog_on_bus_acquired ((BudgieEndSessionDialog*) self, connection);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda4_ (BudgieEndSessionDialog* self) {
	gboolean result = FALSE;
	budgie_end_session_dialog_cancel_clicked (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda4__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda4_ ((BudgieEndSessionDialog*) self);
	return result;
}


BudgieEndSessionDialog* budgie_end_session_dialog_construct (GType object_type) {
	BudgieEndSessionDialog * self = NULL;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkVisual* _tmp2_ = NULL;
	GdkVisual* _tmp3_ = NULL;
	GdkVisual* _tmp4_ = NULL;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	self = (BudgieEndSessionDialog*) g_object_new (object_type, NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "com.solus_project.Session.EndSessionDialog", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_has_resize_grip ((GtkWindow*) self, FALSE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_ = NULL;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp6_);
	header = _tmp6_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp7_, "titlebar");
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda4__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (header);
	_g_object_unref0 (visual);
	return self;
}


BudgieEndSessionDialog* budgie_end_session_dialog_new (void) {
	return budgie_end_session_dialog_construct (BUDGIE_TYPE_END_SESSION_DIALOG);
}


void budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1) {
	GtkWidget* main_show = NULL;
	GtkWidget* all_widgets[3] = {0};
	GtkButton* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_[3] = {0};
	gchar* title = NULL;
	guint _tmp7_ = 0U;
	const gchar* _tmp15_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkWidget* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	main_show = NULL;
	_tmp0_ = self->priv->button_logout;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->button_restart;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = self->priv->button_shutdown;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp3_;
	_tmp6_[2] = _tmp5_;
	memcpy (all_widgets, _tmp6_, 3 * sizeof (GtkWidget*));
	title = NULL;
	_tmp7_ = type;
	switch (_tmp7_) {
		case BUDGIE_DIALOG_TYPE_LOGOUT:
		{
			GtkButton* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp8_ = self->priv->button_logout;
			main_show = (GtkWidget*) _tmp8_;
			_tmp9_ = _ ("Log out");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (title);
			title = _tmp10_;
			break;
		}
		case BUDGIE_DIALOG_TYPE_RESTART:
		case BUDGIE_DIALOG_TYPE_UPDATE_RESTART:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			GtkButton* _tmp13_ = NULL;
			_tmp11_ = _ ("Restart device");
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (title);
			title = _tmp12_;
			_tmp13_ = self->priv->button_restart;
			main_show = (GtkWidget*) _tmp13_;
			break;
		}
		case BUDGIE_DIALOG_TYPE_SHUTDOWN:
		{
			GtkButton* _tmp14_ = NULL;
			_tmp14_ = self->priv->button_shutdown;
			main_show = (GtkWidget*) _tmp14_;
			break;
		}
		default:
		{
			main_show = NULL;
			break;
		}
	}
	_tmp15_ = title;
	if (_tmp15_ == NULL) {
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp16_ = _ ("Power Off");
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (title);
		title = _tmp17_;
	}
	_tmp18_ = self->priv->label_end_title;
	_tmp19_ = title;
	gtk_label_set_text (_tmp18_, _tmp19_);
	_tmp20_ = main_show;
	if (_tmp20_ != NULL) {
		GtkWidget* _tmp29_ = NULL;
		GtkWidget* _tmp30_ = NULL;
		GtkWidget* _tmp31_ = NULL;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					gint _tmp23_ = 0;
					GtkWidget* w = NULL;
					gint _tmp24_ = 0;
					GtkWidget* _tmp25_ = NULL;
					GtkWidget* _tmp26_ = NULL;
					GtkWidget* _tmp27_ = NULL;
					GtkWidget* _tmp28_ = NULL;
					if (!_tmp21_) {
						gint _tmp22_ = 0;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp21_ = FALSE;
					_tmp23_ = i;
					if (!(_tmp23_ < 3)) {
						break;
					}
					_tmp24_ = i;
					_tmp25_ = all_widgets[_tmp24_];
					w = _tmp25_;
					_tmp26_ = main_show;
					_tmp27_ = w;
					if (_tmp26_ == _tmp27_) {
						continue;
					}
					_tmp28_ = w;
					gtk_widget_hide (_tmp28_);
				}
			}
		}
		_tmp29_ = main_show;
		gtk_widget_show (_tmp29_);
		_tmp30_ = main_show;
		_tmp31_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp30_) : NULL);
		gtk_widget_show (_tmp31_);
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					gint _tmp34_ = 0;
					GtkWidget* w = NULL;
					gint _tmp35_ = 0;
					GtkWidget* _tmp36_ = NULL;
					GtkWidget* _tmp37_ = NULL;
					GtkWidget* _tmp38_ = NULL;
					GtkWidget* _tmp39_ = NULL;
					if (!_tmp32_) {
						gint _tmp33_ = 0;
						_tmp33_ = i;
						i = _tmp33_ + 1;
					}
					_tmp32_ = FALSE;
					_tmp34_ = i;
					if (!(_tmp34_ < 3)) {
						break;
					}
					_tmp35_ = i;
					_tmp36_ = all_widgets[_tmp35_];
					w = _tmp36_;
					_tmp37_ = w;
					gtk_widget_show (_tmp37_);
					_tmp38_ = w;
					_tmp39_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp38_) : NULL);
					gtk_widget_show (_tmp39_);
				}
			}
		}
	}
	gtk_window_present ((GtkWindow*) self);
	_g_free0 (title);
	_vala_array_destroy (all_widgets, 3, (GDestroyNotify) g_object_unref);
}


void budgie_end_session_dialog_Close (BudgieEndSessionDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_signal_emit_by_name (self, "closed");
}


static void budgie_end_session_dialog_class_init (BudgieEndSessionDialogClass * klass) {
	gint BudgieEndSessionDialog_private_offset;
	budgie_end_session_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieEndSessionDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_end_session_dialog_finalize;
	BudgieEndSessionDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/endsession/endsession.ui");
	g_signal_new ("confirmed_logout", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("confirmed_reboot", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("confirmed_shutdown", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("canceled", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("closed", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_cancel", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_cancel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_logout", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_logout));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_restart", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_restart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_shutdown", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_shutdown));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_end_title", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, label_end_title));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_clicked", G_CALLBACK(_budgie_end_session_dialog_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "logout_clicked", G_CALLBACK(_budgie_end_session_dialog_logout_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "restart_clicked", G_CALLBACK(_budgie_end_session_dialog_restart_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "shutdown_clicked", G_CALLBACK(_budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked));
}


static void budgie_end_session_dialog_instance_init (BudgieEndSessionDialog * self) {
	self->priv = BUDGIE_END_SESSION_DIALOG_GET_PRIVATE (self);
	self->priv->showing = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_end_session_dialog_finalize (GObject* obj) {
	BudgieEndSessionDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog);
	_g_object_unref0 (self->priv->button_cancel);
	_g_object_unref0 (self->priv->button_logout);
	_g_object_unref0 (self->priv->button_restart);
	_g_object_unref0 (self->priv->button_shutdown);
	_g_object_unref0 (self->priv->label_end_title);
	G_OBJECT_CLASS (budgie_end_session_dialog_parent_class)->finalize (obj);
}


GType budgie_end_session_dialog_get_type (void) {
	static volatile gsize budgie_end_session_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_end_session_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieEndSessionDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_end_session_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieEndSessionDialog), 0, (GInstanceInitFunc) budgie_end_session_dialog_instance_init, NULL };
		GType budgie_end_session_dialog_type_id;
		budgie_end_session_dialog_type_id = g_type_register_static (gtk_window_get_type (), "BudgieEndSessionDialog", &g_define_type_info, 0);
		g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_end_session_dialog_register_object);
		g_once_init_leave (&budgie_end_session_dialog_type_id__volatile, budgie_end_session_dialog_type_id);
	}
	return budgie_end_session_dialog_type_id__volatile;
}


static void _dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint type = 0U;
	GVariant* _tmp2_;
	guint timestamp = 0U;
	GVariant* _tmp3_;
	guint open_length = 0U;
	GVariant* _tmp4_;
	char** inhibiters = NULL;
	int inhibiters_length1 = 0;
	GVariant* _tmp5_;
	char** _tmp6_;
	int _tmp6__length;
	int _tmp6__size;
	int _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	open_length = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (char*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (char*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	inhibiters_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	inhibiters = _tmp6_;
	g_variant_unref (_tmp5_);
	budgie_end_session_dialog_Open (self, type, timestamp, open_length, inhibiters, inhibiters_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	inhibiters = (_vala_array_free (inhibiters, inhibiters_length1, (GDestroyNotify) g_free), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_end_session_dialog_Close (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Open") == 0) {
		_dbus_budgie_end_session_dialog_Open (object, parameters, invocation);
	} else if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_end_session_dialog_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedLogout", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedReboot", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedShutdown", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_canceled (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "Canceled", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_closed (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "Closed", _arguments, NULL);
}


guint budgie_end_session_dialog_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_end_session_dialog_dbus_interface_info), &_budgie_end_session_dialog_dbus_interface_vtable, data, _budgie_end_session_dialog_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "confirmed-logout", (GCallback) _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_connect (object, "confirmed-reboot", (GCallback) _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_connect (object, "confirmed-shutdown", (GCallback) _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_connect (object, "canceled", (GCallback) _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_connect (object, "closed", (GCallback) _dbus_budgie_end_session_dialog_closed, data);
	return result;
}


static void _budgie_end_session_dialog_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



