/* BudgieMenuWindow.c generated by valac 0.32.1, the Vala compiler
 * generated from BudgieMenuWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gmenu-tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define TYPE_CATEGORY_BUTTON (category_button_get_type ())
#define CATEGORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CATEGORY_BUTTON, CategoryButton))
#define CATEGORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CATEGORY_BUTTON, CategoryButtonClass))
#define IS_CATEGORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CATEGORY_BUTTON))
#define IS_CATEGORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CATEGORY_BUTTON))
#define CATEGORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CATEGORY_BUTTON, CategoryButtonClass))

typedef struct _CategoryButton CategoryButton;
typedef struct _CategoryButtonClass CategoryButtonClass;
typedef struct _CategoryButtonPrivate CategoryButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MENU_BUTTON (menu_button_get_type ())
#define MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BUTTON, MenuButton))
#define MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BUTTON, MenuButtonClass))
#define IS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BUTTON))
#define IS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BUTTON))
#define MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BUTTON, MenuButtonClass))

typedef struct _MenuButton MenuButton;
typedef struct _MenuButtonClass MenuButtonClass;
typedef struct _MenuButtonPrivate MenuButtonPrivate;

#define TYPE_BUDGIE_MENU_WINDOW (budgie_menu_window_get_type ())
#define BUDGIE_MENU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow))
#define BUDGIE_MENU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindowClass))
#define IS_BUDGIE_MENU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUDGIE_MENU_WINDOW))
#define IS_BUDGIE_MENU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUDGIE_MENU_WINDOW))
#define BUDGIE_MENU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindowClass))

typedef struct _BudgieMenuWindow BudgieMenuWindow;
typedef struct _BudgieMenuWindowClass BudgieMenuWindowClass;
typedef struct _BudgieMenuWindowPrivate BudgieMenuWindowPrivate;
#define __vala_GMenuTreeDirectory_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeDirectory_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __vala_GMenuTreeEntry_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeEntry_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_GMenuTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeIter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _CategoryButton {
	GtkRadioButton parent_instance;
	CategoryButtonPrivate * priv;
};

struct _CategoryButtonClass {
	GtkRadioButtonClass parent_class;
};

struct _CategoryButtonPrivate {
	GMenuTreeDirectory* _group;
};

struct _MenuButton {
	GtkButton parent_instance;
	MenuButtonPrivate * priv;
};

struct _MenuButtonClass {
	GtkButtonClass parent_class;
};

struct _MenuButtonPrivate {
	GDesktopAppInfo* _info;
	GMenuTreeDirectory* _parent_menu;
	gint _score;
};

struct _BudgieMenuWindow {
	GtkPopover parent_instance;
	BudgieMenuWindowPrivate * priv;
	GtkSearchEntry* search_entry;
	GtkBox* categories;
	GtkListBox* content;
	GtkScrolledWindow* categories_scroll;
	GtkScrolledWindow* content_scroll;
	CategoryButton* all_categories;
	GMenuTreeDirectory* group;
	gboolean compact_mode;
	gboolean rollover_menus;
	gchar* search_term;
	gint icon_size;
};

struct _BudgieMenuWindowClass {
	GtkPopoverClass parent_class;
};

struct _BudgieMenuWindowPrivate {
	GMenuTree* tree;
	GSettings* _settings;
	gboolean reloading;
	GRecMutex __lock_reloading;
};

struct _Block1Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	CategoryButton* btn;
};

struct _Block2Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	MenuButton* btn;
};

struct _Block3Data {
	int _ref_count_;
	BudgieMenuWindow* self;
	GDesktopAppInfo* info;
};


static gpointer category_button_parent_class = NULL;
static GType category_button_type_id = 0;
static gpointer menu_button_parent_class = NULL;
static GType menu_button_type_id = 0;
static gpointer budgie_menu_window_parent_class = NULL;
static GType budgie_menu_window_type_id = 0;

#define APPS_ID "gnome-applications.menu"
#define LOGOUT_BINARY "budgie-session-dialog"
GType category_button_get_type (void) G_GNUC_CONST;
GType category_button_register_type (GTypeModule * module);
#define CATEGORY_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CATEGORY_BUTTON, CategoryButtonPrivate))
enum  {
	CATEGORY_BUTTON_DUMMY_PROPERTY,
	CATEGORY_BUTTON_GROUP
};
CategoryButton* category_button_new (GMenuTreeDirectory* parent);
CategoryButton* category_button_construct (GType object_type, GMenuTreeDirectory* parent);
void category_button_set_group (CategoryButton* self, GMenuTreeDirectory* value);
GMenuTreeDirectory* category_button_get_group (CategoryButton* self);
static void category_button_finalize (GObject* obj);
static void _vala_category_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_category_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType menu_button_get_type (void) G_GNUC_CONST;
GType menu_button_register_type (GTypeModule * module);
#define MENU_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MENU_BUTTON, MenuButtonPrivate))
enum  {
	MENU_BUTTON_DUMMY_PROPERTY,
	MENU_BUTTON_INFO,
	MENU_BUTTON_PARENT_MENU,
	MENU_BUTTON_SCORE
};
MenuButton* menu_button_new (GDesktopAppInfo* parent, GMenuTreeDirectory* directory, gint icon_size);
MenuButton* menu_button_construct (GType object_type, GDesktopAppInfo* parent, GMenuTreeDirectory* directory, gint icon_size);
void menu_button_set_info (MenuButton* self, GDesktopAppInfo* value);
void menu_button_set_parent_menu (MenuButton* self, GMenuTreeDirectory* value);
void menu_button_set_score (MenuButton* self, gint value);
GDesktopAppInfo* menu_button_get_info (MenuButton* self);
GMenuTreeDirectory* menu_button_get_parent_menu (MenuButton* self);
gint menu_button_get_score (MenuButton* self);
static void menu_button_finalize (GObject* obj);
static void _vala_menu_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_menu_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType budgie_menu_window_get_type (void) G_GNUC_CONST;
GType budgie_menu_window_register_type (GTypeModule * module);
#define BUDGIE_MENU_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindowPrivate))
enum  {
	BUDGIE_MENU_WINDOW_DUMMY_PROPERTY,
	BUDGIE_MENU_WINDOW_SETTINGS
};
static void _vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self);
void budgie_menu_window_refresh_tree (BudgieMenuWindow* self);
static gboolean budgie_menu_window_on_mouse_enter (BudgieMenuWindow* self, GtkWidget* source_widget, GdkEventCrossing* e);
static gboolean __lambda4_ (BudgieMenuWindow* self);
static void budgie_menu_window_load_menus (BudgieMenuWindow* self, GMenuTreeDirectory* tree_root);
void budgie_menu_window_apply_scores (BudgieMenuWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean ___lambda5_ (BudgieMenuWindow* self);
static void _budgie_menu_window_refresh_tree_gmenu_tree_changed (GMenuTree* _sender, gpointer self);
static gboolean ____lambda5__gsource_func (gpointer self);
static GMenuTreeDirectory* _vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self);
static GMenuTreeItemType* _gmenu_tree_item_type_dup (GMenuTreeItemType* self);
static gboolean _gmenu_tree_item_type_equal (const GMenuTreeItemType* s1, const GMenuTreeItemType* s2);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void ____lambda6_ (Block1Data* _data1_);
void budgie_menu_window_update_category (BudgieMenuWindow* self, CategoryButton* btn);
static void _____lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _vala_GMenuTreeEntry_free (GMenuTreeEntry* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ______lambda7_ (Block2Data* _data2_);
void budgie_menu_window_launch_app (BudgieMenuWindow* self, GDesktopAppInfo* info);
void budgie_menu_window_save_scores (BudgieMenuWindow* self);
static void _______lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _vala_GMenuTreeIter_free (GMenuTreeIter* self);
void budgie_menu_window_unwrap_score (BudgieMenuWindow* self, GVariant* v, gchar** s, gint* i);
GSettings* budgie_menu_window_get_settings (BudgieMenuWindow* self);
static void _g_free0_ (gpointer var);
GVariant* budgie_menu_window_mktuple (BudgieMenuWindow* self, const gchar* text, gint val);
static void _vala_array_add1 (GVariant*** array, int* length, int* size, GVariant* value);
BudgieMenuWindow* budgie_menu_window_new (GSettings* settings, GtkWidget* leparent);
BudgieMenuWindow* budgie_menu_window_construct (GType object_type, GSettings* settings, GtkWidget* leparent);
static void __lambda9_ (BudgieMenuWindow* self);
static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
void budgie_menu_window_on_row_activate (BudgieMenuWindow* self, GtkListBoxRow* row);
static void _budgie_menu_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void budgie_menu_window_on_settings_changed (BudgieMenuWindow* self, const gchar* key);
static void _budgie_menu_window_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
gboolean budgie_menu_window_do_filter_list (BudgieMenuWindow* self, GtkListBoxRow* row);
static gboolean _budgie_menu_window_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
gint budgie_menu_window_do_sort_list (BudgieMenuWindow* self, GtkListBoxRow* row1, GtkListBoxRow* row2);
static gint _budgie_menu_window_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void __lambda10_ (BudgieMenuWindow* self);
static void ___lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self);
void budgie_menu_window_on_entry_activate (BudgieMenuWindow* self);
static void _budgie_menu_window_on_entry_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean __lambda11_ (BudgieMenuWindow* self);
static gboolean ___lambda11__gsource_func (gpointer self);
void budgie_menu_window_do_list_header (BudgieMenuWindow* self, GtkListBoxRow* before, GtkListBoxRow* after);
static void _budgie_menu_window_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block3Data* _data3_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void budgie_menu_window_real_show (GtkWidget* base);
static gboolean __lambda12_ (BudgieMenuWindow* self);
static gboolean ___lambda12__gsource_func (gpointer self);
void budgie_menu_window_set_settings (BudgieMenuWindow* self, GSettings* value);
static void budgie_menu_window_finalize (GObject* obj);
static void _vala_budgie_menu_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_menu_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


CategoryButton* category_button_construct (GType object_type, GMenuTreeDirectory* parent) {
	CategoryButton * self = NULL;
	GtkLabel* lab = NULL;
	GMenuTreeDirectory* _tmp0_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkBox* layout = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GValue _tmp14_ = {0};
	GMenuTreeDirectory* _tmp15_ = NULL;
	self = (CategoryButton*) g_object_new (object_type, NULL);
	_tmp0_ = parent;
	if (_tmp0_ != NULL) {
		GMenuTreeDirectory* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GtkLabel* _tmp3_ = NULL;
		_tmp1_ = parent;
		_tmp2_ = gmenu_tree_directory_get_name (_tmp1_);
		_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (lab);
		lab = _tmp3_;
	} else {
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		_tmp4_ = _ ("All");
		_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (lab);
		lab = _tmp5_;
	}
	_tmp6_ = lab;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	_tmp7_ = lab;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	_tmp8_ = lab;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 10);
	_tmp9_ = lab;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 15);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp10_);
	layout = _tmp10_;
	_tmp11_ = lab;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp12_, "flat");
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp13_, "category-button");
	g_value_init (&_tmp14_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp14_, FALSE);
	g_object_set_property ((GObject*) self, "draw-indicator", &_tmp14_);
	G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp15_ = parent;
	category_button_set_group (self, _tmp15_);
	_g_object_unref0 (layout);
	_g_object_unref0 (lab);
	return self;
}


CategoryButton* category_button_new (GMenuTreeDirectory* parent) {
	return category_button_construct (TYPE_CATEGORY_BUTTON, parent);
}


GMenuTreeDirectory* category_button_get_group (CategoryButton* self) {
	GMenuTreeDirectory* result;
	GMenuTreeDirectory* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}


void category_button_set_group (CategoryButton* self, GMenuTreeDirectory* value) {
	GMenuTreeDirectory* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_group = _tmp0_;
	g_object_notify ((GObject *) self, "group");
}


static void category_button_class_init (CategoryButtonClass * klass) {
	category_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CategoryButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_category_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_category_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = category_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CATEGORY_BUTTON_GROUP, g_param_spec_boxed ("group", "group", "group", gmenu_tree_directory_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void category_button_instance_init (CategoryButton * self) {
	self->priv = CATEGORY_BUTTON_GET_PRIVATE (self);
}


static void category_button_finalize (GObject* obj) {
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CATEGORY_BUTTON, CategoryButton);
	G_OBJECT_CLASS (category_button_parent_class)->finalize (obj);
}


/**
 * Factory widget to represent a category
 */
GType category_button_get_type (void) {
	return category_button_type_id;
}


GType category_button_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CategoryButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) category_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CategoryButton), 0, (GInstanceInitFunc) category_button_instance_init, NULL };
	category_button_type_id = g_type_module_register_type (module, gtk_radio_button_get_type (), "CategoryButton", &g_define_type_info, 0);
	return category_button_type_id;
}


static void _vala_category_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_GROUP:
		g_value_set_boxed (value, category_button_get_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_category_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_GROUP:
		category_button_set_group (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MenuButton* menu_button_construct (GType object_type, GDesktopAppInfo* parent, GMenuTreeDirectory* directory, gint icon_size) {
	MenuButton * self = NULL;
	GtkImage* img = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GIcon* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkLabel* lab = NULL;
	GDesktopAppInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkBox* layout = NULL;
	GtkBox* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	GMenuTreeDirectory* _tmp9_ = NULL;
	GDesktopAppInfo* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	self = (MenuButton*) g_object_new (object_type, NULL);
	_tmp0_ = parent;
	_tmp1_ = g_app_info_get_icon ((GAppInfo*) _tmp0_);
	_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (_tmp1_, GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp2_);
	img = _tmp2_;
	_tmp3_ = icon_size;
	gtk_image_set_pixel_size (img, _tmp3_);
	gtk_widget_set_margin_end ((GtkWidget*) img, 7);
	_tmp4_ = parent;
	_tmp5_ = g_app_info_get_display_name ((GAppInfo*) _tmp4_);
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	lab = _tmp6_;
	gtk_widget_set_halign ((GtkWidget*) lab, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) lab, GTK_ALIGN_CENTER);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	layout = _tmp7_;
	gtk_box_pack_start (layout, (GtkWidget*) img, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (layout, (GtkWidget*) lab, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp8_ = parent;
	menu_button_set_info (self, _tmp8_);
	_tmp9_ = directory;
	menu_button_set_parent_menu (self, _tmp9_);
	_tmp10_ = parent;
	_tmp11_ = g_app_info_get_description ((GAppInfo*) _tmp10_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp11_);
	menu_button_set_score (self, 0);
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp12_, "flat");
	_g_object_unref0 (layout);
	_g_object_unref0 (lab);
	_g_object_unref0 (img);
	return self;
}


MenuButton* menu_button_new (GDesktopAppInfo* parent, GMenuTreeDirectory* directory, gint icon_size) {
	return menu_button_construct (TYPE_MENU_BUTTON, parent, directory, icon_size);
}


GDesktopAppInfo* menu_button_get_info (MenuButton* self) {
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}


void menu_button_set_info (MenuButton* self, GDesktopAppInfo* value) {
	GDesktopAppInfo* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_info = _tmp0_;
	g_object_notify ((GObject *) self, "info");
}


GMenuTreeDirectory* menu_button_get_parent_menu (MenuButton* self) {
	GMenuTreeDirectory* result;
	GMenuTreeDirectory* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_menu;
	result = _tmp0_;
	return result;
}


void menu_button_set_parent_menu (MenuButton* self, GMenuTreeDirectory* value) {
	GMenuTreeDirectory* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parent_menu = _tmp0_;
	g_object_notify ((GObject *) self, "parent-menu");
}


gint menu_button_get_score (MenuButton* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void menu_button_set_score (MenuButton* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_score = _tmp0_;
	g_object_notify ((GObject *) self, "score");
}


static void menu_button_class_init (MenuButtonClass * klass) {
	menu_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MenuButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_menu_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_menu_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = menu_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_INFO, g_param_spec_object ("info", "info", "info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_PARENT_MENU, g_param_spec_boxed ("parent-menu", "parent-menu", "parent-menu", gmenu_tree_directory_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_SCORE, g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void menu_button_instance_init (MenuButton * self) {
	self->priv = MENU_BUTTON_GET_PRIVATE (self);
}


static void menu_button_finalize (GObject* obj) {
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MENU_BUTTON, MenuButton);
	G_OBJECT_CLASS (menu_button_parent_class)->finalize (obj);
}


/**
 * Factory widget to represent a menu item
 */
GType menu_button_get_type (void) {
	return menu_button_type_id;
}


GType menu_button_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MenuButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) menu_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MenuButton), 0, (GInstanceInitFunc) menu_button_instance_init, NULL };
	menu_button_type_id = g_type_module_register_type (module, gtk_button_get_type (), "MenuButton", &g_define_type_info, 0);
	return menu_button_type_id;
}


static void _vala_menu_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_INFO:
		g_value_set_object (value, menu_button_get_info (self));
		break;
		case MENU_BUTTON_PARENT_MENU:
		g_value_set_boxed (value, menu_button_get_parent_menu (self));
		break;
		case MENU_BUTTON_SCORE:
		g_value_set_int (value, menu_button_get_score (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_menu_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_INFO:
		menu_button_set_info (self, g_value_get_object (value));
		break;
		case MENU_BUTTON_PARENT_MENU:
		menu_button_set_parent_menu (self, g_value_get_boxed (value));
		break;
		case MENU_BUTTON_SCORE:
		menu_button_set_score (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self) {
	g_boxed_free (gmenu_tree_directory_get_type (), self);
}


static gboolean __lambda4_ (BudgieMenuWindow* self) {
	gboolean result = FALSE;
	budgie_menu_window_load_menus (self, NULL);
	budgie_menu_window_apply_scores (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((BudgieMenuWindow*) self);
	return result;
}


void budgie_menu_window_refresh_tree (BudgieMenuWindow* self) {
	GtkListBox* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GMenuTree* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->reloading;
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->reloading;
			if (_tmp1_) {
				{
					gboolean _tmp2_ = FALSE;
					_tmp2_ = self->priv->reloading;
					g_rec_mutex_unlock (&self->priv->__lock_reloading);
				}
				return;
			}
			self->priv->reloading = TRUE;
		}
		__finally0:
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = self->priv->reloading;
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = self->content;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp6_ = NULL;
				_tmp6_ = child;
				gtk_widget_destroy (_tmp6_);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp7_ = self->categories;
	_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp8_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp9_ = NULL;
				CategoryButton* _tmp10_ = NULL;
				_tmp9_ = child;
				_tmp10_ = self->all_categories;
				if (_tmp9_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget)) {
					GtkWidget* _tmp11_ = NULL;
					GtkWidget* _tmp12_ = NULL;
					_tmp11_ = child;
					g_signal_handlers_disconnect_by_func (_tmp11_, (void*) budgie_menu_window_on_mouse_enter, self);
					_tmp12_ = child;
					gtk_widget_destroy (_tmp12_);
				}
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp13_ = self->priv->tree;
	g_signal_handlers_disconnect_by_func (_tmp13_, (void*) budgie_menu_window_refresh_tree, self);
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = self->priv->reloading;
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			self->priv->reloading = FALSE;
		}
		__finally1:
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = self->priv->reloading;
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Permits "rolling" over categories
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean budgie_menu_window_on_mouse_enter (BudgieMenuWindow* self, GtkWidget* source_widget, GdkEventCrossing* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* b = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_widget != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->rollover_menus;
	if (!_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = source_widget;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp1_) : NULL);
	b = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp4_);
	if (!_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		GtkToggleButton* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = b;
		_tmp7_ = gtk_widget_get_visible ((GtkWidget*) _tmp6_);
		_tmp3_ = !_tmp7_;
	}
	if (_tmp3_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (b);
		return result;
	}
	_tmp8_ = source_widget;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp8_) : NULL, TRUE);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (b);
	return result;
}


/**
     * Load "menus" (.desktop's) recursively (ripped from our RunDialog)
     * 
     * @param tree_root Initialised GMenu.TreeDirectory, or null
     */
static void _budgie_menu_window_refresh_tree_gmenu_tree_changed (GMenuTree* _sender, gpointer self) {
	budgie_menu_window_refresh_tree ((BudgieMenuWindow*) self);
}


static gboolean ___lambda5_ (BudgieMenuWindow* self) {
	gboolean result = FALSE;
	GMenuTree* _tmp0_ = NULL;
	_tmp0_ = self->priv->tree;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _budgie_menu_window_refresh_tree_gmenu_tree_changed, self, 0);
	result = FALSE;
	return result;
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((BudgieMenuWindow*) self);
	return result;
}


static GMenuTreeDirectory* _vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self) {
	return g_boxed_copy (gmenu_tree_directory_get_type (), self);
}


static gpointer __vala_GMenuTreeDirectory_copy0 (gpointer self) {
	return self ? _vala_GMenuTreeDirectory_copy (self) : NULL;
}


static GMenuTreeItemType* _gmenu_tree_item_type_dup (GMenuTreeItemType* self) {
	GMenuTreeItemType* dup;
	dup = g_new0 (GMenuTreeItemType, 1);
	memcpy (dup, self, sizeof (GMenuTreeItemType));
	return dup;
}


static gpointer __gmenu_tree_item_type_dup0 (gpointer self) {
	return self ? _gmenu_tree_item_type_dup (self) : NULL;
}


static gboolean _gmenu_tree_item_type_equal (const GMenuTreeItemType* s1, const GMenuTreeItemType* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->btn);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = budgie_menu_window_on_mouse_enter ((BudgieMenuWindow*) self, _sender, event);
	return result;
}


static void ____lambda6_ (Block1Data* _data1_) {
	BudgieMenuWindow* self;
	CategoryButton* _tmp0_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->btn;
	budgie_menu_window_update_category (self, _tmp0_);
}


static void _____lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	____lambda6_ (self);
}


static void _vala_GMenuTreeEntry_free (GMenuTreeEntry* self) {
	g_boxed_free (gmenu_tree_entry_get_type (), self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->btn);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ______lambda7_ (Block2Data* _data2_) {
	BudgieMenuWindow* self;
	MenuButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	MenuButton* _tmp3_ = NULL;
	GDesktopAppInfo* _tmp4_ = NULL;
	GDesktopAppInfo* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GtkListBox* _tmp7_ = NULL;
	self = _data2_->self;
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = _data2_->btn;
	_tmp1_ = menu_button_get_score (_tmp0_);
	_tmp2_ = _tmp1_;
	menu_button_set_score (_tmp0_, _tmp2_ + 1);
	_tmp3_ = _data2_->btn;
	_tmp4_ = menu_button_get_info (_tmp3_);
	_tmp5_ = _tmp4_;
	budgie_menu_window_launch_app (self, _tmp5_);
	_tmp6_ = self->content;
	gtk_list_box_invalidate_sort (_tmp6_);
	_tmp7_ = self->content;
	gtk_list_box_invalidate_headers (_tmp7_);
	budgie_menu_window_save_scores (self);
}


static void _______lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda7_ (self);
}


static void _vala_GMenuTreeIter_free (GMenuTreeIter* self) {
	g_boxed_free (gmenu_tree_iter_get_type (), self);
}


static void budgie_menu_window_load_menus (BudgieMenuWindow* self, GMenuTreeDirectory* tree_root) {
	GMenuTreeDirectory* root = NULL;
	GMenuTree* _tmp0_ = NULL;
	GMenuTreeDirectory* _tmp8_ = NULL;
	GMenuTreeIter* it = NULL;
	GMenuTreeDirectory* _tmp13_ = NULL;
	GMenuTreeIter* _tmp14_ = NULL;
	GMenuTreeItemType* type = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	if (_tmp0_ == NULL) {
		GMenuTree* _tmp1_ = NULL;
		_tmp1_ = gmenu_tree_new (APPS_ID, GMENU_TREE_FLAGS_SORT_DISPLAY_NAME);
		_g_object_unref0 (self->priv->tree);
		self->priv->tree = _tmp1_;
		{
			GMenuTree* _tmp2_ = NULL;
			_tmp2_ = self->priv->tree;
			gmenu_tree_load_sync (_tmp2_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = stderr;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			fprintf (_tmp3_, "Error: %s\n", _tmp5_);
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = self->priv->reloading;
				g_rec_mutex_lock (&self->priv->__lock_reloading);
				{
					self->priv->reloading = FALSE;
				}
				__finally3:
				{
					gboolean _tmp7_ = FALSE;
					_tmp7_ = self->priv->reloading;
					g_rec_mutex_unlock (&self->priv->__lock_reloading);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_error_free0 (e);
					_g_error_free0 (e);
					__vala_GMenuTreeDirectory_free0 (root);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_error_free0 (e);
			__vala_GMenuTreeDirectory_free0 (root);
			return;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			__vala_GMenuTreeDirectory_free0 (root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp8_ = tree_root;
	if (_tmp8_ == NULL) {
		GMenuTree* _tmp9_ = NULL;
		GMenuTreeDirectory* _tmp10_ = NULL;
		_tmp9_ = self->priv->tree;
		_tmp10_ = gmenu_tree_get_root_directory (_tmp9_);
		__vala_GMenuTreeDirectory_free0 (root);
		root = _tmp10_;
	} else {
		GMenuTreeDirectory* _tmp11_ = NULL;
		GMenuTreeDirectory* _tmp12_ = NULL;
		_tmp11_ = tree_root;
		_tmp12_ = __vala_GMenuTreeDirectory_copy0 (_tmp11_);
		__vala_GMenuTreeDirectory_free0 (root);
		root = _tmp12_;
	}
	_tmp13_ = root;
	_tmp14_ = gmenu_tree_directory_iter (_tmp13_);
	it = _tmp14_;
	while (TRUE) {
		GMenuTreeIter* _tmp15_ = NULL;
		GMenuTreeItemType _tmp16_ = 0;
		GMenuTreeItemType* _tmp17_ = NULL;
		GMenuTreeItemType* _tmp18_ = NULL;
		GMenuTreeItemType _tmp19_ = 0;
		GMenuTreeItemType* _tmp20_ = NULL;
		GMenuTreeItemType _tmp21_ = 0;
		_tmp15_ = it;
		_tmp16_ = gmenu_tree_iter_next (_tmp15_);
		_tmp17_ = __gmenu_tree_item_type_dup0 (&_tmp16_);
		_g_free0 (type);
		type = _tmp17_;
		_tmp18_ = type;
		_tmp19_ = GMENU_TREE_ITEM_INVALID;
		if (!(_gmenu_tree_item_type_equal (_tmp18_, &_tmp19_) != TRUE)) {
			break;
		}
		_tmp20_ = type;
		_tmp21_ = GMENU_TREE_ITEM_DIRECTORY;
		if (_gmenu_tree_item_type_equal (_tmp20_, &_tmp21_) == TRUE) {
			Block1Data* _data1_;
			GMenuTreeDirectory* dir = NULL;
			GMenuTreeIter* _tmp22_ = NULL;
			GMenuTreeDirectory* _tmp23_ = NULL;
			GMenuTreeDirectory* _tmp24_ = NULL;
			CategoryButton* _tmp25_ = NULL;
			CategoryButton* _tmp26_ = NULL;
			CategoryButton* _tmp27_ = NULL;
			CategoryButton* _tmp28_ = NULL;
			GtkBox* _tmp29_ = NULL;
			CategoryButton* _tmp30_ = NULL;
			CategoryButton* _tmp31_ = NULL;
			GMenuTreeDirectory* _tmp32_ = NULL;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp22_ = it;
			_tmp23_ = gmenu_tree_iter_get_directory (_tmp22_);
			dir = _tmp23_;
			_tmp24_ = dir;
			_tmp25_ = category_button_new (_tmp24_);
			g_object_ref_sink (_tmp25_);
			_data1_->btn = _tmp25_;
			_tmp26_ = _data1_->btn;
			_tmp27_ = self->all_categories;
			gtk_radio_button_join_group ((GtkRadioButton*) _tmp26_, (GtkRadioButton*) _tmp27_);
			_tmp28_ = _data1_->btn;
			g_signal_connect_object ((GtkWidget*) _tmp28_, "enter-notify-event", (GCallback) _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
			_tmp29_ = self->categories;
			_tmp30_ = _data1_->btn;
			gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
			_tmp31_ = _data1_->btn;
			g_signal_connect_data ((GtkToggleButton*) _tmp31_, "toggled", (GCallback) _____lambda6__gtk_toggle_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp32_ = dir;
			budgie_menu_window_load_menus (self, _tmp32_);
			__vala_GMenuTreeDirectory_free0 (dir);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			GMenuTreeItemType* _tmp33_ = NULL;
			GMenuTreeItemType _tmp34_ = 0;
			_tmp33_ = type;
			_tmp34_ = GMENU_TREE_ITEM_ENTRY;
			if (_gmenu_tree_item_type_equal (_tmp33_, &_tmp34_) == TRUE) {
				GDesktopAppInfo* appinfo = NULL;
				GMenuTreeIter* _tmp35_ = NULL;
				GMenuTreeEntry* _tmp36_ = NULL;
				GMenuTreeEntry* _tmp37_ = NULL;
				GDesktopAppInfo* _tmp38_ = NULL;
				GDesktopAppInfo* _tmp39_ = NULL;
				GDesktopAppInfo* _tmp40_ = NULL;
				GMenuTreeDirectory* _tmp41_ = NULL;
				_tmp35_ = it;
				_tmp36_ = gmenu_tree_iter_get_entry (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = gmenu_tree_entry_get_app_info (_tmp37_);
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_tmp40_ = _tmp39_;
				__vala_GMenuTreeEntry_free0 (_tmp37_);
				appinfo = _tmp40_;
				_tmp41_ = tree_root;
				if (_tmp41_ == NULL) {
					GDesktopAppInfo* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					_tmp42_ = appinfo;
					_tmp43_ = g_app_info_get_display_name ((GAppInfo*) _tmp42_);
					g_warning ("BudgieMenuWindow.vala:217: %s has no parent directory, not adding to m" \
"enu\n", _tmp43_);
				} else {
					Block2Data* _data2_;
					GDesktopAppInfo* _tmp44_ = NULL;
					GMenuTreeDirectory* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					MenuButton* _tmp47_ = NULL;
					MenuButton* _tmp48_ = NULL;
					GtkListBox* _tmp49_ = NULL;
					MenuButton* _tmp50_ = NULL;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->self = g_object_ref (self);
					_tmp44_ = appinfo;
					_tmp45_ = tree_root;
					_tmp46_ = self->icon_size;
					_tmp47_ = menu_button_new (_tmp44_, _tmp45_, _tmp46_);
					g_object_ref_sink (_tmp47_);
					_data2_->btn = _tmp47_;
					_tmp48_ = _data2_->btn;
					g_signal_connect_data ((GtkButton*) _tmp48_, "clicked", (GCallback) _______lambda7__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp49_ = self->content;
					_tmp50_ = _data2_->btn;
					gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
				_g_object_unref0 (appinfo);
			}
		}
	}
	_g_free0 (type);
	__vala_GMenuTreeIter_free0 (it);
	__vala_GMenuTreeDirectory_free0 (root);
}


void budgie_menu_window_unwrap_score (BudgieMenuWindow* self, GVariant* v, gchar** s, gint* i) {
	gchar* _vala_s = NULL;
	gint _vala_i = 0;
	GVariant* t = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gint32 _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	t = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = g_variant_get_string (_tmp2_, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_s);
	_vala_s = _tmp4_;
	_tmp5_ = v;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_g_variant_unref0 (t);
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = g_variant_get_int32 (_tmp7_);
	_vala_i = (gint) _tmp8_;
	_g_variant_unref0 (t);
	if (s) {
		*s = _vala_s;
	} else {
		_g_free0 (_vala_s);
	}
	if (i) {
		*i = _vala_i;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void budgie_menu_window_apply_scores (BudgieMenuWindow* self) {
	GVariant* scores = NULL;
	GSettings* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GHashTable* m = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GtkListBox* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	GtkListBox* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "app-scores");
	scores = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, NULL);
	m = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				GVariant* _tmp8_ = NULL;
				gsize _tmp9_ = 0UL;
				GVariant* tupe = NULL;
				GVariant* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				GVariant* _tmp12_ = NULL;
				gchar* dname = NULL;
				gint score = 0;
				GVariant* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				GHashTable* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = scores;
				_tmp9_ = g_variant_n_children (_tmp8_);
				if (!(((gsize) _tmp7_) < _tmp9_)) {
					break;
				}
				_tmp10_ = scores;
				_tmp11_ = i;
				_tmp12_ = g_variant_get_child_value (_tmp10_, (gsize) _tmp11_);
				tupe = _tmp12_;
				_tmp13_ = tupe;
				budgie_menu_window_unwrap_score (self, _tmp13_, &_tmp14_, &_tmp15_);
				_g_free0 (dname);
				dname = _tmp14_;
				score = _tmp15_;
				_tmp16_ = m;
				_tmp17_ = dname;
				_tmp18_ = g_strdup (_tmp17_);
				_tmp19_ = score;
				g_hash_table_insert (_tmp16_, _tmp18_, (gpointer) ((gintptr) _tmp19_));
				_g_free0 (dname);
				_g_variant_unref0 (tupe);
			}
		}
	}
	_tmp20_ = self->content;
	_tmp21_ = gtk_container_get_children ((GtkContainer*) _tmp20_);
	{
		GList* sprog_collection = NULL;
		GList* sprog_it = NULL;
		sprog_collection = _tmp21_;
		for (sprog_it = sprog_collection; sprog_it != NULL; sprog_it = sprog_it->next) {
			GtkWidget* sprog = NULL;
			sprog = (GtkWidget*) sprog_it->data;
			{
				MenuButton* child = NULL;
				GtkWidget* _tmp22_ = NULL;
				GtkWidget* _tmp23_ = NULL;
				MenuButton* _tmp24_ = NULL;
				gchar* key = NULL;
				MenuButton* _tmp25_ = NULL;
				GDesktopAppInfo* _tmp26_ = NULL;
				GDesktopAppInfo* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				GHashTable* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				_tmp22_ = sprog;
				_tmp23_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp22_) : NULL);
				_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp23_) : NULL);
				child = _tmp24_;
				_tmp25_ = child;
				_tmp26_ = menu_button_get_info (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_desktop_app_info_get_filename (_tmp27_);
				_tmp29_ = g_strdup (_tmp28_);
				key = _tmp29_;
				_tmp30_ = m;
				_tmp31_ = key;
				_tmp32_ = g_hash_table_contains (_tmp30_, _tmp31_);
				if (_tmp32_) {
					MenuButton* _tmp33_ = NULL;
					GHashTable* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gconstpointer _tmp36_ = NULL;
					_tmp33_ = child;
					_tmp34_ = m;
					_tmp35_ = key;
					_tmp36_ = g_hash_table_lookup (_tmp34_, _tmp35_);
					menu_button_set_score (_tmp33_, (gint) ((gintptr) _tmp36_));
				}
				_g_free0 (key);
				_g_object_unref0 (child);
			}
		}
		_g_list_free0 (sprog_collection);
	}
	_tmp37_ = self->content;
	gtk_list_box_invalidate_sort (_tmp37_);
	_g_hash_table_unref0 (m);
	_g_variant_unref0 (scores);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


GVariant* budgie_menu_window_mktuple (BudgieMenuWindow* self, const gchar* text, gint val) {
	GVariant* result = NULL;
	GVariant* l = NULL;
	const gchar* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* r = NULL;
	gint _tmp2_ = 0;
	GVariant* _tmp3_ = NULL;
	GVariant* t = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant** _tmp6_ = NULL;
	GVariant** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	l = _tmp1_;
	_tmp2_ = val;
	_tmp3_ = g_variant_new_int32 ((gint32) _tmp2_);
	g_variant_ref_sink (_tmp3_);
	r = _tmp3_;
	_tmp4_ = _g_variant_ref0 (l);
	_tmp5_ = _g_variant_ref0 (r);
	_tmp6_ = g_new0 (GVariant*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp8_ = g_variant_new_tuple (_tmp7_, 2);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_variant_unref), NULL);
	t = _tmp9_;
	result = t;
	_g_variant_unref0 (r);
	_g_variant_unref0 (l);
	return result;
}


static void _vala_array_add1 (GVariant*** array, int* length, int* size, GVariant* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void budgie_menu_window_save_scores (BudgieMenuWindow* self) {
	GVariant** children = NULL;
	gint children_length1 = 0;
	gint _children_size_ = 0;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GVariant** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	GVariant* arr = NULL;
	GVariant** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	GVariant* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	GVariant* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	children = NULL;
	children_length1 = 0;
	_children_size_ = children_length1;
	_tmp0_ = self->content;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* sprog_collection = NULL;
		GList* sprog_it = NULL;
		sprog_collection = _tmp1_;
		for (sprog_it = sprog_collection; sprog_it != NULL; sprog_it = sprog_it->next) {
			GtkWidget* sprog = NULL;
			sprog = (GtkWidget*) sprog_it->data;
			{
				MenuButton* child = NULL;
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				MenuButton* _tmp4_ = NULL;
				MenuButton* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gchar* key = NULL;
				MenuButton* _tmp8_ = NULL;
				GDesktopAppInfo* _tmp9_ = NULL;
				GDesktopAppInfo* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				GVariant* tuple = NULL;
				const gchar* _tmp13_ = NULL;
				MenuButton* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				GVariant* _tmp17_ = NULL;
				GVariant** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				_tmp2_ = sprog;
				_tmp3_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp2_) : NULL);
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp3_) : NULL);
				child = _tmp4_;
				_tmp5_ = child;
				_tmp6_ = menu_button_get_score (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ == 0) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp8_ = child;
				_tmp9_ = menu_button_get_info (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_desktop_app_info_get_filename (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				key = _tmp12_;
				_tmp13_ = key;
				_tmp14_ = child;
				_tmp15_ = menu_button_get_score (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = budgie_menu_window_mktuple (self, _tmp13_, _tmp16_);
				tuple = _tmp17_;
				_tmp18_ = children;
				_tmp18__length1 = children_length1;
				if (_tmp18_ == NULL) {
					GVariant* _tmp19_ = NULL;
					GVariant* _tmp20_ = NULL;
					GVariant** _tmp21_ = NULL;
					_tmp19_ = tuple;
					_tmp20_ = _g_variant_ref0 (_tmp19_);
					_tmp21_ = g_new0 (GVariant*, 1 + 1);
					_tmp21_[0] = _tmp20_;
					children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_variant_unref), NULL);
					children = _tmp21_;
					children_length1 = 1;
					_children_size_ = children_length1;
				} else {
					GVariant** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					GVariant* _tmp23_ = NULL;
					GVariant* _tmp24_ = NULL;
					_tmp22_ = children;
					_tmp22__length1 = children_length1;
					_tmp23_ = tuple;
					_tmp24_ = _g_variant_ref0 (_tmp23_);
					_vala_array_add1 (&children, &children_length1, &_children_size_, _tmp24_);
				}
				_g_variant_unref0 (tuple);
				_g_free0 (key);
				_g_object_unref0 (child);
			}
		}
		_g_list_free0 (sprog_collection);
	}
	_tmp25_ = children;
	_tmp25__length1 = children_length1;
	if (_tmp25_ == NULL) {
		children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_variant_unref), NULL);
		return;
	}
	_tmp26_ = children;
	_tmp26__length1 = children_length1;
	_tmp27_ = g_variant_new_array (NULL, _tmp26_, _tmp26__length1);
	g_variant_ref_sink (_tmp27_);
	arr = _tmp27_;
	_tmp28_ = self->priv->_settings;
	_tmp29_ = arr;
	g_settings_set_value (_tmp28_, "app-scores", _tmp29_);
	_g_variant_unref0 (arr);
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_variant_unref), NULL);
}


static void __lambda9_ (BudgieMenuWindow* self) {
	CategoryButton* _tmp0_ = NULL;
	_tmp0_ = self->all_categories;
	budgie_menu_window_update_category (self, _tmp0_);
}


static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda9_ ((BudgieMenuWindow*) self);
}


static void _budgie_menu_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	budgie_menu_window_on_row_activate ((BudgieMenuWindow*) self, row);
}


static void _budgie_menu_window_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_menu_window_on_settings_changed ((BudgieMenuWindow*) self, key);
}


static gboolean _budgie_menu_window_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = budgie_menu_window_do_filter_list ((BudgieMenuWindow*) self, row);
	return result;
}


static gint _budgie_menu_window_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = budgie_menu_window_do_sort_list ((BudgieMenuWindow*) self, row1, row2);
	return result;
}


static void __lambda10_ (BudgieMenuWindow* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_g_free0 (self->search_term);
	self->search_term = _tmp3_;
	_tmp4_ = self->content;
	gtk_list_box_invalidate_headers (_tmp4_);
	_tmp5_ = self->content;
	gtk_list_box_invalidate_filter (_tmp5_);
}


static void ___lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda10_ ((BudgieMenuWindow*) self);
}


static void _budgie_menu_window_on_entry_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	budgie_menu_window_on_entry_activate ((BudgieMenuWindow*) self);
}


static gboolean __lambda11_ (BudgieMenuWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	budgie_menu_window_load_menus (self, NULL);
	budgie_menu_window_apply_scores (self);
	gtk_widget_queue_resize ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ ((BudgieMenuWindow*) self);
	return result;
}


BudgieMenuWindow* budgie_menu_window_construct (GType object_type, GSettings* settings, GtkWidget* leparent) {
	BudgieMenuWindow * self = NULL;
	GSettings* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkBox* master_layout = NULL;
	GtkBox* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkSearchEntry* _tmp6_ = NULL;
	GtkSearchEntry* _tmp7_ = NULL;
	GtkBox* middle = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkScrolledWindow* _tmp12_ = NULL;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkScrolledWindow* _tmp14_ = NULL;
	GtkScrolledWindow* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	GtkScrolledWindow* _tmp17_ = NULL;
	GtkStyleContext* _tmp18_ = NULL;
	GtkScrolledWindow* _tmp19_ = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkScrolledWindow* _tmp21_ = NULL;
	GtkScrolledWindow* _tmp22_ = NULL;
	CategoryButton* _tmp23_ = NULL;
	CategoryButton* _tmp24_ = NULL;
	CategoryButton* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	CategoryButton* _tmp27_ = NULL;
	GtkBox* right_layout = NULL;
	GtkBox* _tmp28_ = NULL;
	GtkListBox* _tmp29_ = NULL;
	GtkListBox* _tmp30_ = NULL;
	GtkListBox* _tmp31_ = NULL;
	GtkScrolledWindow* _tmp32_ = NULL;
	GtkScrolledWindow* _tmp33_ = NULL;
	GtkScrolledWindow* _tmp34_ = NULL;
	GtkScrolledWindow* _tmp35_ = NULL;
	GtkListBox* _tmp36_ = NULL;
	GtkScrolledWindow* _tmp37_ = NULL;
	GtkLabel* placeholder = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkStyleContext* _tmp39_ = NULL;
	GtkListBox* _tmp40_ = NULL;
	GtkListBox* _tmp41_ = NULL;
	GSettings* _tmp42_ = NULL;
	GtkListBox* _tmp43_ = NULL;
	GtkListBox* _tmp44_ = NULL;
	GtkSearchEntry* _tmp45_ = NULL;
	GtkSearchEntry* _tmp46_ = NULL;
	GtkSearchEntry* _tmp47_ = NULL;
	_tmp0_ = settings;
	_tmp1_ = leparent;
	self = (BudgieMenuWindow*) g_object_new (object_type, "settings", _tmp0_, "relative-to", _tmp1_, NULL);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "budgie-menu");
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	master_layout = _tmp3_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) master_layout);
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "menu-icons-size");
	self->icon_size = _tmp5_;
	_tmp6_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp6_;
	_tmp7_ = self->search_entry;
	gtk_box_pack_start (master_layout, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	middle = _tmp8_;
	gtk_box_pack_start (master_layout, (GtkWidget*) middle, TRUE, TRUE, (guint) 0);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->categories);
	self->categories = _tmp9_;
	_tmp10_ = self->categories;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 3);
	_tmp11_ = self->categories;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 3);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->categories_scroll);
	self->categories_scroll = _tmp12_;
	_tmp13_ = self->categories_scroll;
	gtk_scrolled_window_set_overlay_scrolling (_tmp13_, FALSE);
	_tmp14_ = self->categories_scroll;
	gtk_scrolled_window_set_shadow_type (_tmp14_, GTK_SHADOW_ETCHED_IN);
	_tmp15_ = self->categories_scroll;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	gtk_style_context_add_class (_tmp16_, "categories");
	_tmp17_ = self->categories_scroll;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "sidebar");
	_tmp19_ = self->categories_scroll;
	_tmp20_ = self->categories;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->categories_scroll;
	gtk_scrolled_window_set_policy (_tmp21_, GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	_tmp22_ = self->categories_scroll;
	gtk_box_pack_start (middle, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = category_button_new (NULL);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->all_categories);
	self->all_categories = _tmp23_;
	_tmp24_ = self->all_categories;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "enter-notify-event", (GCallback) _budgie_menu_window_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
	_tmp25_ = self->all_categories;
	g_signal_connect_object ((GtkToggleButton*) _tmp25_, "toggled", (GCallback) ___lambda9__gtk_toggle_button_toggled, self, 0);
	_tmp26_ = self->categories;
	_tmp27_ = self->all_categories;
	gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp28_);
	right_layout = _tmp28_;
	gtk_box_pack_start (middle, (GtkWidget*) right_layout, TRUE, TRUE, (guint) 0);
	_tmp29_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->content);
	self->content = _tmp29_;
	_tmp30_ = self->content;
	g_signal_connect_object (_tmp30_, "row-activated", (GCallback) _budgie_menu_window_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp31_ = self->content;
	gtk_list_box_set_selection_mode (_tmp31_, GTK_SELECTION_NONE);
	_tmp32_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->content_scroll);
	self->content_scroll = _tmp32_;
	_tmp33_ = self->content_scroll;
	gtk_scrolled_window_set_overlay_scrolling (_tmp33_, FALSE);
	_tmp34_ = self->content_scroll;
	gtk_scrolled_window_set_policy (_tmp34_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp35_ = self->content_scroll;
	_tmp36_ = self->content;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = self->content_scroll;
	gtk_box_pack_start (right_layout, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = (GtkLabel*) gtk_label_new ("<big>Sorry, no items found</big>");
	g_object_ref_sink (_tmp38_);
	placeholder = _tmp38_;
	gtk_label_set_use_markup (placeholder, TRUE);
	_tmp39_ = gtk_widget_get_style_context ((GtkWidget*) placeholder);
	gtk_style_context_add_class (_tmp39_, "dim-label");
	gtk_widget_show ((GtkWidget*) placeholder);
	g_object_set ((GtkWidget*) placeholder, "margin", 6, NULL);
	_tmp40_ = self->content;
	gtk_widget_set_valign ((GtkWidget*) _tmp40_, GTK_ALIGN_START);
	_tmp41_ = self->content;
	gtk_list_box_set_placeholder (_tmp41_, (GtkWidget*) placeholder);
	_tmp42_ = settings;
	g_signal_connect_object (_tmp42_, "changed", (GCallback) _budgie_menu_window_on_settings_changed_g_settings_changed, self, 0);
	budgie_menu_window_on_settings_changed (self, "menu-compact");
	budgie_menu_window_on_settings_changed (self, "menu-headers");
	budgie_menu_window_on_settings_changed (self, "menu-categories-hover");
	_tmp43_ = self->content;
	gtk_list_box_set_filter_func (_tmp43_, _budgie_menu_window_do_filter_list_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp44_ = self->content;
	gtk_list_box_set_sort_func (_tmp44_, _budgie_menu_window_do_sort_list_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp45_ = self->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp45_, "changed", (GCallback) ___lambda10__gtk_editable_changed, self, 0);
	_tmp46_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp46_);
	_tmp47_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp47_, "activate", (GCallback) _budgie_menu_window_on_entry_activate_gtk_entry_activate, self, 0);
	gtk_widget_set_size_request ((GtkWidget*) self, 300, 510);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (right_layout);
	_g_object_unref0 (middle);
	_g_object_unref0 (master_layout);
	return self;
}


BudgieMenuWindow* budgie_menu_window_new (GSettings* settings, GtkWidget* leparent) {
	return budgie_menu_window_construct (TYPE_BUDGIE_MENU_WINDOW, settings, leparent);
}


static void _budgie_menu_window_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	budgie_menu_window_do_list_header ((BudgieMenuWindow*) self, row, before);
}


void budgie_menu_window_on_settings_changed (BudgieMenuWindow* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("menu-compact")))) {
		switch (0) {
			default:
			{
				gboolean vis = FALSE;
				GSettings* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				GtkScrolledWindow* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GtkScrolledWindow* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				_tmp4_ = self->priv->_settings;
				_tmp5_ = key;
				_tmp6_ = g_settings_get_boolean (_tmp4_, _tmp5_);
				vis = _tmp6_;
				_tmp7_ = self->categories_scroll;
				_tmp8_ = vis;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, _tmp8_);
				_tmp9_ = self->categories_scroll;
				_tmp10_ = vis;
				gtk_widget_set_visible ((GtkWidget*) _tmp9_, _tmp10_);
				_tmp11_ = vis;
				self->compact_mode = _tmp11_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("menu-headers")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GtkListBox* _tmp17_ = NULL;
				_tmp12_ = self->priv->_settings;
				_tmp13_ = key;
				_tmp14_ = g_settings_get_boolean (_tmp12_, _tmp13_);
				if (_tmp14_) {
					GtkListBox* _tmp15_ = NULL;
					_tmp15_ = self->content;
					gtk_list_box_set_header_func (_tmp15_, _budgie_menu_window_do_list_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
				} else {
					GtkListBox* _tmp16_ = NULL;
					_tmp16_ = self->content;
					gtk_list_box_set_header_func (_tmp16_, NULL, NULL, NULL);
				}
				_tmp17_ = self->content;
				gtk_list_box_invalidate_headers (_tmp17_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("menu-categories-hover")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				_tmp18_ = self->priv->_settings;
				_tmp19_ = key;
				_tmp20_ = g_settings_get_boolean (_tmp18_, _tmp19_);
				self->rollover_menus = _tmp20_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}


void budgie_menu_window_on_entry_activate (BudgieMenuWindow* self) {
	GtkListBoxRow* selected = NULL;
	GList* rows = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GtkListBoxRow* _tmp15_ = NULL;
	MenuButton* btn = NULL;
	GtkListBoxRow* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	MenuButton* _tmp18_ = NULL;
	MenuButton* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	MenuButton* _tmp22_ = NULL;
	GDesktopAppInfo* _tmp23_ = NULL;
	GDesktopAppInfo* _tmp24_ = NULL;
	GtkListBox* _tmp25_ = NULL;
	GtkListBox* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	selected = NULL;
	_tmp0_ = self->content;
	_tmp1_ = gtk_list_box_get_selected_rows (_tmp0_);
	rows = _tmp1_;
	_tmp2_ = rows;
	if (_tmp2_ != NULL) {
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		GtkListBoxRow* _tmp5_ = NULL;
		_tmp3_ = rows;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _g_object_ref0 ((GtkListBoxRow*) _tmp4_);
		_g_object_unref0 (selected);
		selected = _tmp5_;
	} else {
		GtkListBox* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		_tmp6_ = self->content;
		_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp7_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child = NULL;
				child = (GtkWidget*) child_it->data;
				{
					gboolean _tmp8_ = FALSE;
					GtkWidget* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = child;
					_tmp10_ = gtk_widget_get_visible (_tmp9_);
					if (_tmp10_) {
						GtkWidget* _tmp11_ = NULL;
						gboolean _tmp12_ = FALSE;
						_tmp11_ = child;
						_tmp12_ = gtk_widget_get_child_visible (_tmp11_);
						_tmp8_ = _tmp12_;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						GtkWidget* _tmp13_ = NULL;
						GtkListBoxRow* _tmp14_ = NULL;
						_tmp13_ = child;
						_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp13_) : NULL);
						_g_object_unref0 (selected);
						selected = _tmp14_;
						break;
					}
				}
			}
			_g_list_free0 (child_collection);
		}
	}
	_tmp15_ = selected;
	if (_tmp15_ == NULL) {
		_g_list_free0 (rows);
		_g_object_unref0 (selected);
		return;
	}
	_tmp16_ = selected;
	_tmp17_ = gtk_bin_get_child ((GtkBin*) _tmp16_);
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp17_) : NULL);
	btn = _tmp18_;
	_tmp19_ = btn;
	_tmp20_ = menu_button_get_score (_tmp19_);
	_tmp21_ = _tmp20_;
	menu_button_set_score (_tmp19_, _tmp21_ + 1);
	_tmp22_ = btn;
	_tmp23_ = menu_button_get_info (_tmp22_);
	_tmp24_ = _tmp23_;
	budgie_menu_window_launch_app (self, _tmp24_);
	_tmp25_ = self->content;
	gtk_list_box_invalidate_sort (_tmp25_);
	_tmp26_ = self->content;
	gtk_list_box_invalidate_headers (_tmp26_);
	budgie_menu_window_save_scores (self);
	_g_object_unref0 (btn);
	_g_list_free0 (rows);
	_g_object_unref0 (selected);
}


void budgie_menu_window_on_row_activate (BudgieMenuWindow* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	MenuButton* btn = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	MenuButton* _tmp3_ = NULL;
	MenuButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	MenuButton* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	GDesktopAppInfo* _tmp9_ = NULL;
	GtkListBox* _tmp10_ = NULL;
	GtkListBox* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = row;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = row;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp2_) : NULL);
	btn = _tmp3_;
	_tmp4_ = btn;
	_tmp5_ = menu_button_get_score (_tmp4_);
	_tmp6_ = _tmp5_;
	menu_button_set_score (_tmp4_, _tmp6_ + 1);
	_tmp7_ = btn;
	_tmp8_ = menu_button_get_info (_tmp7_);
	_tmp9_ = _tmp8_;
	budgie_menu_window_launch_app (self, _tmp9_);
	_tmp10_ = self->content;
	gtk_list_box_invalidate_sort (_tmp10_);
	_tmp11_ = self->content;
	gtk_list_box_invalidate_headers (_tmp11_);
	budgie_menu_window_save_scores (self);
	_g_object_unref0 (btn);
}


/**
     * Provide category headers in the "All" category
     */
void budgie_menu_window_do_list_header (BudgieMenuWindow* self, GtkListBoxRow* before, GtkListBoxRow* after) {
	MenuButton* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	GMenuTreeDirectory* _tmp0_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	GtkListBoxRow* _tmp14_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	GtkListBoxRow* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	_tmp0_ = self->group;
	if (_tmp0_ != NULL) {
		GtkListBoxRow* _tmp1_ = NULL;
		GtkListBoxRow* _tmp3_ = NULL;
		_tmp1_ = before;
		if (_tmp1_ != NULL) {
			GtkListBoxRow* _tmp2_ = NULL;
			_tmp2_ = before;
			gtk_list_box_row_set_header (_tmp2_, NULL);
		}
		_tmp3_ = after;
		if (_tmp3_ != NULL) {
			GtkListBoxRow* _tmp4_ = NULL;
			_tmp4_ = after;
			gtk_list_box_row_set_header (_tmp4_, NULL);
		}
		_g_free0 (next);
		_g_free0 (prev);
		_g_object_unref0 (child);
		return;
	}
	_tmp5_ = before;
	if (_tmp5_ != NULL) {
		GtkListBoxRow* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		MenuButton* _tmp8_ = NULL;
		MenuButton* _tmp9_ = NULL;
		GMenuTreeDirectory* _tmp10_ = NULL;
		GMenuTreeDirectory* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp6_ = before;
		_tmp7_ = gtk_bin_get_child ((GtkBin*) _tmp6_);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp7_) : NULL);
		_g_object_unref0 (child);
		child = _tmp8_;
		_tmp9_ = child;
		_tmp10_ = menu_button_get_parent_menu (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gmenu_tree_directory_get_name (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (prev);
		prev = _tmp13_;
	}
	_tmp14_ = after;
	if (_tmp14_ != NULL) {
		GtkListBoxRow* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		MenuButton* _tmp17_ = NULL;
		MenuButton* _tmp18_ = NULL;
		GMenuTreeDirectory* _tmp19_ = NULL;
		GMenuTreeDirectory* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp15_ = after;
		_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp16_) : NULL);
		_g_object_unref0 (child);
		child = _tmp17_;
		_tmp18_ = child;
		_tmp19_ = menu_button_get_parent_menu (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gmenu_tree_directory_get_name (_tmp20_);
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (next);
		next = _tmp22_;
	}
	_tmp25_ = before;
	if (_tmp25_ == NULL) {
		_tmp24_ = TRUE;
	} else {
		GtkListBoxRow* _tmp26_ = NULL;
		_tmp26_ = after;
		_tmp24_ = _tmp26_ == NULL;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_tmp27_ = prev;
		_tmp28_ = next;
		_tmp23_ = g_strcmp0 (_tmp27_, _tmp28_) != 0;
	}
	if (_tmp23_) {
		GtkLabel* label = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GtkLabel* _tmp32_ = NULL;
		GtkLabel* _tmp33_ = NULL;
		GtkLabel* _tmp34_ = NULL;
		GtkStyleContext* _tmp35_ = NULL;
		GtkLabel* _tmp36_ = NULL;
		GtkLabel* _tmp37_ = NULL;
		GtkListBoxRow* _tmp38_ = NULL;
		GtkLabel* _tmp39_ = NULL;
		GtkLabel* _tmp40_ = NULL;
		_tmp29_ = prev;
		_tmp30_ = g_markup_printf_escaped ("<big>%s</big>", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
		g_object_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		label = _tmp33_;
		_tmp34_ = label;
		_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
		gtk_style_context_add_class (_tmp35_, "dim-label");
		_tmp36_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_START);
		_tmp37_ = label;
		gtk_label_set_use_markup (_tmp37_, TRUE);
		_tmp38_ = before;
		_tmp39_ = label;
		gtk_list_box_row_set_header (_tmp38_, (GtkWidget*) _tmp39_);
		_tmp40_ = label;
		g_object_set ((GtkWidget*) _tmp40_, "margin", 6, NULL);
		_g_object_unref0 (label);
	} else {
		GtkListBoxRow* _tmp41_ = NULL;
		_tmp41_ = before;
		gtk_list_box_row_set_header (_tmp41_, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}


/**
     * Filter out results in the list according to whatever the current filter is,
     * i.e. group based or search based
     */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean budgie_menu_window_do_filter_list (BudgieMenuWindow* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	MenuButton* child = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	MenuButton* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkBox* _tmp58_ = NULL;
	GMenuTreeDirectory* _tmp59_ = NULL;
	MenuButton* _tmp60_ = NULL;
	GMenuTreeDirectory* _tmp61_ = NULL;
	GMenuTreeDirectory* _tmp62_ = NULL;
	GMenuTreeDirectory* _tmp63_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = row;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp1_) : NULL);
	child = _tmp2_;
	_tmp3_ = self->search_term;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		gchar* app_name = NULL;
		gchar* desc = NULL;
		gchar* name = NULL;
		gchar* exec = NULL;
		GtkBox* _tmp6_ = NULL;
		MenuButton* _tmp7_ = NULL;
		GDesktopAppInfo* _tmp8_ = NULL;
		GDesktopAppInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		MenuButton* _tmp16_ = NULL;
		GDesktopAppInfo* _tmp17_ = NULL;
		GDesktopAppInfo* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		MenuButton* _tmp25_ = NULL;
		GDesktopAppInfo* _tmp26_ = NULL;
		GDesktopAppInfo* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		MenuButton* _tmp34_ = NULL;
		GDesktopAppInfo* _tmp35_ = NULL;
		GDesktopAppInfo* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		_tmp6_ = self->categories;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = child;
		_tmp8_ = menu_button_get_info (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_app_info_get_display_name ((GAppInfo*) _tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (app_name);
		app_name = _tmp11_;
		_tmp12_ = app_name;
		if (_tmp12_ != NULL) {
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp13_ = app_name;
			_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
			_g_free0 (app_name);
			app_name = _tmp14_;
		} else {
			gchar* _tmp15_ = NULL;
			_tmp15_ = g_strdup ("");
			_g_free0 (app_name);
			app_name = _tmp15_;
		}
		_tmp16_ = child;
		_tmp17_ = menu_button_get_info (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_app_info_get_description ((GAppInfo*) _tmp18_);
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (desc);
		desc = _tmp20_;
		_tmp21_ = desc;
		if (_tmp21_ != NULL) {
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp22_ = desc;
			_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
			_g_free0 (desc);
			desc = _tmp23_;
		} else {
			gchar* _tmp24_ = NULL;
			_tmp24_ = g_strdup ("");
			_g_free0 (desc);
			desc = _tmp24_;
		}
		_tmp25_ = child;
		_tmp26_ = menu_button_get_info (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_app_info_get_name ((GAppInfo*) _tmp27_);
		_tmp29_ = g_strdup (_tmp28_);
		_g_free0 (name);
		name = _tmp29_;
		_tmp30_ = name;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			_tmp31_ = name;
			_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) -1);
			_g_free0 (name);
			name = _tmp32_;
		} else {
			gchar* _tmp33_ = NULL;
			_tmp33_ = g_strdup ("");
			_g_free0 (name);
			name = _tmp33_;
		}
		_tmp34_ = child;
		_tmp35_ = menu_button_get_info (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_app_info_get_executable ((GAppInfo*) _tmp36_);
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (exec);
		exec = _tmp38_;
		_tmp39_ = exec;
		if (_tmp39_ != NULL) {
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			_tmp40_ = exec;
			_tmp41_ = g_utf8_strdown (_tmp40_, (gssize) -1);
			_g_free0 (exec);
			exec = _tmp41_;
		} else {
			gchar* _tmp42_ = NULL;
			_tmp42_ = g_strdup ("");
			_g_free0 (exec);
			exec = _tmp42_;
		}
		_tmp46_ = app_name;
		_tmp47_ = self->search_term;
		_tmp48_ = string_contains (_tmp46_, _tmp47_);
		if (_tmp48_) {
			_tmp45_ = TRUE;
		} else {
			const gchar* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
			_tmp49_ = desc;
			_tmp50_ = self->search_term;
			_tmp51_ = string_contains (_tmp49_, _tmp50_);
			_tmp45_ = _tmp51_;
		}
		if (_tmp45_) {
			_tmp44_ = TRUE;
		} else {
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			gboolean _tmp54_ = FALSE;
			_tmp52_ = name;
			_tmp53_ = self->search_term;
			_tmp54_ = string_contains (_tmp52_, _tmp53_);
			_tmp44_ = _tmp54_;
		}
		if (_tmp44_) {
			_tmp43_ = TRUE;
		} else {
			const gchar* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
			_tmp55_ = exec;
			_tmp56_ = self->search_term;
			_tmp57_ = string_contains (_tmp55_, _tmp56_);
			_tmp43_ = _tmp57_;
		}
		result = _tmp43_;
		_g_free0 (exec);
		_g_free0 (name);
		_g_free0 (desc);
		_g_free0 (app_name);
		_g_object_unref0 (child);
		return result;
	}
	_tmp58_ = self->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp58_, TRUE);
	_tmp59_ = self->group;
	if (_tmp59_ == NULL) {
		result = TRUE;
		_g_object_unref0 (child);
		return result;
	}
	_tmp60_ = child;
	_tmp61_ = menu_button_get_parent_menu (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = self->group;
	if (_tmp62_ != _tmp63_) {
		result = FALSE;
		_g_object_unref0 (child);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (child);
	return result;
}


gint budgie_menu_window_do_sort_list (BudgieMenuWindow* self, GtkListBoxRow* row1, GtkListBoxRow* row2) {
	gint result = 0;
	MenuButton* child1 = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	MenuButton* _tmp2_ = NULL;
	MenuButton* child2 = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	MenuButton* _tmp5_ = NULL;
	gint run = 0;
	MenuButton* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	MenuButton* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = row1;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp1_) : NULL);
	child1 = _tmp2_;
	_tmp3_ = row2;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MENU_BUTTON) ? ((MenuButton*) _tmp4_) : NULL);
	child2 = _tmp5_;
	run = 0;
	_tmp6_ = child1;
	_tmp7_ = menu_button_get_score (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = child2;
	_tmp10_ = menu_button_get_score (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ > _tmp11_) {
		run = -1;
	} else {
		MenuButton* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		MenuButton* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp12_ = child2;
		_tmp13_ = menu_button_get_score (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = child1;
		_tmp16_ = menu_button_get_score (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp14_ > _tmp17_) {
			run = 1;
		}
	}
	result = run;
	_g_object_unref0 (child2);
	_g_object_unref0 (child1);
	return result;
}


/**
     * Change the current group/category
     */
void budgie_menu_window_update_category (BudgieMenuWindow* self, CategoryButton* btn) {
	CategoryButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	_tmp0_ = btn;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		CategoryButton* _tmp3_ = NULL;
		GMenuTreeDirectory* _tmp4_ = NULL;
		GMenuTreeDirectory* _tmp5_ = NULL;
		GMenuTreeDirectory* _tmp6_ = NULL;
		GtkListBox* _tmp7_ = NULL;
		GtkListBox* _tmp8_ = NULL;
		_tmp3_ = btn;
		_tmp4_ = category_button_get_group (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __vala_GMenuTreeDirectory_copy0 (_tmp5_);
		__vala_GMenuTreeDirectory_free0 (self->group);
		self->group = _tmp6_;
		_tmp7_ = self->content;
		gtk_list_box_invalidate_filter (_tmp7_);
		_tmp8_ = self->content;
		gtk_list_box_invalidate_headers (_tmp8_);
	}
}


/**
     * Launch an application
     */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieMenuWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->info);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda8_ (Block3Data* _data3_) {
	BudgieMenuWindow* self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	{
		GDesktopAppInfo* _tmp0_ = NULL;
		_tmp0_ = _data3_->info;
		g_app_info_launch ((GAppInfo*) _tmp0_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stdout;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Error launching application: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


void budgie_menu_window_launch_app (BudgieMenuWindow* self, GDesktopAppInfo* info) {
	Block3Data* _data3_;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->info);
	_data3_->info = _tmp1_;
	gtk_widget_hide ((GtkWidget*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


/**
     * We need to make some changes to our display before we go showing ourselves
     * again! :)
     */
static gboolean __lambda12_ (BudgieMenuWindow* self) {
	gboolean result = FALSE;
	GtkSearchEntry* _tmp0_ = NULL;
	_tmp0_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ ((BudgieMenuWindow*) self);
	return result;
}


static void budgie_menu_window_real_show (GtkWidget* base) {
	BudgieMenuWindow * self;
	gchar* _tmp0_ = NULL;
	GtkSearchEntry* _tmp1_ = NULL;
	CategoryButton* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GtkAdjustment* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	self = (BudgieMenuWindow*) base;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->search_term);
	self->search_term = _tmp0_;
	_tmp1_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp1_, "");
	__vala_GMenuTreeDirectory_free0 (self->group);
	self->group = NULL;
	_tmp2_ = self->all_categories;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
	_tmp3_ = self->content;
	gtk_list_box_select_row (_tmp3_, NULL);
	_tmp4_ = self->content_scroll;
	_tmp5_ = gtk_scrolled_window_get_vadjustment (_tmp4_);
	gtk_adjustment_set_value (_tmp5_, (gdouble) 0);
	_tmp6_ = self->categories_scroll;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
	gtk_adjustment_set_value (_tmp7_, (gdouble) 0);
	_tmp8_ = self->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
	GTK_WIDGET_CLASS (budgie_menu_window_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover));
	_tmp9_ = self->compact_mode;
	if (!_tmp9_) {
		GtkScrolledWindow* _tmp10_ = NULL;
		_tmp10_ = self->categories_scroll;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
	} else {
		GtkScrolledWindow* _tmp11_ = NULL;
		_tmp11_ = self->categories_scroll;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
	}
}


GSettings* budgie_menu_window_get_settings (BudgieMenuWindow* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


void budgie_menu_window_set_settings (BudgieMenuWindow* self, GSettings* value) {
	GSettings* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_settings = _tmp0_;
	g_object_notify ((GObject *) self, "settings");
}


static void budgie_menu_window_class_init (BudgieMenuWindowClass * klass) {
	budgie_menu_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieMenuWindowPrivate));
	((GtkWidgetClass *) klass)->show = budgie_menu_window_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_menu_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_menu_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_MENU_WINDOW_SETTINGS, g_param_spec_object ("settings", "settings", "settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_menu_window_instance_init (BudgieMenuWindow * self) {
	gchar* _tmp0_ = NULL;
	self->priv = BUDGIE_MENU_WINDOW_GET_PRIVATE (self);
	self->group = NULL;
	self->rollover_menus = TRUE;
	_tmp0_ = g_strdup ("");
	self->search_term = _tmp0_;
	self->icon_size = 24;
	g_rec_mutex_init (&self->priv->__lock_reloading);
	self->priv->reloading = FALSE;
}


static void budgie_menu_window_finalize (GObject* obj) {
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->categories);
	_g_object_unref0 (self->content);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->categories_scroll);
	_g_object_unref0 (self->content_scroll);
	_g_object_unref0 (self->all_categories);
	__vala_GMenuTreeDirectory_free0 (self->group);
	_g_free0 (self->search_term);
	g_rec_mutex_clear (&self->priv->__lock_reloading);
	G_OBJECT_CLASS (budgie_menu_window_parent_class)->finalize (obj);
}


GType budgie_menu_window_get_type (void) {
	return budgie_menu_window_type_id;
}


GType budgie_menu_window_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuWindow), 0, (GInstanceInitFunc) budgie_menu_window_instance_init, NULL };
	budgie_menu_window_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "BudgieMenuWindow", &g_define_type_info, 0);
	return budgie_menu_window_type_id;
}


static void _vala_budgie_menu_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	switch (property_id) {
		case BUDGIE_MENU_WINDOW_SETTINGS:
		g_value_set_object (value, budgie_menu_window_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_menu_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	switch (property_id) {
		case BUDGIE_MENU_WINDOW_SETTINGS:
		budgie_menu_window_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



