/* PowerIndicator.c generated by valac 0.32.1, the Vala compiler
 * generated from PowerIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <upower.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_BATTERY_ICON (battery_icon_get_type ())
#define BATTERY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATTERY_ICON, BatteryIcon))
#define BATTERY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATTERY_ICON, BatteryIconClass))
#define IS_BATTERY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATTERY_ICON))
#define IS_BATTERY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATTERY_ICON))
#define BATTERY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATTERY_ICON, BatteryIconClass))

typedef struct _BatteryIcon BatteryIcon;
typedef struct _BatteryIconClass BatteryIconClass;
typedef struct _BatteryIconPrivate BatteryIconPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_POWER_INDICATOR (power_indicator_get_type ())
#define POWER_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POWER_INDICATOR, PowerIndicator))
#define POWER_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POWER_INDICATOR, PowerIndicatorClass))
#define IS_POWER_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POWER_INDICATOR))
#define IS_POWER_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POWER_INDICATOR))
#define POWER_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POWER_INDICATOR, PowerIndicatorClass))

typedef struct _PowerIndicator PowerIndicator;
typedef struct _PowerIndicatorClass PowerIndicatorClass;
typedef struct _PowerIndicatorPrivate PowerIndicatorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _BatteryIcon {
	GtkImage parent_instance;
	BatteryIconPrivate * priv;
};

struct _BatteryIconClass {
	GtkImageClass parent_class;
};

struct _BatteryIconPrivate {
	UpDevice* _battery;
	gboolean changing;
};

struct _PowerIndicator {
	GtkBin parent_instance;
	PowerIndicatorPrivate * priv;
	GtkEventBox* ebox;
	GtkPopover* popover;
};

struct _PowerIndicatorClass {
	GtkBinClass parent_class;
};

struct _PowerIndicatorPrivate {
	GtkBox* widget;
	UpClient* _client;
	GHashTable* devices;
};


static gpointer battery_icon_parent_class = NULL;
static GType battery_icon_type_id = 0;
static gpointer power_indicator_parent_class = NULL;
static GType power_indicator_type_id = 0;

GType battery_icon_get_type (void) G_GNUC_CONST;
GType battery_icon_register_type (GTypeModule * module);
#define BATTERY_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BATTERY_ICON, BatteryIconPrivate))
enum  {
	BATTERY_ICON_DUMMY_PROPERTY,
	BATTERY_ICON_BATTERY
};
BatteryIcon* battery_icon_new (UpDevice* battery);
BatteryIcon* battery_icon_construct (GType object_type, UpDevice* battery);
void battery_icon_update_ui (BatteryIcon* self, UpDevice* battery);
static void battery_icon_on_battery_change (BatteryIcon* self, GObject* o, GParamSpec* sp);
static void _battery_icon_on_battery_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UpDevice* battery_icon_get_battery (BatteryIcon* self);
void battery_icon_set_battery (BatteryIcon* self, UpDevice* value);
static void battery_icon_finalize (GObject* obj);
static void _vala_battery_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_battery_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType power_indicator_get_type (void) G_GNUC_CONST;
GType power_indicator_register_type (GTypeModule * module);
#define POWER_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POWER_INDICATOR, PowerIndicatorPrivate))
enum  {
	POWER_INDICATOR_DUMMY_PROPERTY,
	POWER_INDICATOR_CLIENT
};
PowerIndicator* power_indicator_new (void);
PowerIndicator* power_indicator_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void power_indicator_open_power_settings (PowerIndicator* self);
static void _power_indicator_open_power_settings_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
void power_indicator_set_client (PowerIndicator* self, UpClient* value);
static void power_indicator_sync_devices (PowerIndicator* self);
UpClient* power_indicator_get_client (PowerIndicator* self);
static void power_indicator_on_device_added (PowerIndicator* self, UpDevice* device);
static void _power_indicator_on_device_added_up__client_device_added (UpClient* _sender, UpDevice* device, gpointer self);
static void power_indicator_on_device_removed (PowerIndicator* self, UpDevice* device);
static void _power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender, UpDevice* device, gpointer self);
static void power_indicator_toggle_show (PowerIndicator* self);
static gboolean power_indicator_is_interesting (PowerIndicator* self, UpDevice* device);
static void __lambda8_ (PowerIndicator* self, UpDevice* device);
static void ___lambda8__gfunc (gconstpointer data, gpointer self);
static void power_indicator_finalize (GObject* obj);
static void _vala_power_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_power_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _battery_icon_on_battery_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	battery_icon_on_battery_change ((BatteryIcon*) self, _sender, pspec);
}


BatteryIcon* battery_icon_construct (GType object_type, UpDevice* battery) {
	BatteryIcon * self = NULL;
	UpDevice* _tmp0_ = NULL;
	UpDevice* _tmp1_ = NULL;
	g_return_val_if_fail (battery != NULL, NULL);
	self = (BatteryIcon*) g_object_new (object_type, NULL);
	_tmp0_ = battery;
	battery_icon_update_ui (self, _tmp0_);
	_tmp1_ = battery;
	g_signal_connect_object ((GObject*) _tmp1_, "notify", (GCallback) _battery_icon_on_battery_change_g_object_notify, self, 0);
	return self;
}


BatteryIcon* battery_icon_new (UpDevice* battery) {
	return battery_icon_construct (TYPE_BATTERY_ICON, battery);
}


static void battery_icon_on_battery_change (BatteryIcon* self, GObject* o, GParamSpec* sp) {
	gboolean _tmp0_ = FALSE;
	UpDevice* _tmp1_ = NULL;
	UpDevice* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (sp != NULL);
	_tmp0_ = self->priv->changing;
	if (_tmp0_) {
		return;
	}
	self->priv->changing = TRUE;
	_tmp1_ = self->priv->_battery;
	up_device_refresh_sync (_tmp1_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = self->priv->_battery;
	battery_icon_update_ui (self, _tmp2_);
	self->priv->changing = FALSE;
}


void battery_icon_update_ui (BatteryIcon* self, UpDevice* battery) {
	gchar* tip = NULL;
	UpDevice* _tmp0_ = NULL;
	gchar* image_name = NULL;
	UpDevice* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	UpDevice* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (battery != NULL);
	_tmp0_ = battery;
	battery_icon_set_battery (self, _tmp0_);
	_tmp1_ = battery;
	g_object_get (_tmp1_, "percentage", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= ((gdouble) 10)) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("battery-empty");
		_g_free0 (image_name);
		image_name = _tmp4_;
	} else {
		UpDevice* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp5_ = battery;
		g_object_get (_tmp5_, "percentage", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		if (_tmp7_ <= ((gdouble) 35)) {
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_strdup ("battery-low");
			_g_free0 (image_name);
			image_name = _tmp8_;
		} else {
			UpDevice* _tmp9_ = NULL;
			gdouble _tmp10_ = 0.0;
			gdouble _tmp11_ = 0.0;
			_tmp9_ = battery;
			g_object_get (_tmp9_, "percentage", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			if (_tmp11_ <= ((gdouble) 75)) {
				gchar* _tmp12_ = NULL;
				_tmp12_ = g_strdup ("battery-good");
				_g_free0 (image_name);
				image_name = _tmp12_;
			} else {
				gchar* _tmp13_ = NULL;
				_tmp13_ = g_strdup ("battery-full");
				_g_free0 (image_name);
				image_name = _tmp13_;
			}
		}
	}
	_tmp14_ = battery;
	g_object_get (_tmp14_, "state", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == ((guint) 4)) {
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp17_ = g_strdup ("battery-full-charged-symbolic");
		_g_free0 (image_name);
		image_name = _tmp17_;
		_tmp18_ = _ ("Battery fully charged.");
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (tip);
		tip = _tmp19_;
	} else {
		UpDevice* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		_tmp20_ = battery;
		g_object_get (_tmp20_, "state", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		if (_tmp22_ == ((guint) 1)) {
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* time_to_full_str = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gint time_to_full = 0;
			UpDevice* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
			gint64 _tmp29_ = 0LL;
			gint _tmp30_ = 0;
			const gchar* _tmp37_ = NULL;
			UpDevice* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			gdouble _tmp40_ = 0.0;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			_tmp23_ = image_name;
			_tmp24_ = g_strconcat (_tmp23_, "-charging-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp24_;
			_tmp25_ = _ ("Unknown");
			_tmp26_ = g_strdup (_tmp25_);
			time_to_full_str = _tmp26_;
			_tmp27_ = battery;
			g_object_get (_tmp27_, "time-to-full", &_tmp28_, NULL);
			_tmp29_ = _tmp28_;
			time_to_full = (gint) _tmp29_;
			_tmp30_ = time_to_full;
			if (_tmp30_ > 0) {
				gint hours = 0;
				gint _tmp31_ = 0;
				gint minutes = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gchar* _tmp36_ = NULL;
				_tmp31_ = time_to_full;
				hours = _tmp31_ / (60 * 60);
				_tmp32_ = time_to_full;
				_tmp33_ = hours;
				minutes = (_tmp32_ / 60) - (_tmp33_ * 60);
				_tmp34_ = hours;
				_tmp35_ = minutes;
				_tmp36_ = g_strdup_printf ("%d:%02d", _tmp34_, _tmp35_);
				_g_free0 (time_to_full_str);
				time_to_full_str = _tmp36_;
			}
			_tmp37_ = _ ("Battery charging");
			_tmp38_ = battery;
			g_object_get (_tmp38_, "percentage", &_tmp39_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = time_to_full_str;
			_tmp42_ = g_strdup_printf (": %d%% (%s)", (gint) _tmp40_, _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp37_, _tmp43_, NULL);
			_g_free0 (tip);
			tip = _tmp44_;
			_g_free0 (_tmp43_);
			_g_free0 (time_to_full_str);
		} else {
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gint hours = 0;
			UpDevice* _tmp47_ = NULL;
			gint64 _tmp48_ = 0LL;
			gint64 _tmp49_ = 0LL;
			gint minutes = 0;
			UpDevice* _tmp50_ = NULL;
			gint64 _tmp51_ = 0LL;
			gint64 _tmp52_ = 0LL;
			gint _tmp53_ = 0;
			const gchar* _tmp54_ = NULL;
			UpDevice* _tmp55_ = NULL;
			gdouble _tmp56_ = 0.0;
			gdouble _tmp57_ = 0.0;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			_tmp45_ = image_name;
			_tmp46_ = g_strconcat (_tmp45_, "-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp46_;
			_tmp47_ = battery;
			g_object_get (_tmp47_, "time-to-empty", &_tmp48_, NULL);
			_tmp49_ = _tmp48_;
			hours = ((gint) _tmp49_) / (60 * 60);
			_tmp50_ = battery;
			g_object_get (_tmp50_, "time-to-empty", &_tmp51_, NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = hours;
			minutes = (((gint) _tmp52_) / 60) - (_tmp53_ * 60);
			_tmp54_ = _ ("Battery remaining");
			_tmp55_ = battery;
			g_object_get (_tmp55_, "percentage", &_tmp56_, NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = hours;
			_tmp59_ = minutes;
			_tmp60_ = g_strdup_printf (": %d%% (%d:%02d)", (gint) _tmp57_, _tmp58_, _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strconcat (_tmp54_, _tmp61_, NULL);
			_g_free0 (tip);
			tip = _tmp62_;
			_g_free0 (_tmp61_);
		}
	}
	_tmp63_ = tip;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp63_);
	_tmp64_ = image_name;
	gtk_image_set_from_icon_name ((GtkImage*) self, _tmp64_, GTK_ICON_SIZE_MENU);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_free0 (image_name);
	_g_free0 (tip);
}


UpDevice* battery_icon_get_battery (BatteryIcon* self) {
	UpDevice* result;
	UpDevice* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_battery;
	result = _tmp0_;
	return result;
}


void battery_icon_set_battery (BatteryIcon* self, UpDevice* value) {
	UpDevice* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_battery = _tmp0_;
	g_object_notify ((GObject *) self, "battery");
}


static void battery_icon_class_init (BatteryIconClass * klass) {
	battery_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BatteryIconPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_battery_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_battery_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = battery_icon_finalize;
	/** The battery associated with this icon */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BATTERY_ICON_BATTERY, g_param_spec_object ("battery", "battery", "battery", up_device_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void battery_icon_instance_init (BatteryIcon * self) {
	self->priv = BATTERY_ICON_GET_PRIVATE (self);
	self->priv->changing = FALSE;
}


static void battery_icon_finalize (GObject* obj) {
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATTERY_ICON, BatteryIcon);
	G_OBJECT_CLASS (battery_icon_parent_class)->finalize (obj);
}


GType battery_icon_get_type (void) {
	return battery_icon_type_id;
}


GType battery_icon_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BatteryIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) battery_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatteryIcon), 0, (GInstanceInitFunc) battery_icon_instance_init, NULL };
	battery_icon_type_id = g_type_module_register_type (module, gtk_image_get_type (), "BatteryIcon", &g_define_type_info, 0);
	return battery_icon_type_id;
}


static void _vala_battery_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY:
		g_value_set_object (value, battery_icon_get_battery (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_battery_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY:
		battery_icon_set_battery (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _power_indicator_open_power_settings_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	power_indicator_open_power_settings ((PowerIndicator*) self);
}


static void _power_indicator_on_device_added_up__client_device_added (UpClient* _sender, UpDevice* device, gpointer self) {
	power_indicator_on_device_added ((PowerIndicator*) self, device);
}


static void _power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender, UpDevice* device, gpointer self) {
	power_indicator_on_device_removed ((PowerIndicator*) self, device);
}


PowerIndicator* power_indicator_construct (GType object_type) {
	PowerIndicator * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GtkEventBox* _tmp3_ = NULL;
	GtkEventBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkEventBox* _tmp10_ = NULL;
	GtkPopover* _tmp11_ = NULL;
	GSimpleActionGroup* group = NULL;
	GSimpleActionGroup* _tmp12_ = NULL;
	GSimpleAction* power = NULL;
	GSimpleAction* _tmp13_ = NULL;
	UpClient* _tmp14_ = NULL;
	UpClient* _tmp15_ = NULL;
	UpClient* _tmp16_ = NULL;
	UpClient* _tmp17_ = NULL;
	self = (PowerIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp2_;
	_tmp3_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp3_;
	_tmp4_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp5_;
	_tmp6_ = self->ebox;
	_tmp7_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = g_menu_new ();
	menu = _tmp8_;
	_tmp9_ = _ ("Power settings");
	g_menu_append (menu, _tmp9_, "power.settings");
	_tmp10_ = self->ebox;
	_tmp11_ = (GtkPopover*) gtk_popover_new_from_model ((GtkWidget*) _tmp10_, (GMenuModel*) menu);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp11_;
	_tmp12_ = g_simple_action_group_new ();
	group = _tmp12_;
	_tmp13_ = g_simple_action_new ("settings", NULL);
	power = _tmp13_;
	g_signal_connect_object (power, "activate", (GCallback) _power_indicator_open_power_settings_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) group, (GAction*) power);
	gtk_widget_insert_action_group ((GtkWidget*) self, "power", (GActionGroup*) group);
	_tmp14_ = up_client_new ();
	_tmp15_ = _tmp14_;
	power_indicator_set_client (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	power_indicator_sync_devices (self);
	_tmp16_ = self->priv->_client;
	g_signal_connect_object (_tmp16_, "device-added", (GCallback) _power_indicator_on_device_added_up__client_device_added, self, 0);
	_tmp17_ = self->priv->_client;
	g_signal_connect_object (_tmp17_, "device-removed", (GCallback) _power_indicator_on_device_removed_up__client_device_removed, self, 0);
	power_indicator_toggle_show (self);
	_g_object_unref0 (power);
	_g_object_unref0 (group);
	_g_object_unref0 (menu);
	return self;
}


PowerIndicator* power_indicator_new (void) {
	return power_indicator_construct (TYPE_POWER_INDICATOR);
}


static gboolean power_indicator_is_interesting (PowerIndicator* self, UpDevice* device) {
	gboolean result = FALSE;
	UpDevice* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = device;
	g_object_get (_tmp0_, "kind", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) UP_DEVICE_KIND_BATTERY)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void power_indicator_open_power_settings (PowerIndicator* self) {
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new ("gnome-power-panel.desktop");
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp2_ = NULL;
		_tmp2_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("PowerIndicator.vala:143: Unable to launch gnome-power-panel.desktop: %" \
"s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (app_info);
}


/**
     * Add a new device to the tree
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void power_indicator_on_device_added (PowerIndicator* self, UpDevice* device) {
	GHashTable* _tmp0_ = NULL;
	UpDevice* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	UpDevice* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	BatteryIcon* icon = NULL;
	UpDevice* _tmp16_ = NULL;
	BatteryIcon* _tmp17_ = NULL;
	GHashTable* _tmp18_ = NULL;
	UpDevice* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	BatteryIcon* _tmp22_ = NULL;
	BatteryIcon* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	BatteryIcon* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = device;
	g_object_get (_tmp1_, "serial", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_contains (_tmp0_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		GHashTable* _tmp7_ = NULL;
		UpDevice* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		UpDevice* _tmp13_ = NULL;
		_tmp7_ = self->priv->devices;
		_tmp8_ = device;
		g_object_get (_tmp8_, "serial", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = g_hash_table_lookup (_tmp7_, _tmp11_);
		_tmp13_ = device;
		battery_icon_update_ui ((BatteryIcon*) _tmp12_, _tmp13_);
		_g_free0 (_tmp11_);
		return;
	}
	_tmp14_ = device;
	_tmp15_ = power_indicator_is_interesting (self, _tmp14_);
	if (!_tmp15_) {
		return;
	}
	_tmp16_ = device;
	_tmp17_ = battery_icon_new (_tmp16_);
	g_object_ref_sink (_tmp17_);
	icon = _tmp17_;
	_tmp18_ = self->priv->devices;
	_tmp19_ = device;
	g_object_get (_tmp19_, "serial", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = icon;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	g_hash_table_insert (_tmp18_, _tmp21_, _tmp23_);
	_tmp24_ = self->priv->widget;
	_tmp25_ = icon;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 0);
	power_indicator_toggle_show (self);
	_g_object_unref0 (icon);
}


static void power_indicator_toggle_show (PowerIndicator* self) {
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = g_hash_table_size (_tmp0_);
	if (_tmp1_ < ((guint) 1)) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_show_all ((GtkWidget*) self);
	}
}


/**
     * Remove a device from our display
     */
static void power_indicator_on_device_removed (PowerIndicator* self, UpDevice* device) {
	GHashTable* _tmp0_ = NULL;
	UpDevice* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	BatteryIcon* icon = NULL;
	GHashTable* _tmp7_ = NULL;
	UpDevice* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	BatteryIcon* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	BatteryIcon* _tmp15_ = NULL;
	GHashTable* _tmp16_ = NULL;
	UpDevice* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = device;
	g_object_get (_tmp1_, "serial", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_contains (_tmp0_, _tmp4_);
	_tmp6_ = !_tmp5_;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		return;
	}
	_tmp7_ = self->priv->devices;
	_tmp8_ = device;
	g_object_get (_tmp8_, "serial", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp12_ = g_hash_table_lookup (_tmp7_, _tmp11_);
	_tmp13_ = (BatteryIcon*) _tmp12_;
	_g_free0 (_tmp11_);
	icon = _tmp13_;
	_tmp14_ = self->priv->widget;
	_tmp15_ = icon;
	gtk_container_remove ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->devices;
	_tmp17_ = device;
	g_object_get (_tmp17_, "serial", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	g_hash_table_remove (_tmp16_, _tmp20_);
	_g_free0 (_tmp20_);
	power_indicator_toggle_show (self);
}


static void __lambda8_ (PowerIndicator* self, UpDevice* device) {
	UpDevice* _tmp0_ = NULL;
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	power_indicator_on_device_added (self, _tmp0_);
}


static void ___lambda8__gfunc (gconstpointer data, gpointer self) {
	__lambda8_ ((PowerIndicator*) self, (UpDevice*) data);
}


static void power_indicator_sync_devices (PowerIndicator* self) {
	GPtrArray* devices = NULL;
	UpClient* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_client;
	_tmp1_ = up_client_get_devices (_tmp0_);
	devices = _tmp1_;
	g_ptr_array_foreach (devices, ___lambda8__gfunc, self);
	power_indicator_toggle_show (self);
	_g_ptr_array_unref0 (devices);
}


UpClient* power_indicator_get_client (PowerIndicator* self) {
	UpClient* result;
	UpClient* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}


void power_indicator_set_client (PowerIndicator* self, UpClient* value) {
	UpClient* _tmp0_ = NULL;
	UpClient* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_client);
	self->priv->_client = _tmp1_;
	g_object_notify ((GObject *) self, "client");
}


static void power_indicator_class_init (PowerIndicatorClass * klass) {
	power_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PowerIndicatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_power_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = power_indicator_finalize;
	/** Our upower client */
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_CLIENT, g_param_spec_object ("client", "client", "client", up_client_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void power_indicator_instance_init (PowerIndicator * self) {
	self->priv = POWER_INDICATOR_GET_PRIVATE (self);
	self->ebox = NULL;
	self->popover = NULL;
	self->priv->widget = NULL;
}


static void power_indicator_finalize (GObject* obj) {
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POWER_INDICATOR, PowerIndicator);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->_client);
	_g_hash_table_unref0 (self->priv->devices);
	G_OBJECT_CLASS (power_indicator_parent_class)->finalize (obj);
}


GType power_indicator_get_type (void) {
	return power_indicator_type_id;
}


GType power_indicator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PowerIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerIndicator), 0, (GInstanceInitFunc) power_indicator_instance_init, NULL };
	power_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "PowerIndicator", &g_define_type_info, 0);
	return power_indicator_type_id;
}


static void _vala_power_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT:
		g_value_set_object (value, power_indicator_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_power_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT:
		power_indicator_set_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



