/* SoundIndicator.c generated by valac 0.32.1, the Vala compiler
 * generated from SoundIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gvc-mixer-stream.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_SOUND_INDICATOR (sound_indicator_get_type ())
#define SOUND_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOUND_INDICATOR, SoundIndicator))
#define SOUND_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOUND_INDICATOR, SoundIndicatorClass))
#define IS_SOUND_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOUND_INDICATOR))
#define IS_SOUND_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOUND_INDICATOR))
#define SOUND_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOUND_INDICATOR, SoundIndicatorClass))

typedef struct _SoundIndicator SoundIndicator;
typedef struct _SoundIndicatorClass SoundIndicatorClass;
typedef struct _SoundIndicatorPrivate SoundIndicatorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SoundIndicator {
	GtkBin parent_instance;
	SoundIndicatorPrivate * priv;
};

struct _SoundIndicatorClass {
	GtkBinClass parent_class;
};

struct _SoundIndicatorPrivate {
	GtkImage* _widget;
	GvcMixerControl* _mixer;
	GvcMixerStream* stream;
	gdouble step_size;
	gulong notify_id;
};


static gpointer sound_indicator_parent_class = NULL;
static GType sound_indicator_type_id = 0;

#define MIXER_NAME "Budgie Volume Control"
GType sound_indicator_get_type (void) G_GNUC_CONST;
GType sound_indicator_register_type (GTypeModule * module);
#define SOUND_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOUND_INDICATOR, SoundIndicatorPrivate))
enum  {
	SOUND_INDICATOR_DUMMY_PROPERTY,
	SOUND_INDICATOR_WIDGET,
	SOUND_INDICATOR_MIXER
};
SoundIndicator* sound_indicator_new (void);
SoundIndicator* sound_indicator_construct (GType object_type);
void sound_indicator_set_widget (SoundIndicator* self, GtkImage* value);
GtkImage* sound_indicator_get_widget (SoundIndicator* self);
void sound_indicator_set_mixer (SoundIndicator* self, GvcMixerControl* value);
GvcMixerControl* sound_indicator_get_mixer (SoundIndicator* self);
void sound_indicator_on_state_change (SoundIndicator* self, guint new_state);
static void _sound_indicator_on_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender, guint new_state, gpointer self);
static void sound_indicator_on_sink_changed (SoundIndicator* self, guint id);
static void _sound_indicator_on_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender, guint id, gpointer self);
gboolean sound_indicator_on_scroll_event (SoundIndicator* self, GdkEventScroll* event);
static gboolean _sound_indicator_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void sound_indicator_set_default_mixer (SoundIndicator* self);
static void sound_indicator_on_notify (SoundIndicator* self, GObject* o, GParamSpec* p);
static void _sound_indicator_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sound_indicator_update_volume (SoundIndicator* self);
static void sound_indicator_finalize (GObject* obj);
static void _vala_sound_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sound_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _sound_indicator_on_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender, guint new_state, gpointer self) {
	sound_indicator_on_state_change ((SoundIndicator*) self, new_state);
}


static void _sound_indicator_on_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_indicator_on_sink_changed ((SoundIndicator*) self, id);
}


static gboolean _sound_indicator_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = sound_indicator_on_scroll_event ((SoundIndicator*) self, event);
	return result;
}


SoundIndicator* sound_indicator_construct (GType object_type) {
	SoundIndicator * self = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkEventBox* wrap = NULL;
	GtkEventBox* _tmp2_ = NULL;
	GtkImage* _tmp3_ = NULL;
	GvcMixerControl* _tmp4_ = NULL;
	GvcMixerControl* _tmp5_ = NULL;
	GvcMixerControl* _tmp6_ = NULL;
	GvcMixerControl* _tmp7_ = NULL;
	GvcMixerControl* _tmp8_ = NULL;
	self = (SoundIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("audio-volume-muted-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	sound_indicator_set_widget (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp2_);
	wrap = _tmp2_;
	_tmp3_ = self->priv->_widget;
	gtk_container_add ((GtkContainer*) wrap, (GtkWidget*) _tmp3_);
	g_object_set ((GtkWidget*) wrap, "margin", 0, NULL);
	gtk_container_set_border_width ((GtkContainer*) wrap, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) wrap);
	_tmp4_ = gvc_mixer_control_new (MIXER_NAME);
	_tmp5_ = _tmp4_;
	sound_indicator_set_mixer (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_mixer;
	g_signal_connect_object (_tmp6_, "state-changed", (GCallback) _sound_indicator_on_state_change_gvc_mixer_control_state_changed, self, 0);
	_tmp7_ = self->priv->_mixer;
	g_signal_connect_object (_tmp7_, "default-sink-changed", (GCallback) _sound_indicator_on_sink_changed_gvc_mixer_control_default_sink_changed, self, 0);
	_tmp8_ = self->priv->_mixer;
	gvc_mixer_control_open (_tmp8_);
	gtk_widget_add_events ((GtkWidget*) wrap, (gint) GDK_SCROLL_MASK);
	g_signal_connect_object ((GtkWidget*) wrap, "scroll-event", (GCallback) _sound_indicator_on_scroll_event_gtk_widget_scroll_event, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (wrap);
	return self;
}


SoundIndicator* sound_indicator_new (void) {
	return sound_indicator_construct (TYPE_SOUND_INDICATOR);
}


static void sound_indicator_on_sink_changed (SoundIndicator* self, guint id) {
	g_return_if_fail (self != NULL);
	sound_indicator_set_default_mixer (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sound_indicator_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	sound_indicator_on_notify ((SoundIndicator*) self, _sender, pspec);
}


static void sound_indicator_set_default_mixer (SoundIndicator* self) {
	GvcMixerStream* _tmp0_ = NULL;
	GvcMixerControl* _tmp3_ = NULL;
	GvcMixerStream* _tmp4_ = NULL;
	GvcMixerStream* _tmp5_ = NULL;
	GvcMixerStream* _tmp6_ = NULL;
	gulong _tmp7_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	if (_tmp0_ != NULL) {
		GvcMixerStream* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		_tmp1_ = self->priv->stream;
		_tmp2_ = self->priv->notify_id;
		g_signal_handler_disconnect (_tmp1_, _tmp2_);
	}
	_tmp3_ = self->priv->_mixer;
	_tmp4_ = gvc_mixer_control_get_default_sink (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp5_;
	_tmp6_ = self->priv->stream;
	_tmp7_ = g_signal_connect_object ((GObject*) _tmp6_, "notify", (GCallback) _sound_indicator_on_notify_g_object_notify, self, 0);
	self->priv->notify_id = _tmp7_;
	sound_indicator_update_volume (self);
}


static void sound_indicator_on_notify (SoundIndicator* self, GObject* o, GParamSpec* p) {
	gboolean _tmp0_ = FALSE;
	GParamSpec* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = p;
	_tmp2_ = _tmp1_->name;
	if (g_strcmp0 (_tmp2_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		GParamSpec* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = p;
		_tmp4_ = _tmp3_->name;
		_tmp0_ = g_strcmp0 (_tmp4_, "is-muted") == 0;
	}
	if (_tmp0_) {
		sound_indicator_update_volume (self);
	}
}


/**
     * Called when something changes on the mixer, i.e. we connected
     * This is where we hook into the stream for changes
     */
void sound_indicator_on_state_change (SoundIndicator* self, guint new_state) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_state;
	if (_tmp0_ == ((guint) GVC_STATE_READY)) {
		sound_indicator_set_default_mixer (self);
	}
}


/**
     * Update from scroll events. turn volume up + down.
     */
gboolean sound_indicator_on_scroll_event (SoundIndicator* self, GdkEventScroll* event) {
	gboolean result = FALSE;
	GvcMixerStream* _tmp0_ = NULL;
	guint32 vol = 0U;
	GvcMixerStream* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	guint32 orig_vol = 0U;
	guint32 _tmp3_ = 0U;
	GdkEventScroll* _tmp4_ = NULL;
	GdkScrollDirection _tmp5_ = 0;
	gdouble max_amp = 0.0;
	GvcMixerControl* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gdouble norm = 0.0;
	GvcMixerControl* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	guint32 _tmp19_ = 0U;
	gdouble _tmp20_ = 0.0;
	guint32 _tmp22_ = 0U;
	gdouble _tmp23_ = 0.0;
	GvcMixerStream* _tmp25_ = NULL;
	guint32 _tmp26_ = 0U;
	gboolean _tmp27_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->stream;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = self->priv->stream;
	_tmp2_ = gvc_mixer_stream_get_volume (_tmp1_);
	vol = _tmp2_;
	_tmp3_ = vol;
	orig_vol = _tmp3_;
	_tmp4_ = event;
	_tmp5_ = _tmp4_->direction;
	switch (_tmp5_) {
		case GDK_SCROLL_UP:
		{
			guint32 _tmp6_ = 0U;
			gdouble _tmp7_ = 0.0;
			_tmp6_ = vol;
			_tmp7_ = self->priv->step_size;
			vol = _tmp6_ + ((guint32) _tmp7_);
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			guint32 _tmp8_ = 0U;
			gdouble _tmp9_ = 0.0;
			guint32 _tmp10_ = 0U;
			guint32 _tmp11_ = 0U;
			_tmp8_ = vol;
			_tmp9_ = self->priv->step_size;
			vol = _tmp8_ - ((guint32) _tmp9_);
			_tmp10_ = vol;
			_tmp11_ = orig_vol;
			if (_tmp10_ > _tmp11_) {
				vol = (guint32) 0;
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp12_ = self->priv->_mixer;
	_tmp13_ = gvc_mixer_control_get_vol_max_amplified (_tmp12_);
	max_amp = _tmp13_;
	_tmp14_ = self->priv->_mixer;
	_tmp15_ = gvc_mixer_control_get_vol_max_norm (_tmp14_);
	norm = _tmp15_;
	_tmp16_ = max_amp;
	_tmp17_ = norm;
	if (_tmp16_ < _tmp17_) {
		gdouble _tmp18_ = 0.0;
		_tmp18_ = norm;
		max_amp = _tmp18_;
	}
	_tmp19_ = vol;
	_tmp20_ = max_amp;
	if (((gdouble) _tmp19_) > _tmp20_) {
		gdouble _tmp21_ = 0.0;
		_tmp21_ = max_amp;
		vol = (guint32) _tmp21_;
	}
	_tmp22_ = vol;
	_tmp23_ = norm;
	if (((gdouble) _tmp22_) >= _tmp23_) {
		gdouble _tmp24_ = 0.0;
		_tmp24_ = norm;
		vol = (guint32) _tmp24_;
	}
	_tmp25_ = self->priv->stream;
	_tmp26_ = vol;
	_tmp27_ = gvc_mixer_stream_set_volume (_tmp25_, _tmp26_);
	if (_tmp27_) {
		GvcMixerStream* _tmp28_ = NULL;
		_tmp28_ = self->priv->stream;
		gvc_mixer_stream_push_volume (_tmp28_);
	}
	result = TRUE;
	return result;
}


/**
     * Update our icon when something changed (volume/mute)
     */
void sound_indicator_update_volume (SoundIndicator* self) {
	gdouble vol_norm = 0.0;
	GvcMixerControl* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	guint32 vol = 0U;
	GvcMixerStream* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
	gint n = 0;
	guint32 _tmp4_ = 0U;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gchar* image_name = NULL;
	gboolean _tmp7_ = FALSE;
	GvcMixerStream* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GtkImage* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	gfloat pct = 0.0F;
	guint32 _tmp20_ = 0U;
	gdouble _tmp21_ = 0.0;
	guint ipct = 0U;
	GtkImage* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mixer;
	_tmp1_ = gvc_mixer_control_get_vol_max_norm (_tmp0_);
	vol_norm = _tmp1_;
	_tmp2_ = self->priv->stream;
	_tmp3_ = gvc_mixer_stream_get_volume (_tmp2_);
	vol = _tmp3_;
	_tmp4_ = vol;
	_tmp5_ = vol_norm;
	_tmp6_ = floor ((3 * _tmp4_) / _tmp5_);
	n = ((gint) _tmp6_) + 1;
	_tmp8_ = self->priv->stream;
	_tmp9_ = gvc_mixer_stream_get_is_muted (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = TRUE;
	} else {
		guint32 _tmp10_ = 0U;
		_tmp10_ = vol;
		_tmp7_ = _tmp10_ <= ((guint32) 0);
	}
	if (_tmp7_) {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("audio-volume-muted-symbolic");
		_g_free0 (image_name);
		image_name = _tmp11_;
	} else {
		gint _tmp12_ = 0;
		_tmp12_ = n;
		switch (_tmp12_) {
			case 1:
			{
				gchar* _tmp13_ = NULL;
				_tmp13_ = g_strdup ("audio-volume-low-symbolic");
				_g_free0 (image_name);
				image_name = _tmp13_;
				break;
			}
			case 2:
			{
				gchar* _tmp14_ = NULL;
				_tmp14_ = g_strdup ("audio-volume-medium-symbolic");
				_g_free0 (image_name);
				image_name = _tmp14_;
				break;
			}
			default:
			{
				gchar* _tmp15_ = NULL;
				_tmp15_ = g_strdup ("audio-volume-high-symbolic");
				_g_free0 (image_name);
				image_name = _tmp15_;
				break;
			}
		}
	}
	_tmp16_ = self->priv->_widget;
	_tmp17_ = image_name;
	gtk_image_set_from_icon_name (_tmp16_, _tmp17_, GTK_ICON_SIZE_MENU);
	_tmp18_ = self->priv->_mixer;
	_tmp19_ = gvc_mixer_control_get_vol_max_amplified (_tmp18_);
	vol_max = _tmp19_;
	self->priv->step_size = vol_max / 20;
	_tmp20_ = vol;
	_tmp21_ = vol_norm;
	pct = (((gfloat) _tmp20_) / ((gfloat) _tmp21_)) * 100;
	ipct = (guint) pct;
	_tmp22_ = self->priv->_widget;
	_tmp23_ = g_strdup_printf ("%u", ipct);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "%", NULL);
	_tmp26_ = _tmp25_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp26_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_free0 (image_name);
}


GtkImage* sound_indicator_get_widget (SoundIndicator* self) {
	GtkImage* result;
	GtkImage* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}


void sound_indicator_set_widget (SoundIndicator* self, GtkImage* value) {
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_widget);
	self->priv->_widget = _tmp1_;
	g_object_notify ((GObject *) self, "widget");
}


GvcMixerControl* sound_indicator_get_mixer (SoundIndicator* self) {
	GvcMixerControl* result;
	GvcMixerControl* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mixer;
	result = _tmp0_;
	return result;
}


void sound_indicator_set_mixer (SoundIndicator* self, GvcMixerControl* value) {
	GvcMixerControl* _tmp0_ = NULL;
	GvcMixerControl* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_mixer);
	self->priv->_mixer = _tmp1_;
	g_object_notify ((GObject *) self, "mixer");
}


static void sound_indicator_class_init (SoundIndicatorClass * klass) {
	sound_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SoundIndicatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = sound_indicator_finalize;
	/** Current image to display */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_image_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Our mixer */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_MIXER, g_param_spec_object ("mixer", "mixer", "mixer", gvc_mixer_control_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sound_indicator_instance_init (SoundIndicator * self) {
	self->priv = SOUND_INDICATOR_GET_PRIVATE (self);
}


static void sound_indicator_finalize (GObject* obj) {
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_INDICATOR, SoundIndicator);
	_g_object_unref0 (self->priv->_widget);
	_g_object_unref0 (self->priv->_mixer);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (sound_indicator_parent_class)->finalize (obj);
}


GType sound_indicator_get_type (void) {
	return sound_indicator_type_id;
}


GType sound_indicator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (SoundIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundIndicator), 0, (GInstanceInitFunc) sound_indicator_instance_init, NULL };
	sound_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "SoundIndicator", &g_define_type_info, 0);
	return sound_indicator_type_id;
}


static void _vala_sound_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SOUND_INDICATOR, SoundIndicator);
	switch (property_id) {
		case SOUND_INDICATOR_WIDGET:
		g_value_set_object (value, sound_indicator_get_widget (self));
		break;
		case SOUND_INDICATOR_MIXER:
		g_value_set_object (value, sound_indicator_get_mixer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sound_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SOUND_INDICATOR, SoundIndicator);
	switch (property_id) {
		case SOUND_INDICATOR_WIDGET:
		sound_indicator_set_widget (self, g_value_get_object (value));
		break;
		case SOUND_INDICATOR_MIXER:
		sound_indicator_set_mixer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



