/* RunDialog.c generated by valac 0.32.1, the Vala compiler
 * generated from RunDialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <theme.h>


#define BUDGIE_TYPE_APP_LAUNCHER_BUTTON (budgie_app_launcher_button_get_type ())
#define BUDGIE_APP_LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButton))
#define BUDGIE_APP_LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButtonClass))
#define BUDGIE_IS_APP_LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON))
#define BUDGIE_IS_APP_LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APP_LAUNCHER_BUTTON))
#define BUDGIE_APP_LAUNCHER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButtonClass))

typedef struct _BudgieAppLauncherButton BudgieAppLauncherButton;
typedef struct _BudgieAppLauncherButtonClass BudgieAppLauncherButtonClass;
typedef struct _BudgieAppLauncherButtonPrivate BudgieAppLauncherButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_RUN_DIALOG (budgie_run_dialog_get_type ())
#define BUDGIE_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog))
#define BUDGIE_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))
#define BUDGIE_IS_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_IS_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_RUN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))

typedef struct _BudgieRunDialog BudgieRunDialog;
typedef struct _BudgieRunDialogClass BudgieRunDialogClass;
typedef struct _BudgieRunDialogPrivate BudgieRunDialogPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define BUDGIE_TYPE_RUN_DIALOG_APP (budgie_run_dialog_app_get_type ())
#define BUDGIE_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp))
#define BUDGIE_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))
#define BUDGIE_IS_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_IS_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_RUN_DIALOG_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))

typedef struct _BudgieRunDialogApp BudgieRunDialogApp;
typedef struct _BudgieRunDialogAppClass BudgieRunDialogAppClass;
typedef struct _BudgieRunDialogAppPrivate BudgieRunDialogAppPrivate;

struct _BudgieAppLauncherButton {
	GtkBox parent_instance;
	BudgieAppLauncherButtonPrivate * priv;
	GAppInfo* app_info;
};

struct _BudgieAppLauncherButtonClass {
	GtkBoxClass parent_class;
};

struct _BudgieRunDialog {
	GtkApplicationWindow parent_instance;
	BudgieRunDialogPrivate * priv;
};

struct _BudgieRunDialogClass {
	GtkApplicationWindowClass parent_class;
};

struct _BudgieRunDialogPrivate {
	GSettings* settings;
	GtkCssProvider* css_provider;
	gchar* current_theme_uri;
	GtkRevealer* bottom_revealer;
	GtkListBox* app_box;
	GtkSearchEntry* entry;
	gchar* search_text;
};

struct _BudgieRunDialogApp {
	GtkApplication parent_instance;
	BudgieRunDialogAppPrivate * priv;
};

struct _BudgieRunDialogAppClass {
	GtkApplicationClass parent_class;
};

struct _BudgieRunDialogAppPrivate {
	BudgieRunDialog* rd;
};


static gpointer budgie_app_launcher_button_parent_class = NULL;
static gpointer budgie_run_dialog_parent_class = NULL;
static gpointer budgie_run_dialog_app_parent_class = NULL;

GType budgie_app_launcher_button_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_APP_LAUNCHER_BUTTON_DUMMY_PROPERTY
};
BudgieAppLauncherButton* budgie_app_launcher_button_new (GAppInfo* info);
BudgieAppLauncherButton* budgie_app_launcher_button_construct (GType object_type, GAppInfo* info);
static void budgie_app_launcher_button_finalize (GObject* obj);
GType budgie_run_dialog_get_type (void) G_GNUC_CONST;
#define BUDGIE_RUN_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogPrivate))
enum  {
	BUDGIE_RUN_DIALOG_DUMMY_PROPERTY
};
BudgieRunDialog* budgie_run_dialog_new (GtkApplication* app);
BudgieRunDialog* budgie_run_dialog_construct (GType object_type, GtkApplication* app);
static void budgie_run_dialog_on_settings_changed (BudgieRunDialog* self, const gchar* key);
static void _budgie_run_dialog_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void budgie_run_dialog_on_theme_changed (BudgieRunDialog* self);
static void _budgie_run_dialog_on_theme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean budgie_run_dialog_on_key_release (BudgieRunDialog* self, GdkEventKey* btn);
static gboolean _budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void budgie_run_dialog_on_search_changed (BudgieRunDialog* self);
static void _budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void budgie_run_dialog_on_search_activate (BudgieRunDialog* self);
static void _budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void budgie_run_dialog_on_row_activate (BudgieRunDialog* self, GtkListBoxRow* row);
static void _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static gboolean budgie_run_dialog_on_filter (BudgieRunDialog* self, GtkListBoxRow* row);
static gboolean _budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static void budgie_run_dialog_build_app_box (BudgieRunDialog* self);
static gboolean __lambda6_ (BudgieRunDialog* self);
static gboolean ___lambda6__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void budgie_run_dialog_launch_button (BudgieRunDialog* self, BudgieAppLauncherButton* button);
static gboolean ___lambda5_ (BudgieRunDialog* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void budgie_run_dialog_add_application (BudgieRunDialog* self, GAppInfo* app_info);
static void _budgie_run_dialog_add_application_gfunc (gconstpointer data, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean ___lambda4_ (BudgieRunDialog* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void budgie_run_dialog_set_css_from_uri (BudgieRunDialog* self, const gchar* uri);
static void budgie_run_dialog_finalize (GObject* obj);
GType budgie_run_dialog_app_get_type (void) G_GNUC_CONST;
#define BUDGIE_RUN_DIALOG_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppPrivate))
enum  {
	BUDGIE_RUN_DIALOG_APP_DUMMY_PROPERTY
};
BudgieRunDialogApp* budgie_run_dialog_app_new (void);
BudgieRunDialogApp* budgie_run_dialog_app_construct (GType object_type);
static void budgie_run_dialog_app_real_activate (GApplication* base);
static void budgie_run_dialog_app_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgieAppLauncherButton* budgie_app_launcher_button_construct (GType object_type, GAppInfo* info) {
	BudgieAppLauncherButton * self = NULL;
	GAppInfo* _tmp0_ = NULL;
	GAppInfo* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkImage* image = NULL;
	GAppInfo* _tmp3_ = NULL;
	GIcon* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	gchar* nom = NULL;
	GAppInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* sdesc = NULL;
	GAppInfo* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* desc = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GValue _tmp25_ = {0};
	GAppInfo* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	self = (BudgieAppLauncherButton*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, NULL);
	_tmp0_ = info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->app_info);
	self->app_info = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "launcher-button");
	_tmp3_ = info;
	_tmp4_ = g_app_info_get_icon (_tmp3_);
	_tmp5_ = (GtkImage*) gtk_image_new_from_gicon (_tmp4_, GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp5_);
	image = _tmp5_;
	_tmp6_ = image;
	gtk_image_set_pixel_size (_tmp6_, 48);
	_tmp7_ = image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 8);
	_tmp8_ = image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = info;
	_tmp10_ = g_app_info_get_name (_tmp9_);
	_tmp11_ = g_markup_escape_text (_tmp10_, (gssize) -1);
	nom = _tmp11_;
	_tmp12_ = info;
	_tmp13_ = g_app_info_get_description (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	sdesc = _tmp14_;
	_tmp15_ = sdesc;
	if (_tmp15_ == NULL) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("");
		_g_free0 (sdesc);
		sdesc = _tmp16_;
	}
	_tmp17_ = sdesc;
	_tmp18_ = g_markup_escape_text (_tmp17_, (gssize) -1);
	desc = _tmp18_;
	_tmp19_ = nom;
	_tmp20_ = g_strdup_printf ("<big>%s</big>\n<small>%s</small>", _tmp19_, desc);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	label = _tmp23_;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_add_class (_tmp24_, "dim-label");
	gtk_label_set_line_wrap (label, TRUE);
	g_value_init (&_tmp25_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp25_, 0.0);
	g_object_set_property ((GObject*) label, "xalign", &_tmp25_);
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	gtk_label_set_use_markup (label, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) label, 12);
	gtk_label_set_max_width_chars (label, 60);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_hexpand ((GtkWidget*) self, FALSE);
	gtk_widget_set_vexpand ((GtkWidget*) self, FALSE);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp26_ = info;
	_tmp27_ = g_app_info_get_name (_tmp26_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp27_);
	gtk_widget_set_margin_top ((GtkWidget*) self, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 3);
	_g_object_unref0 (label);
	_g_free0 (desc);
	_g_free0 (sdesc);
	_g_free0 (nom);
	_g_object_unref0 (image);
	return self;
}


BudgieAppLauncherButton* budgie_app_launcher_button_new (GAppInfo* info) {
	return budgie_app_launcher_button_construct (BUDGIE_TYPE_APP_LAUNCHER_BUTTON, info);
}


static void budgie_app_launcher_button_class_init (BudgieAppLauncherButtonClass * klass) {
	budgie_app_launcher_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_app_launcher_button_finalize;
}


static void budgie_app_launcher_button_instance_init (BudgieAppLauncherButton * self) {
	self->app_info = NULL;
}


static void budgie_app_launcher_button_finalize (GObject* obj) {
	BudgieAppLauncherButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButton);
	_g_object_unref0 (self->app_info);
	G_OBJECT_CLASS (budgie_app_launcher_button_parent_class)->finalize (obj);
}


/**
 * Simple launcher button
 */
GType budgie_app_launcher_button_get_type (void) {
	static volatile gsize budgie_app_launcher_button_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_app_launcher_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieAppLauncherButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_app_launcher_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppLauncherButton), 0, (GInstanceInitFunc) budgie_app_launcher_button_instance_init, NULL };
		GType budgie_app_launcher_button_type_id;
		budgie_app_launcher_button_type_id = g_type_register_static (gtk_box_get_type (), "BudgieAppLauncherButton", &g_define_type_info, 0);
		g_once_init_leave (&budgie_app_launcher_button_type_id__volatile, budgie_app_launcher_button_type_id);
	}
	return budgie_app_launcher_button_type_id__volatile;
}


static void _budgie_run_dialog_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_run_dialog_on_settings_changed ((BudgieRunDialog*) self, key);
}


static void _budgie_run_dialog_on_theme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	budgie_run_dialog_on_theme_changed ((BudgieRunDialog*) self);
}


static gboolean _budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = budgie_run_dialog_on_key_release ((BudgieRunDialog*) self, event);
	return result;
}


static void _budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	budgie_run_dialog_on_search_changed ((BudgieRunDialog*) self);
}


static void _budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	budgie_run_dialog_on_search_activate ((BudgieRunDialog*) self);
}


static void _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	budgie_run_dialog_on_row_activate ((BudgieRunDialog*) self, row);
}


static gboolean _budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = budgie_run_dialog_on_filter ((BudgieRunDialog*) self, row);
	return result;
}


static gboolean __lambda6_ (BudgieRunDialog* self) {
	gboolean result = FALSE;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda6__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda6_ ((BudgieRunDialog*) self);
	return result;
}


BudgieRunDialog* budgie_run_dialog_construct (GType object_type, GtkApplication* app) {
	BudgieRunDialog * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkVisual* _tmp3_ = NULL;
	GdkVisual* _tmp4_ = NULL;
	GdkVisual* _tmp5_ = NULL;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp7_ = NULL;
	GtkStyleContext* _tmp8_ = NULL;
	GtkSettings* gtksettings = NULL;
	GtkSettings* _tmp9_ = NULL;
	GtkSettings* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkSearchEntry* _tmp17_ = NULL;
	GtkSearchEntry* _tmp18_ = NULL;
	GtkSearchEntry* _tmp19_ = NULL;
	GtkSearchEntry* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkSearchEntry* _tmp22_ = NULL;
	GtkRevealer* _tmp23_ = NULL;
	GtkRevealer* _tmp24_ = NULL;
	GtkListBox* _tmp25_ = NULL;
	GtkListBox* _tmp26_ = NULL;
	GtkListBox* _tmp27_ = NULL;
	GtkListBox* _tmp28_ = NULL;
	GtkListBox* _tmp29_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp30_ = NULL;
	GtkStyleContext* _tmp31_ = NULL;
	GtkListBox* _tmp32_ = NULL;
	GtkRevealer* _tmp33_ = NULL;
	GtkRevealer* _tmp34_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (BudgieRunDialog*) g_object_new (object_type, "application", _tmp0_, NULL);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_screen_get_rgba_visual (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	visual = _tmp4_;
	_tmp5_ = visual;
	if (_tmp5_ != NULL) {
		GdkVisual* _tmp6_ = NULL;
		_tmp6_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp6_);
	}
	_tmp7_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp7_);
	header = _tmp7_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp8_, "titlebar");
	_tmp9_ = gtk_settings_get_default ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	gtksettings = _tmp10_;
	_tmp11_ = g_settings_new ("com.solus-project.budgie-panel");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp11_;
	_tmp12_ = self->priv->settings;
	g_settings_bind (_tmp12_, "dark-theme", (GObject*) gtksettings, "gtk-application-prefer-dark-theme", G_SETTINGS_BIND_GET);
	_tmp13_ = self->priv->settings;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) _budgie_run_dialog_on_settings_changed_g_settings_changed, self, 0);
	g_signal_connect_object ((GObject*) gtksettings, "notify::gtk-theme-name", (GCallback) _budgie_run_dialog_on_theme_changed_g_object_notify, self, 0);
	budgie_run_dialog_on_settings_changed (self, "builtin-theme");
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp14_, "budgie-run-dialog");
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _budgie_run_dialog_on_key_release_gtk_widget_key_release_event, self, 0);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	main_layout = _tmp15_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_layout);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp16_);
	hbox = _tmp16_;
	gtk_box_pack_start (main_layout, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp17_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp17_;
	_tmp18_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp18_, "changed", (GCallback) _budgie_run_dialog_on_search_changed_gtk_editable_changed, self, 0);
	_tmp19_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp19_, "activate", (GCallback) _budgie_run_dialog_on_search_activate_gtk_entry_activate, self, 0);
	_tmp20_ = self->priv->entry;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_set_junction_sides (_tmp21_, GTK_JUNCTION_BOTTOM);
	_tmp22_ = self->priv->entry;
	gtk_box_pack_start (hbox, (GtkWidget*) _tmp22_, TRUE, TRUE, (guint) 0);
	_tmp23_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->bottom_revealer);
	self->priv->bottom_revealer = _tmp23_;
	_tmp24_ = self->priv->bottom_revealer;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
	_tmp25_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->app_box);
	self->priv->app_box = _tmp25_;
	_tmp26_ = self->priv->app_box;
	gtk_list_box_set_selection_mode (_tmp26_, GTK_SELECTION_SINGLE);
	_tmp27_ = self->priv->app_box;
	gtk_list_box_set_activate_on_single_click (_tmp27_, TRUE);
	_tmp28_ = self->priv->app_box;
	g_signal_connect_object (_tmp28_, "row-activated", (GCallback) _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp29_ = self->priv->app_box;
	gtk_list_box_set_filter_func (_tmp29_, _budgie_run_dialog_on_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp30_);
	scroll = _tmp30_;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_set_junction_sides (_tmp31_, GTK_JUNCTION_TOP);
	gtk_widget_set_size_request ((GtkWidget*) scroll, -1, 300);
	_tmp32_ = self->priv->app_box;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp32_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp33_ = self->priv->bottom_revealer;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) scroll);
	_tmp34_ = self->priv->bottom_revealer;
	gtk_revealer_set_reveal_child (_tmp34_, FALSE);
	budgie_run_dialog_build_app_box (self);
	gtk_widget_set_size_request ((GtkWidget*) self, 240, -1);
	gtk_widget_show_all ((GtkWidget*) main_layout);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda6__gtk_widget_focus_out_event, self, 0);
	_g_object_unref0 (scroll);
	_g_object_unref0 (hbox);
	_g_object_unref0 (main_layout);
	_g_object_unref0 (gtksettings);
	_g_object_unref0 (header);
	_g_object_unref0 (visual);
	return self;
}


BudgieRunDialog* budgie_run_dialog_new (GtkApplication* app) {
	return budgie_run_dialog_construct (BUDGIE_TYPE_RUN_DIALOG, app);
}


/**
     * Handle click/<enter> activation on the main list
     */
static void budgie_run_dialog_on_row_activate (BudgieRunDialog* self, GtkListBoxRow* row) {
	BudgieAppLauncherButton* child = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = row;
	_tmp1_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp0_) : NULL);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp1_) : NULL);
	child = _tmp2_;
	budgie_run_dialog_launch_button (self, child);
	_g_object_unref0 (child);
}


/**
     * Handle <enter> activation on the search
     */
static void budgie_run_dialog_on_search_activate (BudgieRunDialog* self) {
	BudgieAppLauncherButton* act = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	act = NULL;
	_tmp0_ = self->priv->app_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				gboolean _tmp2_ = FALSE;
				GtkWidget* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = row;
				_tmp4_ = gtk_widget_get_visible (_tmp3_);
				if (_tmp4_) {
					GtkWidget* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = row;
					_tmp6_ = gtk_widget_get_child_visible (_tmp5_);
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GtkWidget* _tmp7_ = NULL;
					GtkWidget* _tmp8_ = NULL;
					BudgieAppLauncherButton* _tmp9_ = NULL;
					_tmp7_ = row;
					_tmp8_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp7_) : NULL);
					_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp8_) : NULL);
					_g_object_unref0 (act);
					act = _tmp9_;
					break;
				}
			}
		}
		_g_list_free0 (row_collection);
	}
	_tmp10_ = act;
	if (_tmp10_ != NULL) {
		BudgieAppLauncherButton* _tmp11_ = NULL;
		_tmp11_ = act;
		budgie_run_dialog_launch_button (self, _tmp11_);
	}
	_g_object_unref0 (act);
}


/**
     * Launch the given preconfigured button
     */
static gboolean ___lambda5_ (BudgieRunDialog* self) {
	gboolean result = FALSE;
	gtk_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((BudgieRunDialog*) self);
	return result;
}


static void budgie_run_dialog_launch_button (BudgieRunDialog* self, BudgieAppLauncherButton* button) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GDesktopAppInfo* dinfo = NULL;
		BudgieAppLauncherButton* _tmp0_ = NULL;
		GAppInfo* _tmp1_ = NULL;
		GDesktopAppInfo* _tmp2_ = NULL;
		_tmp0_ = button;
		_tmp1_ = _tmp0_->app_info;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp1_) : NULL);
		dinfo = _tmp2_;
		g_desktop_app_info_launch_uris_as_manager (dinfo, NULL, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dinfo);
			goto __catch0_g_error;
		}
		gtk_widget_hide ((GtkWidget*) self);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (dinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkApplication* _tmp5_ = NULL;
		GtkApplication* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("RunDialog.vala:187: Error: %s\n", _tmp4_);
		_tmp5_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp6_ = _tmp5_;
		g_application_quit ((GApplication*) _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_run_dialog_on_search_changed (BudgieRunDialog* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkWidget* active_row = NULL;
	GtkListBox* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = _tmp2_;
	_tmp3_ = self->priv->app_box;
	gtk_list_box_invalidate_filter (_tmp3_);
	active_row = NULL;
	_tmp4_ = self->priv->app_box;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp5_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				gboolean _tmp6_ = FALSE;
				GtkWidget* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp7_ = row;
				_tmp8_ = gtk_widget_get_visible (_tmp7_);
				if (_tmp8_) {
					GtkWidget* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = row;
					_tmp10_ = gtk_widget_get_child_visible (_tmp9_);
					_tmp6_ = _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GtkWidget* _tmp11_ = NULL;
					GtkWidget* _tmp12_ = NULL;
					_tmp11_ = row;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (active_row);
					active_row = _tmp12_;
					break;
				}
			}
		}
		_g_list_free0 (row_collection);
	}
	_tmp13_ = active_row;
	if (_tmp13_ == NULL) {
		GtkRevealer* _tmp14_ = NULL;
		GtkRevealer* _tmp15_ = NULL;
		_tmp14_ = self->priv->bottom_revealer;
		gtk_revealer_set_transition_type (_tmp14_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
		_tmp15_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp15_, FALSE);
	} else {
		GtkRevealer* _tmp16_ = NULL;
		GtkRevealer* _tmp17_ = NULL;
		GtkListBox* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		_tmp16_ = self->priv->bottom_revealer;
		gtk_revealer_set_transition_type (_tmp16_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		_tmp17_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp17_, TRUE);
		_tmp18_ = self->priv->app_box;
		_tmp19_ = active_row;
		gtk_list_box_select_row (_tmp18_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp19_) : NULL);
	}
	_g_object_unref0 (active_row);
}


/**
     * Filter the list
     */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean budgie_run_dialog_on_filter (BudgieRunDialog* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	BudgieAppLauncherButton* button = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp2_ = NULL;
	gchar* disp_name = NULL;
	BudgieAppLauncherButton* _tmp3_ = NULL;
	GAppInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = row;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp1_) : NULL);
	button = _tmp2_;
	_tmp3_ = button;
	_tmp4_ = _tmp3_->app_info;
	_tmp5_ = g_app_info_get_name (_tmp4_);
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
	disp_name = _tmp6_;
	_tmp7_ = self->priv->search_text;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		result = FALSE;
		_g_free0 (disp_name);
		_g_object_unref0 (button);
		return result;
	}
	_tmp8_ = disp_name;
	_tmp9_ = self->priv->search_text;
	_tmp10_ = string_contains (_tmp8_, _tmp9_);
	if (_tmp10_) {
		result = TRUE;
		_g_free0 (disp_name);
		_g_object_unref0 (button);
		return result;
	}
	result = FALSE;
	_g_free0 (disp_name);
	_g_object_unref0 (button);
	return result;
}


/**
     * Build the app box in the background
     */
static void _budgie_run_dialog_add_application_gfunc (gconstpointer data, gpointer self) {
	budgie_run_dialog_add_application ((BudgieRunDialog*) self, (GAppInfo*) data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void budgie_run_dialog_build_app_box (BudgieRunDialog* self) {
	GList* apps = NULL;
	GList* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	GtkSearchEntry* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_all ();
	apps = _tmp0_;
	g_list_foreach (apps, _budgie_run_dialog_add_application_gfunc, self);
	_tmp1_ = self->priv->app_box;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->entry;
	gtk_entry_set_text ((GtkEntry*) _tmp2_, "");
	__g_list_free__g_object_unref0_0 (apps);
}


static void budgie_run_dialog_add_application (BudgieRunDialog* self, GAppInfo* app_info) {
	GDesktopAppInfo* dinfo = NULL;
	GAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GDesktopAppInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	BudgieAppLauncherButton* button = NULL;
	GAppInfo* _tmp4_ = NULL;
	BudgieAppLauncherButton* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	BudgieAppLauncherButton* _tmp7_ = NULL;
	BudgieAppLauncherButton* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_info;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp0_) : NULL);
	dinfo = _tmp1_;
	_tmp2_ = dinfo;
	_tmp3_ = g_desktop_app_info_get_nodisplay (_tmp2_);
	if (_tmp3_) {
		_g_object_unref0 (dinfo);
		return;
	}
	_tmp4_ = app_info;
	_tmp5_ = budgie_app_launcher_button_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	button = _tmp5_;
	_tmp6_ = self->priv->app_box;
	_tmp7_ = button;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp8_);
	_g_object_unref0 (button);
	_g_object_unref0 (dinfo);
}


/**
     * Be a good citizen and pretend to be a dialog.
     */
static gboolean ___lambda4_ (BudgieRunDialog* self) {
	gboolean result = FALSE;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((BudgieRunDialog*) self);
	return result;
}


static gboolean budgie_run_dialog_on_key_release (BudgieRunDialog* self, GdkEventKey* btn) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (btn != NULL, FALSE);
	_tmp0_ = btn;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Escape)) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


/**
     * Handle change to builtin-theme
     */
static void budgie_run_dialog_on_settings_changed (BudgieRunDialog* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "builtin-theme") != 0) {
		return;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = key;
	_tmp3_ = g_settings_get_boolean (_tmp1_, _tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = budgie_form_theme_path ("theme.css");
		_g_free0 (self->priv->current_theme_uri);
		self->priv->current_theme_uri = _tmp4_;
	} else {
		_g_free0 (self->priv->current_theme_uri);
		self->priv->current_theme_uri = NULL;
	}
	budgie_run_dialog_on_theme_changed (self);
}


/**
     * Set the CSS according to the current theme
     */
static void budgie_run_dialog_set_css_from_uri (BudgieRunDialog* self, const gchar* uri) {
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GtkCssProvider* new_provider = NULL;
	const gchar* _tmp2_ = NULL;
	GtkCssProvider* _tmp13_ = NULL;
	GtkCssProvider* _tmp16_ = NULL;
	GtkCssProvider* _tmp17_ = NULL;
	GdkScreen* _tmp18_ = NULL;
	GtkCssProvider* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	new_provider = NULL;
	_tmp2_ = uri;
	if (_tmp2_ == NULL) {
		GtkCssProvider* _tmp3_ = NULL;
		_tmp3_ = self->priv->css_provider;
		if (_tmp3_ != NULL) {
			GdkScreen* _tmp4_ = NULL;
			GtkCssProvider* _tmp5_ = NULL;
			_tmp4_ = screen;
			_tmp5_ = self->priv->css_provider;
			gtk_style_context_remove_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_);
			_g_object_unref0 (self->priv->css_provider);
			self->priv->css_provider = NULL;
		}
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		return;
	}
	{
		GFile* f = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GtkCssProvider* _tmp8_ = NULL;
		GtkCssProvider* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		f = _tmp7_;
		_tmp8_ = gtk_css_provider_new ();
		_g_object_unref0 (new_provider);
		new_provider = _tmp8_;
		_tmp9_ = new_provider;
		_tmp10_ = f;
		gtk_css_provider_load_from_file (_tmp9_, _tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch1_g_error;
		}
		_g_object_unref0 (f);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("RunDialog.vala:308: Error loading theme: %s", _tmp12_);
		_g_object_unref0 (new_provider);
		new_provider = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (new_provider);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->css_provider;
	if (_tmp13_ != NULL) {
		GdkScreen* _tmp14_ = NULL;
		GtkCssProvider* _tmp15_ = NULL;
		_tmp14_ = screen;
		_tmp15_ = self->priv->css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp14_, (GtkStyleProvider*) _tmp15_);
		_g_object_unref0 (self->priv->css_provider);
		self->priv->css_provider = NULL;
	}
	_tmp16_ = new_provider;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp17_;
	_tmp18_ = screen;
	_tmp19_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_screen (_tmp18_, (GtkStyleProvider*) _tmp19_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (new_provider);
	_g_object_unref0 (screen);
}


/**
     * Update our theming based on the internal theme setting
     */
static void budgie_run_dialog_on_theme_changed (BudgieRunDialog* self) {
	GtkSettings* gtksettings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	GtkSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtksettings = _tmp1_;
	_tmp2_ = gtksettings;
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "HighContrast") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp8_ = self->priv->current_theme_uri;
		if (_tmp8_ == NULL) {
			_g_free0 (_tmp7_);
			_tmp7_ = NULL;
		} else {
			gchar* _tmp9_ = NULL;
			_tmp9_ = budgie_form_theme_path ("theme_hc.css");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp9_;
		}
		budgie_run_dialog_set_css_from_uri (self, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = self->priv->current_theme_uri;
		budgie_run_dialog_set_css_from_uri (self, _tmp10_);
	}
	_g_object_unref0 (gtksettings);
}


static void budgie_run_dialog_class_init (BudgieRunDialogClass * klass) {
	budgie_run_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieRunDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_finalize;
}


static void budgie_run_dialog_instance_init (BudgieRunDialog * self) {
	gchar* _tmp0_ = NULL;
	self->priv = BUDGIE_RUN_DIALOG_GET_PRIVATE (self);
	self->priv->settings = NULL;
	self->priv->css_provider = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->search_text = _tmp0_;
}


static void budgie_run_dialog_finalize (GObject* obj) {
	BudgieRunDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->css_provider);
	_g_free0 (self->priv->current_theme_uri);
	_g_object_unref0 (self->priv->bottom_revealer);
	_g_object_unref0 (self->priv->app_box);
	_g_object_unref0 (self->priv->entry);
	_g_free0 (self->priv->search_text);
	G_OBJECT_CLASS (budgie_run_dialog_parent_class)->finalize (obj);
}


/**
 * The meat of the operation
 */
GType budgie_run_dialog_get_type (void) {
	static volatile gsize budgie_run_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_run_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialog), 0, (GInstanceInitFunc) budgie_run_dialog_instance_init, NULL };
		GType budgie_run_dialog_type_id;
		budgie_run_dialog_type_id = g_type_register_static (gtk_application_window_get_type (), "BudgieRunDialog", &g_define_type_info, 0);
		g_once_init_leave (&budgie_run_dialog_type_id__volatile, budgie_run_dialog_type_id);
	}
	return budgie_run_dialog_type_id__volatile;
}


BudgieRunDialogApp* budgie_run_dialog_app_construct (GType object_type) {
	BudgieRunDialogApp * self = NULL;
	self = (BudgieRunDialogApp*) g_object_new (object_type, "application-id", "com.solus_project.BudgieRunDialog", "flags", 0, NULL);
	return self;
}


BudgieRunDialogApp* budgie_run_dialog_app_new (void) {
	return budgie_run_dialog_app_construct (BUDGIE_TYPE_RUN_DIALOG_APP);
}


static void budgie_run_dialog_app_real_activate (GApplication* base) {
	BudgieRunDialogApp * self;
	BudgieRunDialog* _tmp0_ = NULL;
	BudgieRunDialog* _tmp2_ = NULL;
	self = (BudgieRunDialogApp*) base;
	_tmp0_ = self->priv->rd;
	if (_tmp0_ == NULL) {
		BudgieRunDialog* _tmp1_ = NULL;
		_tmp1_ = budgie_run_dialog_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->rd);
		self->priv->rd = _tmp1_;
	}
	_tmp2_ = self->priv->rd;
	gtk_window_present ((GtkWindow*) _tmp2_);
}


static void budgie_run_dialog_app_class_init (BudgieRunDialogAppClass * klass) {
	budgie_run_dialog_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieRunDialogAppPrivate));
	((GApplicationClass *) klass)->activate = budgie_run_dialog_app_real_activate;
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_app_finalize;
}


static void budgie_run_dialog_app_instance_init (BudgieRunDialogApp * self) {
	self->priv = BUDGIE_RUN_DIALOG_APP_GET_PRIVATE (self);
	self->priv->rd = NULL;
}


static void budgie_run_dialog_app_finalize (GObject* obj) {
	BudgieRunDialogApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp);
	_g_object_unref0 (self->priv->rd);
	G_OBJECT_CLASS (budgie_run_dialog_app_parent_class)->finalize (obj);
}


/**
 * GtkApplication for single instance wonderness
 */
GType budgie_run_dialog_app_get_type (void) {
	static volatile gsize budgie_run_dialog_app_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_run_dialog_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialogApp), 0, (GInstanceInitFunc) budgie_run_dialog_app_instance_init, NULL };
		GType budgie_run_dialog_app_type_id;
		budgie_run_dialog_app_type_id = g_type_register_static (gtk_application_get_type (), "BudgieRunDialogApp", &g_define_type_info, 0);
		g_once_init_leave (&budgie_run_dialog_app_type_id__volatile, budgie_run_dialog_app_type_id);
	}
	return budgie_run_dialog_app_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	BudgieRunDialogApp* rd = NULL;
	BudgieRunDialogApp* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	_tmp0_ = budgie_run_dialog_app_new ();
	rd = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) rd, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (rd);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



