/* ListItem.c generated by valac 0.32.1, the Vala compiler
 * generated from ListItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Solus Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <gdk/gdk.h>


#define TYPE_LIST_ITEM (list_item_get_type ())
#define LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_ITEM, ListItem))
#define LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_ITEM, ListItemClass))
#define IS_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_ITEM))
#define IS_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_ITEM))
#define LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_ITEM, ListItemClass))

typedef struct _ListItem ListItem;
typedef struct _ListItemClass ListItemClass;
typedef struct _ListItemPrivate ListItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ListItem {
	GtkBox parent_instance;
	ListItemPrivate * priv;
	gchar* item_class;
	gchar* category_name;
	GtkToolButton* name_button;
	GtkOverlay* overlay;
	GtkSpinner* spin;
};

struct _ListItemClass {
	GtkBoxClass parent_class;
};


static gpointer list_item_parent_class = NULL;
static GType list_item_type_id = 0;

GType list_item_get_type (void) G_GNUC_CONST;
GType list_item_register_type (GTypeModule * module);
enum  {
	LIST_ITEM_DUMMY_PROPERTY
};
ListItem* list_item_construct (GType object_type);
void list_item_set_button (ListItem* self, const gchar* label, GtkImage* image, gboolean spinner);
GtkImage* list_item_get_icon (ListItem* self, GIcon* icon);
gchar* list_item_get_item_category (ListItem* self);
void list_item_open_directory (ListItem* self, const gchar* location);
static void list_item_finalize (GObject* obj);


ListItem* list_item_construct (GType object_type) {
	ListItem * self = NULL;
	GtkToolButton* _tmp0_ = NULL;
	GtkToolButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	GtkOverlay* _tmp5_ = NULL;
	GtkOverlay* _tmp6_ = NULL;
	GtkToolButton* _tmp7_ = NULL;
	GtkOverlay* _tmp8_ = NULL;
	self = (ListItem*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->name_button);
	self->name_button = _tmp0_;
	_tmp1_ = self->name_button;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	gtk_style_context_add_class (_tmp3_, "name-button");
	_tmp4_ = self->name_button;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->overlay);
	self->overlay = _tmp5_;
	_tmp6_ = self->overlay;
	_tmp7_ = self->name_button;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->overlay;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	return self;
}


void list_item_set_button (ListItem* self, const gchar* label, GtkImage* image, gboolean spinner) {
	GtkBox* box = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkImage* _tmp3_ = NULL;
	GtkLabel* label_w = NULL;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkToolButton* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 5);
	_tmp2_ = box;
	_tmp3_ = image;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = label;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	label_w = _tmp5_;
	_tmp6_ = label_w;
	gtk_label_set_max_width_chars (_tmp6_, 25);
	_tmp7_ = label_w;
	gtk_label_set_ellipsize (_tmp7_, PANGO_ELLIPSIZE_END);
	_tmp8_ = label_w;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = box;
	_tmp10_ = label_w;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, TRUE, TRUE, (guint) 0);
	_tmp11_ = spinner;
	if (_tmp11_) {
		GtkSpinner* _tmp12_ = NULL;
		GtkSpinner* _tmp13_ = NULL;
		GtkBox* _tmp14_ = NULL;
		GtkSpinner* _tmp15_ = NULL;
		_tmp12_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->spin);
		self->spin = _tmp12_;
		_tmp13_ = self->spin;
		gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_END);
		_tmp14_ = box;
		_tmp15_ = self->spin;
		gtk_box_pack_end (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 2);
	}
	_tmp16_ = self->name_button;
	_tmp17_ = box;
	gtk_tool_button_set_label_widget (_tmp16_, (GtkWidget*) _tmp17_);
	_g_object_unref0 (label_w);
	_g_object_unref0 (box);
}


GtkImage* list_item_get_icon (ListItem* self, GIcon* icon) {
	GtkImage* result = NULL;
	GIcon* _tmp0_ = NULL;
	gchar* icon_name = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	const gchar* _tmp10_ = NULL;
	GtkImage* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = icon;
	if (_tmp0_ != NULL) {
		GIcon* _tmp1_ = NULL;
		GtkImage* _tmp2_ = NULL;
		_tmp1_ = icon;
		_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (_tmp1_, GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp2_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->item_class;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_ = NULL;
				_tmp7_ = g_strdup ("drive-harddisk-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp7_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("folder-remote-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp8_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("folder-symbolic");
				_g_free0 (icon_name);
				icon_name = _tmp9_;
				break;
			}
		}
	}
	_tmp10_ = icon_name;
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp10_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp11_);
	result = _tmp11_;
	_g_free0 (icon_name);
	return result;
}


gchar* list_item_get_item_category (ListItem* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->category_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void list_item_open_directory (ListItem* self, const gchar* location) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = gdk_screen_get_default ();
		_tmp1_ = location;
		gtk_show_uri (_tmp0_, _tmp1_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("ListItem.vala:101: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void list_item_class_init (ListItemClass * klass) {
	list_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = list_item_finalize;
}


static void list_item_instance_init (ListItem * self) {
}


static void list_item_finalize (GObject* obj) {
	ListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_ITEM, ListItem);
	_g_free0 (self->item_class);
	_g_free0 (self->category_name);
	_g_object_unref0 (self->name_button);
	_g_object_unref0 (self->overlay);
	_g_object_unref0 (self->spin);
	G_OBJECT_CLASS (list_item_parent_class)->finalize (obj);
}


GType list_item_get_type (void) {
	return list_item_type_id;
}


GType list_item_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListItem), 0, (GInstanceInitFunc) list_item_instance_init, NULL };
	list_item_type_id = g_type_module_register_type (module, gtk_box_get_type (), "ListItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return list_item_type_id;
}



