#pragma implementation

#include "config.h"

#include "Environment.h"

#include <sys/types.h>  // fork, stat, utimes
#include <unistd.h>     // fork, execl, isatty, pipe
#include <sys/stat.h>   // stat
#include <sys/time.h>   // utimes
#include <sys/wait.h>


#include <errno.h>

#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
/*
#include <fcntl.h>
*/

#include <glibmm/dispatcher.h>


using namespace std;
using namespace buffy;

Environment* Environment::instance = 0;

// Dispatcher for sigchld events
static Glib::Dispatcher dispatcher;

static void termination_handler(int signum)
{
	//fprintf(stderr, "SIGNAL %d\n", signum);
	dispatcher.emit();
}

void Environment::init() throw (SystemException, ConsistencyCheckException)
{
	if (instance == 0)
		instance = new Environment();
}

void Environment::on_sigchld()
{
	int pid, status;
	while (1)
	{
		pid = waitpid (WAIT_ANY, &status, WNOHANG);
		if (pid < 0)
		{
			//perror ("waitpid");
			break;
		}
		if (pid == 0)
			break;
		::verbose("Child %d exited with status %d\n", (int)pid, (int)status);
		signal_child_exit().emit(pid, status);
	}
}

Environment::Environment() throw (SystemException, ConsistencyCheckException) 
	: _verbose(false), _debug(false), _config()
{
	// Connect the dispatcher to the child exit signal
	dispatcher.connect(sigc::mem_fun(*this, &Environment::on_sigchld));

	// Setup the SIGCHLD handler
	struct sigaction new_action;
	new_action.sa_handler = termination_handler;
	sigemptyset(&new_action.sa_mask);
	new_action.sa_flags = SA_NOCLDSTOP; //0;
	sigaction(SIGCHLD, &new_action, NULL);
}

void Environment::enumerateFolders(MailFolderConsumer& cons) throw (Exception)
{
	vector<string> locations = config().folder_locations().get();
	for (vector<string>::const_iterator i = locations.begin();
			i != locations.end(); i++)
	{
		::verbose("Scanning folder location %.*s\n", PFSTR(*i));
		MailFolder::enumerateFolders(*i, cons);
	}
}


void Environment::spawnCommand(const std::string& command) throw (SystemException)
{
	pid_t child = fork();
	if (child == -1)
		throw SystemException(errno, "trying to fork a child process");
	
	if (child == 0)
	{
		// Child code path
		try {
			execl("/bin/sh", "/bin/sh", "-c", command.c_str(), 0);
			throw SystemException(errno, "trying to fork a child process");
		} catch (Exception& e) {
			fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
		}
		exit(0);
	}
}


void fatal_error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	fprintf(stderr, "buffy: ");
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
	exit(1);
}

void error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
}

void warning(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
}

void verbose(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (Environment::get().verbose())
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
}

void debug(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (Environment::get().debug())
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
}

void feedback(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (isatty(1))
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stdout, fmt, ap);
		va_end(ap);
	}
}



// vim:set ts=4 sw=4:
