#ifndef SMART_POINTER_H
#define SMART_POINTER_H

template<class ITEM>
class SmartPointer
{
protected:
	ITEM* impl;

public:
	SmartPointer() throw () : impl(0) {}

	SmartPointer(const SmartPointer& sp) throw ()
	{
		if (sp.impl)
			sp.impl->ref();
		impl = sp.impl;
	}

	SmartPointer(ITEM* otherimpl) throw ()
	{
		if (otherimpl)
			otherimpl->ref();
		impl = otherimpl;
	}

	~SmartPointer() throw ()
	{
		if (impl && impl->unref())
			delete impl;
	}

	SmartPointer& operator=(const SmartPointer& sp) throw ()
	{
		if (sp.impl)
			sp.impl->ref();  // Do it early to correctly handle the case of x = x;
		if (impl && impl->unref())
			delete impl;
		impl = sp.impl;
		return *this;
	}

	operator bool() const throw () { return impl != 0; }
};

class SmartPointerItem
{
protected:
	int _ref;

public:
	SmartPointerItem() throw () : _ref(0) {}
	
	/// Increment the reference count for this object
	void ref() throw () { ++_ref; }

	/// Decrement the reference count for this object, returning true when it
	/// reaches 0
	bool unref() throw () { return --_ref == 0; }
};

// vim:set ts=3 sw=3:
#endif
