#ifndef MAILPROGRAM_H
#define MAILPROGRAM_H

#pragma interface

/*
 * Mail program interface
 *
 * Copyright (C) 2004  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <string>
#include <libbuffy/SmartPointer.h>
#include <libbuffy/Exception.h>
#include <libbuffy/MailFolder.h>

class MailProgram;

class MailProgramImpl : public SmartPointerItem
{
protected:
	std::string _name;
	std::string _command;
	bool _selected;

	//void on_exit();
	
public:
	MailProgramImpl(const std::string& name, const std::string& command) throw ()
		: _name(name), _command(command), _selected(false) {}
	MailProgramImpl(const std::string& name, const std::string& command, bool selected) throw ()
		: _name(name), _command(command), _selected(selected) {}
	~MailProgramImpl() throw () {}

	/**
	 * Runs the mail program on the specified folder path
	 *
	 * Substitutions in the commandline are:
	 *  %p: folder path
	 */
	void run(const MailFolder& folder) throw (SystemException, ConsistencyCheckException);

	friend class MailProgram;
};

class MailProgram : public SmartPointer<MailProgramImpl>
{
public:
	MailProgram() throw () : SmartPointer<MailProgramImpl>() {}
	MailProgram(const MailProgram& mf) throw () : SmartPointer<MailProgramImpl>(mf) {}
	//MailProgram(MailProgramImpl* otherimpl) throw () : SmartPointer<MailProgramImpl>(otherimpl) {}
	MailProgram(const std::string& name, const std::string& command) throw ()
		: SmartPointer<MailProgramImpl>(new MailProgramImpl(name, command)) {}
	MailProgram(const std::string& name, const std::string& command, bool selected) throw ()
		: SmartPointer<MailProgramImpl>(new MailProgramImpl(name, command, selected)) {}
	
	const std::string& name() const throw () { return impl->_name; }
	const std::string& command() const throw () { return impl->_command; }
	bool selected() const throw () { return impl->_selected; }

	void setName(const std::string& name) throw () { impl->_name = name; }
	void setCommand(const std::string& command) throw () { impl->_command = command; }
	void setSelected(bool selected) throw () { impl->_selected = selected; }

	/**
	 * Runs the mail program on the specified folder path
	 *
	 * Substitutions in the commandline are:
	 *  %p: folder path
	 */
	void run(const MailFolder& folder) throw (SystemException, ConsistencyCheckException)
	{
		impl->run(folder);
	}
};

// vim:set ts=4 sw=4:
#endif
