#Plugins must start with "Plugin"
#Put them in ~/.bughugger/plugins
#
# Author: Brian Murray <brian@canonical.com>
# Copyright (C) 2009 Canonical, Ltd.
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This plugin will tag bugs with a release code name depending on the apport release information in the description

class PluginReleaseTag():
    def __init__(self, launchpad):
        print "initializing PluginReleaseTag"
        self.launchpad = launchpad

    @property
    def buttontext(self):
        return "_Release Tag"

    def action(self, bug_tasks):
        release_tags = { '8.04':'hardy', '8.10':'intrepid', '9.04':'jaunty', '9.10':'karmic', '10.04':'lucid' }
        for bug_task in bug_tasks:
            for line in bug_task.bug.description.split('\n'):
                if 'DistroRelease: ' in line:
                    release = line.split()[-1]
                    break
            release_tag = release_tags[release]
            if release_tag not in bug_task.bug.tags:
                bug = self.launchpad.bugs[bug_task.bug.id]# fresh bug object, LP: #336866 workaround
                bug.tags = bug.tags + ['%s' % release_tag]# LP: #254901 workaround
                bug.lp_save()

    @property
    def hide(self):
        return False

def InitializePlugin(launchpad):
    inst = PluginReleaseTag(launchpad)
    return inst
