# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'усякі',
    blacklisted => '(у чорным спісе)',
    checking_for => 'Праверка',
    checking_dbd      => 'Праверка даступным модуляў DBD perl...',
    checking_optional => 'Наступныя модулі Perl неабавязковыя:',
    checking_modules  => 'Правека модуляў perl...',
    done => 'гатова.',
    header => "* Гэта Багзіла ##bz_ver## на perl ##perl_ver##\n"
            . "* Выковаецца на ##os_name## ##os_ver##",
    install_all => <<EOT,

Каб паспрабаваць правесці самаўсталяванне кожнага патрэбнага і неабавязковага модуля
адным загадам, зрабіце:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
ПАПЯРЭДЖАННЕ: Асобныя здаткі ў слупку ##table##.##column## даўжэйшыя чым
яго новае абмежаванне даўжыні ў ##max_length## знакаў. Здаткі, якія павінны быць
выпраўлены, надрукаваны ніжэй з значэннем слупка ##id_column## і
з значэннем слупка ##column##, які павінен быць выпраўлены:

EOT
    install_module => 'Усталяванне ##module## версіі ##version##...',
    max_allowed_packet => <<EOT,
ПАПЯРЭДЖАННЕ: Вы мусіце ўсталяваць параметар max_allowed_packet 
у вашых наладжваннях  MySQL па меншай меры ў ##needed##. Зараз 
ён мае значэнне ##current##. Вы можаце прызначыць гэты параметар
у раздзеле [mysqld] вашага файла наладжванняў MySQL.
EOT
    module_found => "знойдзены v##ver##",
    module_not_found => "не знойдзены",
    module_ok => 'добра',
    module_unknown_version => "знойдзена невядомая версія",
    template_precompile   => "Прадкампіляцыя ўзораў...",
    template_removing_dir => "Выдаленне існых скампіляваных узораў...",
);

1;
