package buoy.event;

import buoy.widget.*;
import java.util.*;

/**
 * ValueChangedEvents are generated by Widgets that allow the user to enter a value,
 * whenever the value changes.
 *
 * @author Peter Eastman
 */

public class ValueChangedEvent extends EventObject implements WidgetEvent
{
  private Widget widget;
  private boolean inProgress;

  /**
   * Create a ValueChangedEvent.
   *
   * @param widget     the Widget whose value has changed
   */
  
  public ValueChangedEvent(Widget widget)
  {
    this(widget, false);
  }

  /**
   * Create a ValueChangedEvent.
   *
   * @param widget       the Widget whose value has changed
   * @param inProgress   specifies whether this event represents a value change that is still in progress
   */
  
  public ValueChangedEvent(Widget widget, boolean inProgress)
  {
    super(widget);
    this.widget = widget;
    this.inProgress = inProgress;
  }

  /**
   * Get the Widget which generated this event.
   */
  
  public Widget getWidget()
  {
    return widget;
  }
  
  /**
   * Determine whether this event represents a value change that is still in progress.  For example,
   * if the user drags the thumb of a scrollbar but has not yet released the mouse button, this
   * method will return true.  An in progress ValueChangedEvent will always be followed by another
   * one when the value change is complete.
   */
  
  public boolean isInProgress()
  {
    return inProgress;
  }
}