#    hooks.py -- Hook support for builddeb.
#    Copyright (C) 2006 James Westby <jw+debian@jameswestby.net>
#    
#    This file is part of bzr-builddeb.
#
#    bzr-builddeb is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    bzr-builddeb is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with bzr-builddeb; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

import subprocess

from bzrlib.trace import info

from bzrlib.plugins.builddeb.errors import HookFailedError


def run_hook(hook_name, config, wd=None):
  hook = config.get_hook(hook_name)
  if hook is None:
    return
  info("Running %s as %s hook" % (hook, hook_name))
  kwargs = {}
  if wd is not None:
    kwargs['cwd'] = wd
  proc = subprocess.Popen(hook, shell=True, **kwargs)
  proc.wait()
  if proc.returncode != 0:
    raise HookFailedError(hook_name)

# vim: ts=2 sts=2 sw=2
