#include <type_traits>
#include <string>
#include <iostream>

template <typename Type>
concept bool Object()
{
    return
        std::is_integral<Type>::value
        ||
        std::is_class<Type>::value
        ||
        std::is_enum<Type>::value
    ;

//requires()
//        {
//            false;
////            std::is_integral<Type>::value == true;
//        };
}

template <Object Obj>
void fun(Obj &&obj)
{}

using namespace std;

int main(int argc, char **argv)
{
    size_t st;
    fun(st);
    fun(12);
    fun(std::string{"hello"});
    int &ir = argc;
    fun(ir);

    cout << std::is_object<std::string>::value << ' ' <<
            std::is_object<int>::value << ' ' <<
            std::is_reference<int>::value << '\n';
}
