from __future__ import with_statement
__license__   = 'GPL v3'
__copyright__ = '2009, James Beal, james_@catbus.co.uk'
__docformat__ = 'restructuredtext en'

'crop a pdf file'

import os, sys, re
from calibre.utils.config import Config, StringConfig
from pyPdf import PdfFileWriter, PdfFileReader

def config(defaults=None):
    desc = _('Options to control the transformation of pdf')
    default_crop=10
    if defaults is None:
        c = Config('trimpdf', desc)
    else:
        c = StringConfig(defaults, desc)
    c.add_opt('verbose', ['-v', '--verbose'], default=0, action='count',
          help=_('Be verbose, useful for debugging. Can be specified multiple times for greater verbosity.'))
    c.add_opt('output', ['-o', '--output'],default='cropped.pdf',
          help=_('Path to output file. By default a file is created in the current directory.'))
    c.add_opt('bottom_left_x', [ '-x', '--leftx'], default=default_crop,
          help=_('Number of pixels to crop from the left most x (default is %d) ')%default_crop )
    c.add_opt('bottom_left_y', [ '-y', '--lefty'], default=default_crop,
          help=_('Number of pixels to crop from the left most y (default is %d) ')%default_crop )
    c.add_opt('top_right_x', [ '-v', '--rightx'], default=default_crop,
          help=_('Number of pixels to crop from the right most x (default is %d) ')%default_crop )
    c.add_opt('top_right_y', [ '-w', '--righty'], default=default_crop,
          help=_('Number of pixels to crop from the right most y (default is %d)')%default_crop )
    c.add_opt('bounding', ['-b', '--bounding'],
          help=_('A file generated by ghostscript which allows each page to be individually cropped [gs -dSAFER -dNOPAUSE -dBATCH -sDEVICE=bbox > bounding] '))
    return c


def option_parser():
    c = config()
    return c.option_parser(usage=_('''\
	%prog [options] file.pdf

	Crops a pdf. 
	'''))

def main(args=sys.argv):
    parser = option_parser()
    opts, args = parser.parse_args(args)
    try:
        source = os.path.abspath(args[1])
        input_pdf = PdfFileReader(file(source, "rb"))
    except:
        print "Unable to read input"
        return 2
    title   = _('Unknown')
    author  = _('Unknown')
    try:
        info = input_pdf.getDocumentInfo()
        if info.title:
            title   = info.title
        if info.author:
            author  = info.author
    except:
        pass
    if opts.bounding != None:
        try:
            bounding = open( opts.bounding , 'r' )
            bounding_regex= re.compile('%%BoundingBox: (?P<bottom_x>[0-9]+) (?P<bottom_y>[0-9]+) (?P<top_x>[0-9]+) (?P<top_y>[0-9]+)')
        except:
            print 'Error opening %s' % opts.bounding 
            return 1
    output_pdf = PdfFileWriter(title=title,author=author)
    for page_number in range (0, input_pdf.getNumPages() ):
        page = input_pdf.getPage(page_number)
        if opts.bounding != None:
            while True:
                line=bounding.readline()
                match=bounding_regex.search(line)
                if match !=None:
                    break
            page.mediaBox.upperRight = (match.group('top_x'),match.group('top_y'))
            page.mediaBox.lowerLeft  = (match.group('bottom_x'),match.group('bottom_y'))
        else:
            page.mediaBox.upperRight = (page.bleedBox.getUpperRight_x()-opts.top_right_x,page.bleedBox.getUpperRight_y()-opts.top_right_y)
            page.mediaBox.lowerLeft  = (page.bleedBox.getLowerLeft_x()+opts.bottom_left_x,page.bleedBox.getLowerLeft_y()+opts.bottom_left_y)
        output_pdf.addPage(page)
    if opts.bounding != None:
        bounding.close()
    output_file = file(opts.output, "wb")
    output_pdf.write(output_file)
    output_file.close()


    return 0

if __name__ == '__main__':
    sys.exit(main())
