#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
www.latribuna.hn
'''

from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import Tag

class LaTribuna(BasicNewsRecipe):
    title                 = 'La Tribuna - Honduras'
    __author__            = 'Darko Miletic'
    description           = 'Noticias de Honduras y mundo'
    publisher             = 'La Tribuna'
    category              = 'news, politics, Honduras'
    oldest_article        = 2
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets        = True
    remove_javascript     = True
    encoding              = 'utf-8'
    language = 'es'

    lang                  = 'es-HN'
    direction             = 'ltr'

    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]

    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"\npretty_print=True\noverride_css=" p {text-indent: 0cm; margin-top: 0em; margin-bottom: 0.5em} "'

    remove_tags = [dict(name=['form','object','embed'])]

    keep_only_tags = [
                        dict(name='p', attrs={'id':['BlogTitle','BlogDate']})
                       ,dict(name='div', attrs={'id':'BlogContent'})
                     ]

    feeds = [(u'Noticias', u'http://www.latribuna.hn/web2.0/?feed=rss')]

    def print_version(self, url):
        return url + '&print=1'

    def preprocess_html(self, soup):
        soup.html['lang'] = self.lang
        soup.html['dir' ] = self.direction
        mlang = Tag(soup,'meta',[("http-equiv","Content-Language"),("content",self.lang)])
        mcharset = Tag(soup,'meta',[("http-equiv","Content-Type"),("content","text/html; charset=utf-8")])
        soup.head.insert(0,mlang)
        soup.head.insert(1,mcharset)
        for item in soup.findAll(style=True):
            del item['style']
        return soup

    def get_cover_url(self):
        cover_url = None
        soup = self.index_to_soup('http://www.latribuna.hn/web2.0/')
        cover_item = soup.find('div',attrs={'class':'portada_impresa'})
        if cover_item:
           cover_url = cover_item.a.img['src']
        return cover_url
