#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import with_statement

__license__   = 'GPL v3'
__copyright__ = '2009, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'


from calibre.web.feeds.news import BasicNewsRecipe

class PHDComics(BasicNewsRecipe):
    title          = u'PHD Comics'
    oldest_article = 14
    max_articles_per_feed = 100
    language = 'en'

    __author__ = 'Rafardeon'

    feeds          = [(u'PHD Comics', u'http://www.phdcomics.com/gradfeed.php')]

    def print_version(self, url):
        return url.replace('http://www.phdcomics.com/comics.php?f=', 'http://www.phdcomics.com/comics/archive_print.php?comicid=')
