#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
blog.stackoverflow.com
'''

from calibre.web.feeds.news import BasicNewsRecipe

class StackOverflowBlog(BasicNewsRecipe):
    title                 = 'Stack Overflow - Blog'
    __author__            = 'Darko Miletic'
    description           = 'a programming community exploit'
    category              = 'blog, programming'
    publisher             = 'StackOverflow team'
    oldest_article        = 30
    language = 'en'

    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = True
    encoding              = 'utf-8'

    html2lrf_options = [
                          '--comment'  , description
                        , '--category' , category
                        , '--publisher', publisher
                        ]

    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"'

    feeds = [(u'Articles', u'http://blog.stackoverflow.com/feed/' )]

