/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: CSV.pmod,v 1.9 2004/01/13 11:01:38 vida Exp $
 */

//! file: CSV.pmod
//!   CSV (M$ Outlook export format, Excel, etc...) address book handler for Camas
//! cvs_version: $Id: CSV.pmod,v 1.9 2004/01/13 11:01:38 vida Exp $

//! method: string imp(array(string) abook)
//!  Return the address book from ldif format handler
//! returns:
//!  String with : "name:address\nname:addres".
string imp(array(string) abook)
{
  string ab="";
  string name="", address="";

  foreach(abook, string foo)
  {
    if(sscanf(foo,"%s;%s;%*s",name,address)>=2)
    {
      // This is an entry, check if this is an email
      if(search(address,"@")>=1)
      {
        // there is at least one caracter before @ so we can
        // afford this address as a valid email address...
        if (sizeof (ab) > 0)
          ab += "\n"+name+":"+address;
        else
          ab = name+":"+address;
      }
    }
  }
  return ab;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

