.\"
.\" Copyright(c) 1997, 1998 by Jun-ichiro Itoh. All rights reserved.
.\" Freely redistributable unless otherwise noted.  Absolutely no warranty.
.\"
.\" author contact: Jun-ichiro itojun Itoh <itojun@mt.cs.keio.ac.jp>
.\" $Id: camediaplay.man,v 1.6 2001/02/11 01:00:34 itojun Exp $
.\"
.Dd January 1998
.Dt CAMEDIAPLAY 1
.Os
.Sh NAME
.Nm camediaplay
.Nd download/control tool for digital cameras with Sanyo firmware
.Sh SYNOPSIS
.Nm camediaplay
.Op Fl duvD
.Op Fl b Ar baudrate
.Ar port
.Nm camediaplay
.Op Fl aduvD
.Op Fl b Ar baudrate
.Op Fl s Ar startpict
.Op Fl e Ar endpict
.Op Fl n Ar pict
.Fl o
.Ar port
.Nm camediaplay
.Op Fl adituvD
.Op Fl b Ar baudrate
.Op Fl s Ar startpict
.Op Fl e Ar endpict
.Op Fl n Ar pict
.Fl g
.Ar port
.Nm camediaplay
.Op Fl duvD
.Op Fl b Ar baudrate
.Fl # Ar serialno
.Ar port
.Nm camediaplay
.Op Fl duvD
.Op Fl b Ar baudrate
.Fl I Ar idstring
.Ar port
.Nm camediaplay
.Op Fl duvD
.Op Fl b Ar baudrate
.Fl S
.Ar port
.Nm camediaplay
.Op Fl duvD
.Op Fl b Ar baudrate
.Fl P
.Ar port
.Sh DESCRIPTION
.Nm camediaplay
is an downloading/controlling tool for digital cameras with Sanyo firmware.
Camera with Sanyo firmware includes all Olympus products, Epson products,
Agfa products, and of course, Sanyo digital cameras.
.Pp
.Nm camediaplay
has several modes of opertation.
Options to specify the operation mode are
.Fl og#ISP .
If two or more modes are specified, the rightmost one will be active.
.Bl -tag -width indent
.It no mode option specified
Queries the number of pictures in the camera.
.It Fl o
Downloads single picture, and generates output to standard output.
As you imagine, the mode will not work if multiple pictures are specified
for download.
.It Fl g
Downloads multiple pictures, and generates output to files.
.It Fl #
Updates the EEPROM data in the camera for serial number.
.It Fl I
Updates the EEPROM data in the camera for camera personal id.
.It Fl S
Dumps the status of the camera.
.It Fl P
Takes a picture.
.El
.Pp
The following options are available, however, some of them are meaningful
only in some specific mode.
If the option is not supported in the current mode, the option will be ignored.
.Bl -tag -width indent
.It Fl a
Download all the pictures on the camera.
The flag overrides other flags to specify picture number
.Pq Fl sen .
.It Fl d
Enable data dump mode
(basically for debugging).
The data transmitted between the program and the camera will be shown.
Transactions longer than 30 bytes will be truncated to fit the dump list
into 80 columns.
.It Fl i
Do not overwrite existing files.
.It Fl t
Download thumbnails instead of full sized pictures.
.It Fl u
Do not perform uucp locking.
Only gulus are allowed to use this option.
.It Fl v
Be verbose.
.It Fl D
Enable debugging mode.
.It Fl b Ar baudrate
Specify baudrate to use.
Default baudrate is 19200. (yes, we are conservative by default)
It is believed that up to 115200bps can be used.
.It Fl s Ar startpict
.It Fl e Ar endpict
Specifies the range of picture # to be downloaded.
The flag overrides other flags to specify picture number
.Pq Fl an .
.It Fl n Ar pict
Downloads a single picture, specified by
.Ar pict .
The flag overrides other flags to specify picture number
.Pq Fl ase .
.It Ar port
Serial port device to be used.
.El
.Sh EXAMPLES
.Dl camediaplay /dev/tty00
shows the number of picts.
As seen in
.Dl camediaplay tty00
the directory name for device files can be omitted.
.Pp
.Dl camediaplay -n10 -o tty00 > foo.jpg
downloads full-sized picture #10 to foo.jpg through stdout.
.Dl camediaplay -n10 -t -o tty00 > foo.jpg
downloads thumbnail picture #10 to foo.jpg through stdout.
.Pp
.Dl camediaplay -a -g tty00
downloads all full-sized pictures into "pic00001.jpg", "pic00002.jpg"
and so forth.
.Pp
.Dl camediaplay -s2 -e4 -g tty00
downloads full-sized pictures from #2 to #4 into "pic00001.jpg",
"pic00002.jpg" and so forth.
.Dl camediaplay -s2 -e4 -Npict%02d.jpg -g tty00
downloads full-sized pictures from #2 to #4 into "pict01.jpg",
"pict02.jpg" and so forth.
.Sh SUPPORTED CAMERAS
Most of the cameras from Sanyo, Epson, Agfa, and Olympus are believed
to be supported.
.\"The current version lacks support for recent megapixel models.
Successful/failure reports will always be welcomed.
.Sh AUTHOR CONTACT
Jun-ichiro Itoh <itojun@itojun.org>
