(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Misc functions. *)


let remove_blanks str =
  let len = String.length str in
  let buf = Buffer.create len in
  for i = 0 to len - 1 do
    match str.[i] with
      '\000' | ' ' | '\t' | '\r' | '\n' -> ()
    | c -> Buffer.add_char buf c
  done;
  Buffer.contents buf

let remove_newlines str =
  let len = String.length str in
  let buf = Buffer.create len in
  for i = 0 to len - 1 do
    match str.[i] with
      '\r' | '\n' -> ()
    | c -> Buffer.add_char buf c
  done;
  Buffer.contents buf

let buf_get_line buf =
  let s = Buffer.contents buf in
  try
    let n = String.index s '\n' in
    let s1 = String.sub s 0 n in
    let s2 = String.sub s n ((String.length s) - n) in
    Buffer.clear buf;
    Buffer.add_string buf s2;
    match s1 with
      "" -> raise End_of_file
    | _ -> s1
  with
    Not_found ->
      Buffer.clear buf;
      s

let buf_input buf str pos len =
  let s = Buffer.contents buf in
  Buffer.clear buf;
  let s1 = 
    try String.sub s 0 len
    with _ -> raise End_of_file
  in
  let s2 = String.sub s len ((String.length s) - len) in
  Buffer.add_string buf s2;
  for i = 0 to len - 1 do
    str.[pos+i] <- s1.[i]
  done

(** Return a color for a given name. *)
let color_of_name name =
  let accs = [| ref 0 ; ref 0 ; ref 0 |] in
  for i = 0 to (String.length name) - 1 do
    let m = i mod 3 in
    accs.(m) := !(accs.(m)) + Char.code name.[i]
  done;
  let r = !(accs.(0)) mod 210 in
  let g = !(accs.(1)) mod 210 in
  let b = !(accs.(2)) mod 210 in
  let s = Printf.sprintf "#%02X%02X%02X" r g b in
  `NAME s
