
(** Buttons components *)

open Zog_types

module P = Zog_props

class button kind () =
  let w = GButton.button () in
  object(self)
    inherit Zog_types.component
    inherit Zog_types.add_by_add w

    method kind = kind

    method apply _ = ()

    method preview = ()
    method destroy = w#destroy ()

    method gen_code _ = ()
    method as_widget = (w :> GObj.widget)

    initializer
      props <- [ new P.width ; new P.height ]
  end

class button_factory =
  object(self)
    method create = new button self#kind
    method kind = "button"
    method pixmap = Zog_icons.create_pixmap Zog_icons.button
  end

let _ = Zog_register.register_factory (new button_factory)
