
type prop_kind = 
  Int of int option * int option (* lower bound, upper bound *)
| Shadow_type 
| Custom of string (** ml type *)

type pack_method = 
    Pack | Add | Add1_Add2 | Add_with_viewport | Insert_page 
  | No_pack | Set_submenu

class virtual property =
  object
    val mutable current = ""
    method virtual name : string
    method virtual kind : prop_kind
    method current = current  (* current value as a string *)
    method set_current s = current <- s
  end

class virtual component =
  object(self)
    val mutable preview_mode = false
    method preview_mode = preview_mode
    method set_preview_mode b = 
      let old = preview_mode in
      preview_mode <- b;
      if (not old) && preview_mode then
	self#preview
      else
	if old && not preview_mode then
	  self#destroy

    val mutable expanded = false
    method expanded = expanded
    method set_expanded b = expanded <- b

    method virtual kind : string

    val mutable name = ""
    method set_name s = name <- s
    method name = name


    val mutable props = ([] : property list)
    method props = props

    (** how to add a component in this one *)
    method virtual pack_method : pack_method

    method virtual apply : property -> unit 
	
    method virtual add : component -> unit
    method virtual remove : component -> unit
	
    (** [set_property_value prop_name prop_value] c
       changes the value of the given property name. *)
    method set_property_value prop v =
      try
	let p = List.find (fun p -> p#name = prop) self#props in
	p#set_current v
      with
	Not_found -> 
	  Printf.eprintf
	    "Unknown property \"%s\" for component \"%s\" (%s)\n"
	    prop self#name self#kind;
	  flush stderr

    val mutable children = ([] : component list)
    method children = children
    method remove_child (c:component) =
      children <- List.filter (fun c2 -> c2 != c) children;
      if preview_mode then self#remove c

    method add_child (c: component) =
      children <- children @ [c];
      if preview_mode then self#add c

    (** Should not be called in preview mode *)
    method set_children l = children <- l

    method virtual preview : unit
    method virtual destroy : unit

    method virtual gen_code : Format.formatter -> unit

    method virtual as_widget : GObj.widget
  end

class virtual component_factory =
  object
    method virtual create : unit -> component
    method virtual kind : string 
    method virtual pixmap : GMisc.pixmap
  end

class virtual add_by_pack 
    (w : <pack: ?from: Gtk.Tags.pack_type ->
      ?expand:bool -> ?fill:bool -> ?padding:int -> GObj.widget -> unit ; 
	remove: GObj.widget -> unit; ..>)
    =
  object(self)
    method pack_method = Pack

    method add (c : component) =
      (* A VOIR : utiliser les proprits expand fill et padding du component *)
      w#pack c#as_widget

    method remove (c : component) =
      w#remove c#as_widget
  end

class virtual add_by_add 
    (w : <add: GObj.widget -> unit ; 
          remove: GObj.widget -> unit; ..>)
    =
  object(self)
    method pack_method = Add

    method add (c : component) =
      w#add c#as_widget

    method remove (c : component) =
      w#remove c#as_widget
  end

(** Information on an entity. *)
type entity = {
    mutable ent_name : string ; (** class name, must be a valid OCaml id *)
    mutable ent_params : string list ; (** parameters *)
    mutable ent_component : component option ; (** top component *)
  } 

(** Information in a zoggy file. *)
type info = {
    mutable info_header : string ; (** header of the generated file *)
    mutable info_entities : entity list ; (** entities *)
  } 
    
