(*********************************************************************************)
(*                Cameleon                                                       *)
(*                                                                               *)
(*    Copyright (C) 2004-2008 Institut National de Recherche en Informatique     *)
(*    et en Automatique. All rights reserved.                                    *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU Library General Public License as            *)
(*    published by the Free Software Foundation; either version 2 of the         *)
(*    License, or any later version.                                             *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Library General Public License for more details.                       *)
(*                                                                               *)
(*    You should have received a copy of the GNU Library General Public          *)
(*    License along with this program; if not, write to the Free Software        *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

(** Example of Okey usage *)

(** compile with:
{[ ocamlc -o example.x -I +lablgtk2 lablgtk.cma okey.cmo example.ml ]}
*)

let _ = GMain.Main.init ()
let w = GWindow.window ~title: "Okey example" ~width: 400 ~height: 300 ()
let vbox = GPack.vbox ~packing: w#add ()

let v = GText.view ~packing: (vbox#pack ~expand: true ~fill: true ~padding: 2) ()
let wl_state = GMisc.label ~text: ""
    ~packing: (vbox#pack ~fill: true ~padding: 2) ()

let string_of_modifiers = function
    [] -> ""
  | l ->
      let rec iter m s =
        match m with
          [] -> s
        | c :: m ->
            iter m ((
                    match c with
                      `CONTROL -> "C"
                    | `SHIFT -> "S"
                    | `LOCK -> "L"
                    | `MOD1 -> "A"
                    | `MOD2 -> "2"
                    | `MOD3 -> "3"
                    | `MOD4 -> "4"
                    | `MOD5 -> "5"
                    | _  -> raise Not_found
                   ) ^ s)
      in
      iter l "-"


open GdkKeysyms

let string_of_key = function
    x  when x = _Home -> "Home"
  | x -> String.make 1 (Char.chr x)

let string_of_mod_key (m,k) =
  Printf.sprintf "%s%s" (string_of_modifiers m) (string_of_key k)

let string_of_state l =
  String.concat " " (List.map string_of_mod_key l)
let f_display_state ~after_handler l = wl_state#set_text (string_of_state l)



let rec set_buffer_text () =
  let s = Printf.sprintf
      "hello, try some of these key combos:\n%s"
      (String.concat "\n"
         (List.map (fun (l,mes,_) -> Printf.sprintf "%s -> %s" (string_of_state l) mes) combos))
  in
  v#buffer#set_text s

and combos =
  [
    [ [`CONTROL], _q], "quit", GMain.Main.quit ;
    [ [`CONTROL], _x ; [`CONTROL], _m ], "display a message box", (fun () -> GToolbox.message_box "Message" "Hello!") ;
    [ [`CONTROL], _x ; [`CONTROL], _h ], "display a help box", (fun () -> GToolbox.message_box "Message" "Aide toi le ciel t'aidera.") ;
    [ [`CONTROL], _x ; [`CONTROL], _x; [], _r ], "reset the buffer text", set_buffer_text;
    [ [], _Home ], "Display another message box",  (fun () -> GToolbox.message_box "Message" "E.T. telephone maison!") ;
  ]

let _ = set_buffer_text ()

let trees = Okey.trees_of_list (List.map (fun (a,_,b) -> (a,b)) combos)

let _ = Okey.set_handler_trees
    (fun () -> trees)
    ~f_display_state
    v

let () = ignore(w#connect#destroy GMain.Main.quit)
let _ = w#show ()
let _ = GMain.Main.main ()
