/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef MORPHOLOGICALOPERATORS_H
#define MORPHOLOGICALOPERATORS_H

#include <QObject>
#include <Action.h>
#include <ImageComponent.h>
#include <ActionWidget.h>

#include <itkImage.h>

using namespace camitk;

class MorphologicalOperators : public Action {
    Q_OBJECT

    /// Enumerations
    Q_ENUMS( MorphoType )
    Q_ENUMS( MorphoOperation )

    Q_PROPERTY( MorphoType      typeOfOperation READ getTypeOfOperation WRITE setTypeOfOperation)
    Q_PROPERTY( MorphoOperation operation       READ getOperation       WRITE setOperation)


public:
    /// Define the possible types of morphological operatiosn
    enum MorphoType {Grey_Level, Binary };

    /// Define the possible morphological operations
    enum MorphoOperation {Erosion, Dilation, Opening, Closing };

    /// Default Constructor
    MorphologicalOperators(ActionExtension * extension);

    // Setters and Getters for parameters
    MorphoType getTypeOfOperation() const ;
    void setTypeOfOperation(const MorphoType typeOfOperation);

    MorphoOperation getOperation() const ;
    void setOperation(const MorphoOperation operation);

    /// Default Destructor
    virtual ~MorphologicalOperators();

public slots:
    /** this method is automatically called when the action is triggered.
      * Use getTargets() QList to get the list of component to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of ImageComponent (or a subclass).
      */
    virtual ApplyStatus apply();


private:
    /// helper method to simplify the target component processing
    virtual void process(ImageComponent * comp);

private:
    vtkSmartPointer<vtkImageData> implementProcess(vtkSmartPointer<vtkImageData> img);

    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> itkProcess(vtkSmartPointer<vtkImageData> img);

    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> binaryErosionFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> binaryDilationFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> binaryOpeningFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> binaryClosureFilter(vtkSmartPointer<vtkImageData> img);

    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> greyLevelErosionFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> greyLevelDilationFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> greyLevelOpeningFilter(vtkSmartPointer<vtkImageData> img);
    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> greyLevelClosureFilter(vtkSmartPointer<vtkImageData> img);



protected:
    /// Morphological operators properties
    MorphoType typeOfOperation;
    MorphoOperation operation;
    int structuringElementSize;

    QString suffix;

};
#endif // MORPHOLOGICALOPERATORS_H
