/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef COMMANDLINEPARSER_H
#define COMMANDLINEPARSER_H

#include <QString>

//- STL
#include <vector>
#include <map>
#include <string>

/** Easy management of command line.
 *  By default --help displays the usage and --version displays the version.
 */
class CommandLineParser {
public:
  /// default constructor 
  CommandLineParser(int argc, char *argv[]);
  
  /// destructor
  virtual ~CommandLineParser() {};
  
  /// set help string
  void setDescription(std::string description);

  /// parse command line and exit if application was call with help or version arguments or if an parsing error occurs
  void parse();
  
  /// print help (but do not exit the application)
  void help();
  
  /// print version (but do not exit the application)
  void version();

  /// add an option (use --optionName on the command line to activate it)
  void addOption(std::string optionName, std::string description);
  
  /// check for option
  bool option(std::string);
  
  /// get the remaining parameters (useful to open files by giving their names on the command line)
  std::vector<std::string> & getRemainingArguments();
  
private:
  /// application name
  std::string name;
  
  /// the usage/help message 
  std::string description;
  
  /// argv given from command line
  std::vector<std::string> arguments;
  
  /// list of all options+description
  std::map<std::string, std::string> options;
  
  /// position of remaining parameters (arguments)
  std::vector<std::string> remainingArguments;

};

#endif /* COMMANDLINEPARSER_H */
