# This module is defining build variables

# Set the installation directory, i.e where "make install" puts everything
# you can set the CAMITK_INSTALL_ROOT environment variable, set the cmake variable directly by
# adding  -DCAMITK_INSTALL_ROOT:PATH=your-path-here to the cmake command
# or you can set CAMITK_INSTALL_ROOT by hand when running cmake (it is in the cache)
#
# If nothing is specified (or CAMITK_INSTALL_ROOT is blank), the default behaviour is to 
# install everything in the directory on top of the source directory
set(CAMITK_INSTALL_ROOT_TEST "$ENV{CAMITK_INSTALL_ROOT}")
if (NOT CAMITK_INSTALL_ROOT_TEST)
  set(CAMITK_INSTALL_ROOT_TEST ${CAMITK_INSTALL_ROOT})
  if (NOT CAMITK_INSTALL_ROOT_TEST)
     if (CAMITK_SOURCE_DIR)
        set(CAMITK_INSTALL_ROOT ${CAMITK_SOURCE_DIR}/.. CACHE PATH "CamiTK installation root dir" FORCE)
#      else()
#         set(CAMITK_INSTALL_ROOT ${CMAKE_CURRENT_SOURCE_DIR}/.. CACHE PATH "CamiTK installation root dir" FORCE)
    endif()
  endif()

  set (CMAKE_INSTALL_PREFIX ${CAMITK_INSTALL_ROOT} CACHE PATH "CamiTK installation root dir" FORCE)
else()    
  set (CMAKE_INSTALL_PREFIX $ENV{CAMITK_INSTALL_ROOT}  CACHE PATH "CamiTK installation root dir" FORCE)
endif()

message(STATUS "CamiTK Installation Directory: ${CMAKE_INSTALL_PREFIX}")

# during compilation, set where everything (lib, exe, shared) goes
set (CAMITK_BUILD_DIR   ${CMAKE_BINARY_DIR})
set (CAMITK_BIN_DIR     ${CAMITK_BUILD_DIR}/bin      CACHE PATH "CamiTK bin dir." FORCE)
set (CAMITK_LIB_DIR     ${CAMITK_BUILD_DIR}/lib      CACHE PATH "CamiTK lib dir." FORCE)
set (CAMITK_INCLUDE_DIR ${CAMITK_BUILD_DIR}/include  CACHE PATH "CamiTK include dir." FORCE)
set (CAMITK_TESTDATA_DIR ${CAMITK_BUILD_DIR}/share/testdata    CACHE PATH "CamiTK share dir. for test data" FORCE)
# the "normal" user does not need to see this
mark_as_advanced(CAMITK_BIN_DIR CAMITK_LIB_DIR CAMITK_INCLUDE_DIR CAMITK_TESTDATA_DIR)

# Setup output directories
set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${CAMITK_BIN_DIR} CACHE PATH "Single directory for all runtimes." FORCE)
set(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${CAMITK_BIN_DIR} CACHE PATH "Single directory for all dynamic/shared libs." FORCE)
set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${CAMITK_LIB_DIR} CACHE PATH "Single directory for all archives." FORCE)

# no need to see this
mark_as_advanced ( CMAKE_RUNTIME_OUTPUT_DIRECTORY CMAKE_LIBRARY_OUTPUT_DIRECTORY CMAKE_ARCHIVE_OUTPUT_DIRECTORY)
