# - Try to find CamiTK
# This module can be used to find CamiTK.
# CamiTK can be either installed (CAMITK_IS_INSTALLED will be set to true) or
# not installed. In the latter this module will use the build directory
#
# Prior to calling find(CamiTK), you can set which version you like to use
#     set(CAMITK_VER_MAJ "2")
#     set(CAMITK_VER_MIN "1")
#
# Once this module has run, the following variables will be properly defined
#  CAMITK_FOUND - system has CamiTK
#  CAMITK_INSTALL_ROOT - root installation for CamiTK
#  CAMITK_INCLUDE_DIRECTORIES - the CamiTK include directories
#  CAMITK_LIBRARIES - link these to use CamiTK
#  ... 
#  and all the other goodies
#
# Once found it is then easy to just use the CamiTK macros
# to build your extensions

# we need at least version 3.0
if(NOT CAMITK_VER_MAJ)
    set(CAMITK_VER_MAJ "3")
    set(CAMITK_VER_MIN "0")
endif()

# CamiTK short version name we are looking for
set(CAMITK_SHORT_VERSION_STRING "camitk-${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}")

# first check if we can use the build version directly
find_path(CAMITK_ROOT_DIR_GUESS
          NAMES CamiTKAPI.h
          PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../camitk/core
)
set(CAMITK_ROOT_DIR_GUESS_TESTED TRUE CACHE BOOL "Is variable ${CAMITK_ROOT_DIR_GUESS} already tested?")

if (CAMITK_ROOT_DIR_GUESS AND NOT CAMITK_ROOT_DIR_GUESS_TESTED)
    set(CAMITK_IS_INSTALLED FALSE)
    # if this directory was checkouted inside camitk-timc, CAMITK_INSTALL_ROOT could be already defined by CMake when camitk-timc/camitk was parsed/configured
    # in this case, DO NOT reset CAMITK_INSTALL_ROOT
    if (NOT CAMITK_INSTALL_ROOT)
      set(CAMITK_INSTALL_ROOT ${CMAKE_CURRENT_SOURCE_DIR}/..) # default install dir
    endif()
    # camitk is not installed yet, use build dir for include and libs
    set(CAMITK_BUILD_ROOT ${CMAKE_CURRENT_BINARY_DIR}/..) 
else()
    set(CAMITK_IS_INSTALLED TRUE)
endif()

if (NOT CAMITK_INSTALL_ROOT)
    # name of the camitk core lib (as defined in CamiTKVariables)
    set(CAMITK_CORE_LIB_TEMP "camitkcore")

    # directory structure from install dir to look for CamiTKAPI.h
    set(CAMITK_INCLUDE_DIR_SUFFIX_TEMP "include/${CAMITK_SHORT_VERSION_STRING}/${CAMITK_CORE_LIB_TEMP}")

    # find the caracteristic header using a (reasonably) long good list for the guess
    find_path(CAMITK_ROOT_DIR_GUESS
              NAMES CamiTKAPI.h
              PATHS "/usr"
                    "/usr/local"
                    "C:/Programs"
                    "C:/Programs/camitk"
                    "C:/Dev"
                    "C:/Dev/camitk"
                    "/home/promayon/Atelier/Dev/CamiTK-install-dir"
                    $ENV{CAMITK_DIR}
                    "${CMAKE_CURRENT_SOURCE_DIR}/.."
                    "${CMAKE_CURRENT_SOURCE_DIR}/../camitk"
                    "${CMAKE_CURRENT_SOURCE_DIR}/../camitktimc"
                    "${CMAKE_CURRENT_SOURCE_DIR}/../camitk-timc"
              PATH_SUFFIXES "${CAMITK_INCLUDE_DIR_SUFFIX_TEMP}"
    )

    mark_as_advanced(CAMITK_ROOT_DIR_GUESS)

    set(CAMITK_VERSION "${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}" CACHE STRING "The CamiTK version to find")

    # if guess is alright
    if (CAMITK_ROOT_DIR_GUESS) 
      string(REGEX REPLACE "${CAMITK_INCLUDE_DIR_SUFFIX_TEMP}" "" CAMITK_INSTALL_ROOT_TEMP ${CAMITK_ROOT_DIR_GUESS})
      set(CAMITK_INSTALL_ROOT ${CAMITK_INSTALL_ROOT_TEMP} CACHE PATH "${CAMITK_SHORT_VERSION_STRING} install root" FORCE)
    else()
      set(CAMITK_INSTALL_ROOT "" CACHE PATH "${CAMITK_SHORT_VERSION_STRING} install root")
    endif()
endif()

if(NOT ${CAMITK_INSTALL_ROOT} EQUAL "")

  # advertise the success
  message(STATUS "Found ${CAMITK_SHORT_VERSION_STRING}: ${CAMITK_INSTALL_ROOT}")
  set(CAMITK_FOUND TRUE)

  # Check dependencies
  find_package(Qt4 REQUIRED)
  include(${QT_USE_FILE})
  set (QT_USE_QT3SUPPORT OFF)

  # Find VTK
  find_package(VTK REQUIRED)
  include(${VTK_USE_FILE})

  # set CamiTK build variables
  if (CAMITK_IS_INSTALLED)
    set (CAMITK_BIN_DIR     ${CAMITK_INSTALL_ROOT}/bin                                     CACHE PATH "CamiTK bin dir." FORCE)
    set (CAMITK_LIB_DIR     ${CAMITK_INSTALL_ROOT}/lib/${CAMITK_SHORT_VERSION_STRING}      CACHE PATH "CamiTK lib dir." FORCE)
    set (CAMITK_INCLUDE_DIR ${CAMITK_INSTALL_ROOT}/include/${CAMITK_SHORT_VERSION_STRING}  CACHE PATH "CamiTK include dir." FORCE)
    set (CAMITK_TESTDATA_DIR ${CAMITK_INSTALL_ROOT}/share/${CAMITK_SHORT_VERSION_STRING}/testdata    CACHE PATH "CamiTK share dir. for test data" FORCE)
  else()
    # use build directory to get includes and lib
    set (CAMITK_BIN_DIR      ${CAMITK_BUILD_ROOT}/bin            CACHE PATH "CamiTK bin dir." FORCE)
    set (CAMITK_LIB_DIR      ${CAMITK_BUILD_ROOT}/lib            CACHE PATH "CamiTK lib dir." FORCE)
    set (CAMITK_INCLUDE_DIR  ${CAMITK_BUILD_ROOT}/include        CACHE PATH "CamiTK include dir." FORCE)
    set (CAMITK_TESTDATA_DIR ${CAMITK_BUILD_ROOT}/share/testdata CACHE PATH "CamiTK share dir. for test data" FORCE)
  endif()
  mark_as_advanced(CAMITK_BIN_DIR CAMITK_LIB_DIR CAMITK_INCLUDE_DIR CAMITK_TESTDATA_DIR)

  # Needed due to installation reason
  link_directories(${CAMITK_INSTALL_ROOT}/lib)
  
  # update module path
  set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CAMITK_LIB_DIR}/cmake ${CAMITK_INSTALL_ROOT}/camitk/cmake/modules ${CMAKE_CURRENT_SOURCE_DIR}/../camitk/cmake/modules  ${CAMITK_INSTALL_ROOT}/share/${CAMITK_SHORT_VERSION_STRING}/cmake)

  # include useful modules
  include(CamiTKVariables)
  include(CamiTKMacros)

  # set install path
  set (CMAKE_INSTALL_PREFIX ${CAMITK_INSTALL_ROOT} CACHE PATH "Path to install dir (deduced from CAMITK_INSTALL_ROOT)" FORCE)

  # check the following to define the proper output variables for an external extension
  # during compilation, set where everything (lib, exe, shared) goes
  set (EXTENSION_BUILD_DIR    ${CMAKE_BINARY_DIR})
  set (EXTENSION_BIN_DIR      ${EXTENSION_BUILD_DIR}/bin      CACHE PATH "CamiTK extension bin dir."     FORCE)
  set (EXTENSION_LIB_DIR      ${EXTENSION_BUILD_DIR}/lib      CACHE PATH "CamiTK extension lib dir."     FORCE)
  set (EXTENSION_INCLUDE_DIR  ${EXTENSION_BUILD_DIR}/include  CACHE PATH "CamiTK extension include dir." FORCE)
  set (EXTENSION_TESTDATA_DIR  ${EXTENSION_BUILD_DIR}/share/testdata  CACHE PATH "CamiTK share dir. for test data" FORCE)
  # the "normal" user does not need to see this
  mark_as_advanced(EXTENSION_BUILD_DIR EXTENSION_BIN_DIR EXTENSION_LIB_DIR EXTENSION_INCLUDE_DIR EXTENSION_TESTDATA_DIR)

  # Setup CMake Variable
  set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${EXTENSION_BIN_DIR} CACHE PATH "Single directory for all runtimes." FORCE)
  set(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${EXTENSION_BIN_DIR} CACHE PATH "Single directory for all dynamic/shared libs." FORCE)
  set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${EXTENSION_LIB_DIR} CACHE PATH "Single directory for all archives." FORCE)

  # no need to see this
  mark_as_advanced ( CMAKE_RUNTIME_OUTPUT_DIRECTORY CMAKE_LIBRARY_OUTPUT_DIRECTORY CMAKE_ARCHIVE_OUTPUT_DIRECTORY)

else()
  message(FATAL_ERROR "Cannot find CamiTK core, please set the CAMITK_INSTALL_ROOT variable")
endif()


