/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "Colors.h"

#include <InteractiveViewer.h>
#include <AtomDC.h>
#include <PMManagerDC.h>

#include "MMLMonitorDisplayFactory.h"

bool colorsRegistered=MMLMonitorDisplayFactory::getInstance()->registerClass<Colors>("Colors",Monitor::SCALARSET);

Colors::Colors(Monitor* monitor,MMLComponent* manager): MMLMonitorDisplay(monitor,manager) {

}


Colors::~Colors() {

}

// ---------------------- update ----------------------------
void Colors::update() {
    if (monitor->getNumberOfValues()>0) {
        PMManagerDC* pmMgr=manager->getPMManager();
        pmMgr->createPointData();
        // destroy existing atom data (in case not all atom is given a point data)
        pmMgr->destroyPointData();

        // calculate min and max of monitor data
        double min=monitor->getValue(0);
        double max=min;

        for (unsigned int i=1; i<monitor->getNumberOfIndex(); i++) {
            double d=monitor->getValue(i);

            if (d<min)
                min=d;

            if(d>max)
                max=d;
        }

        // -- update value
        double val;
        double range = max - min;

        AtomDC* adc;

        // in case some nodes are not displayed set all values to 0 (blue color for everyone)
        StructuralComponent* sc=pmMgr->getPhysicalModel()->getAtoms();

        for ( unsigned int i = 0; i<sc->getNumberOfStructures() ; i++ ) {
            adc = pmMgr->getDC ((Atom*)(sc->getStructure(i)));
            adc -> updatePointData (1.0);
        }

        // update values for each atom
        for ( unsigned int i = 0; i <monitor->getNumberOfIndex(); i++ ) {
            val =monitor->getValue(i);

            // scaling [0..1]
            if ( fabs ( range ) < 1e-10 || val <= min ) {
                val = 0.0;
            }
            else {
                if ( val >= max ) {
                    val = 1.0;
                }
                else {
                    // renormalized the size between min and max
                    val = ( ( val - min ) / range );
                }
            }

            adc = pmMgr->getDC (pmMgr->getPhysicalModel()->getAtom(monitor->getIndexOfValues(i)));
            adc -> updatePointData (1.0-val);
            // add or update custom properties of atom //TODO move into MMLdisplay and make a for loop on all monitors
            //pmMgr->getPhysicalModel()->getAtom(monitor->getIndex(i))->getProperties()->set(monitor->getTypeName(),monitor->getValue(i));
            //adc->refresh();
        }

        //-- show the color scale in 3D
        InteractiveViewer::get3DViewer()->setColorScaleTitle(monitor->getTypeName().c_str());
        InteractiveViewer::get3DViewer()->setColorScaleMinMax(min, max);

    }
}

// ---------------------- hide ----------------------------
void Colors::hide() {
    manager->getPMManager()->destroyPointData();
    InteractiveViewer::get3DViewer()->setColorScale(false);
}


