/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef VTK_IMAGE_COMPONENT_H
#define VTK_IMAGE_COMPONENT_H

#include <vtkImageData.h>
#include <ImageComponent.h>


#include "VtkImageComponentAPI.h"
#include <QMetaProperty>

using namespace camitk;

/**This class manage vtk images, i.e images that can be loaded in CamiTK by using an VTK importer.
 */


class VTK_IMAGE_COMPONENT_API VtkImageComponent : public ImageComponent  {
    Q_OBJECT
public:
    /// default constructor: give it the name of the file containing the data
    VtkImageComponent(const QString&) throw (AbortException);

    /// needed for deleting
    virtual ~VtkImageComponent() {};

    /// actually create the component from the file
    virtual void createComponent(const QString&);
};



#endif // VTK_IMAGE_COMPONENT_H
