/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file convertMml.h
 * @brief Manage Qapp convertMMl
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef CONVERTMML_H
#define CONVERTMML_H

#include <QMainWindow>
#include <qlistwidget.h>


namespace Ui{
class convertMml;  
}
/**
 * Class to run the app to calculate some stats or display plots from mml or csv file
 */
class convertMml : public QMainWindow {
  Q_OBJECT

public:
    /// constructor
    explicit convertMml(QWidget* parent = 0);
    /// destructor
    ~convertMml();

private:
    /// method where all slots are created
    void initSLOT();
  
    /// the parameter for the UI
    Ui::convertMml *ui;
    /// list of QString to keep in mind which monitors are implemented
    static const QStringList monitors;
    /// Statistics implemented 
    static const QStringList statistics;
    /// Plots implemented
    static const QStringList plot;
    
private slots :
  /// allows to add file(s) to study (csv or mml)
  void addFile();
  /// allows to add monitor
  void addMonitor();
  /// allows to delete monitor
  void delMonitor();
  /// allows to add statistics
  void addStats();
  /// allows to delete statistics
  void delStats();
  /// allows to generate a command line of what the user want to calculate
  void generateCommandLines();
  /// allows to generate csv files (One for value, One for statistics) that user has asked
  void generateCsvFile();
  /// allows to give a path where csv file is saved. This csv file contains data from mml with monitor
  void saveMonitorsAs();
  /// allows to give the path where a csv file of statistics is saved
  void saveStatsAs();
  /// allows to snapshot the graph and save it in a gven path
  void savePlot();
  /// delete selected file
  void deleteFile();
  /// manage radio buttons to disable or enable stuff in the app
  void changeListItem(bool);
  /// allows to plot a monitor with a type of monitor.
  void plotMonitor();
  /// displays an HOW TO of the app
  void helpInfo();
};

#endif //CONVERTMML_H