/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file csv2Plot.h
 * @brief class to plot mml data
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef CSV2PLOT_H
#define CSV2PLOT_H

#include <string>
#include <vector>
#include <list>

#include "../../mml2Csv/dataMonitoredList.h"
#include "../csv2Sthing.h"

#include <qcustomplot.h>


using namespace std;
/**
 * @class csv2Plot
 * Class which allows to plot data contained in a csv file and wrote by mml2Csv
 * @see mml2Csv
 */
class csv2Plot : public csv2Sthing{

public:
    /**
     * Constructor
     * @param file path+filename where csv file is
     * @param whichPlot list which contains plot to draw
     * @param results list of @see dataMonitoredList
     */
    csv2Plot(string file, list<string> whichPlot, list<dataMonitoredList> results);
    /**
     * Constructor
     * @param file path+filename where csv file is
     * @param whichPlot list which contains plot to draw
     */
    csv2Plot(string file, list<string> whichPlot);
    
    /// destructor
    virtual ~csv2Plot();

    /**
     * method to call the method allowing to draw a kind of plot.
     * @param data list of data to display
     */
    void drawMeMyPlots();
    
    /**
     * Allows to draw a histogram
     * @param plot the widget where the plot will be displayed
     * @param monitor which monitor will be plotted
     * @return true if success, false otherwise
     */
    bool drawBarChart (QCustomPlot *plot, string monitor);
    
     /**
     * Allows to draw a box chart. 
     * @param plot the widget where the plot will be displayed
     * @param monitor which monitor will be plotted
     * @return true if success, false otherwise
     */
    bool drawBoxChart (QCustomPlot *plot, string monitor);
    
};

#endif // CSV2PLOT_H
