/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file main.cpp
 * @brief Main to plot in command line (./csv2Plot ....)
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#include <iostream>
#include <list>
#include <QApplication>

#include "csv2Plot.h"

using namespace std;

//--main---------------------------------
int main(int argc, char* argv[]) {
    if (argc < 2) {
        cerr << "usage: " << argv[0] << " Please enter a csv file to read" << endl;
	cout << "HOWTO : ./csv2Plot -ARG -ARG2 PATH_OF_CSV :Path_to_save_csv" << endl;
        return 1;
    }
    string cSVFilename="";
    string saveFile="";
    list<string> plotName;
    cout<< endl << "/*****************************************/"<< endl;
    // Take a look at the command line
    for (int i=1; i<argc; i++) {
        string temp = argv[i];
        if (temp.find("-")==0) {
            //It's a stat to calculate
            temp = temp.substr(1);
            plotName.push_back(temp);
            cout << "Which plot : " << temp << endl;
        }
        else if (temp.find(":")==0) {
            temp = temp.substr(1);
            //It's the path to save the new csv file.
            saveFile=temp;
            cout<< endl << "Save as : "<< temp << endl;
        } else {
	    //It's the path where data are stored
            cout <<endl << "File to read : " << temp << endl;
            cSVFilename=temp;
        }
    }
    cout<< "/*****************************************/"<< endl << endl;
    if (plotName.empty()) {
        cout<<"ERROR : The command line is incorrect ! Please introduce some plot criteria"<<endl;
    } else {
        QApplication app(argc, argv);
        csv2Plot *c = new csv2Plot(cSVFilename, plotName);
	c->drawMeMyPlots();
        app.exec();
	//delete in memory
	c->~csv2Plot();
    }
}