/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DICOMMANAGER_H
#define DICOMMANAGER_H

#include <ImageComponent.h>
#include <vtkImageData.h>
#include <vtkSmartPointer.h>
#include <itkGDCMSeriesFileNames.h>

typedef itk::FilenamesContainer FilenamesContainerType;

/** 
 * @ingroup group_cepimaging_components_dicom
 * 
 * @brief
 * This class manage Dicom volume images stored in directories.
 */
class DicomComponent : public camitk::ImageComponent {
    Q_OBJECT
public:
    /// default constructor: give it the name of the file containing the data
    DicomComponent(const QString, FilenamesContainerType, QString) throw (camitk::AbortException);

    virtual void createComponent(const QString, FilenamesContainerType, QString);

protected:
    vtkSmartPointer<vtkImageData> readVolume(const QString filename, FilenamesContainerType filenames);

};



#endif
