/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef STRUCTURALCOMPONENTPROPERTIES_H
#define STRUCTURALCOMPONENTPROPERTIES_H

#include "BasicSCProperties.h"

/**
  * This is an automatically generated class for custom StructuralComponent properties.
  * It was generated by the <tt>customPhysicalProperties</tt> stylesheet from 
  * the following xml document:
  <pre>
  
        
    
  
  </pre>
  * This class inherits BasicSCProperties.
  * Here is all the specific attributes of StructuralComponent properties (custom physical properties).
  *
  */
class StructuralComponentProperties : public BasicSCProperties {
public:
    /** Constructors (do not change) */
    StructuralComponentProperties(PhysicalModel *p) : BasicSCProperties(p)  { init(); };
	StructuralComponentProperties(PhysicalModel *p, xmlNodePtr node) : BasicSCProperties(p, node)  { init(); };
    StructuralComponentProperties(PhysicalModel *p, const std::string n) : BasicSCProperties(p, n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const Color c) : BasicSCProperties(p,c) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const Color c, const std::string n) : BasicSCProperties(p,c,n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double * rgb) : BasicSCProperties(p, rgb) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double * rgb, const std::string n) : BasicSCProperties(p, rgb,n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double r, const double g, const double b) : BasicSCProperties(p, r,g,b) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double r, const double g, const double b, const std::string n) : BasicSCProperties(p,r,g,b,n
) { init(); };
    virtual ~StructuralComponentProperties();     
           
    /** Print the properties in xml */
    void xmlPrint(std::ostream &);

    /** Set and get method for all the properties */
    void setMyCustomProperty1(const int);
    int getMyCustomProperty1() const;
            
    void setMyCustomProperty2(const std::string);
    std::string getMyCustomProperty2() const;
            
    
protected:
                
    virtual void init();
    int myCustomProperty1;
    std::string myCustomProperty2;
    
};                

// inlines
inline void StructuralComponentProperties::setMyCustomProperty1(const int value) { myCustomProperty1 = value; }
inline int StructuralComponentProperties::getMyCustomProperty1() const { return myCustomProperty1; }
inline void StructuralComponentProperties::setMyCustomProperty2(const std::string value) { myCustomProperty2 = value; }
inline std::string StructuralComponentProperties::getMyCustomProperty2() const { return myCustomProperty2; }

#endif

