/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include <Application.h>
#include <MainWindow.h>
#include <InteractiveViewer.h>
#include <Core.h>
#include <ExtensionManager.h>
#include <Action.h>


using namespace camitk;

// CLI stuff
#include "CommandLineOptions.hxx"

// Description:
//This is a test application, it is not intended to be used as a CamiTK application.
//-a <file> action to load (.dll file)
//-i <file> is the file to open - will not be modified

// usage for this application
void usage(char *appName) {
    std::cerr << appName << std::endl;
    std::cerr << std::endl;
    std::cerr << "Usage: " << appName << " [options]" << std::endl;
    std::cerr << "Build using " << Core::version << std::endl;
    std::cerr << std::endl;
    std::cerr << "Options:" << endl;
    options::print_usage(std::cerr);
}

int main(int argc, char *argv[]) {
    try {

        int end; // End of options.
        options o(argc, argv, end);
        int ret = EXIT_SUCCESS;

        // if specific help or no options provided
        if (o.help()) {
            usage(argv[0]);
            return EXIT_SUCCESS;
        }
        else if(o.action() != "") {
            if (o.input() == "") {
                usage(argv[0]);
                return EXIT_SUCCESS;
            }
            else
            {
                std::cout << "Arguments OK: ";
                bool extOpen = false;
                // init the camitk application context
                Application a( "action-test", argc, argv, false, false );// No autoload + registerFileExtension false to avoid the execution of this testapp hampered by PopUp message
                a.getMainWindow()->setCentralViewer( InteractiveViewer::getAxialViewer() );

                ExtensionManager::autoload( ExtensionManager::COMPONENT );

                Component* comp = Application::open( o.input().data() );

                if( comp )
                {
                    QString ActionDir;
                    Action::ApplyStatus status;
                    QStringList extensionDir;

                    std::cout << "Open file OK : ";

                    comp->setSelected( true, true );

                    extensionDir = Core::getActionDirectories();

                    //Load the action extension defined in the entry parameters
                    while( !( extensionDir.empty() || extOpen ) )
                    {
                        if ( ExtensionManager::loadExtension( ExtensionManager::ACTION, extensionDir.front() + '/' + o.action().data() ))
                        {
                            std::cout << "load action extension OK : ";
                            extOpen = true;
                        }
                        extensionDir.pop_front();
                    }
                    if( extOpen )
                    {
                        QStringList componentHierarchy = comp->getHierarchy();

                        ActionList actl = Application::getActions( comp );

                        //For each action of extension do an apply()
                        foreach( Action *action , actl )
                        {
                            QString q = action->getName();
                            std::cout << "action->getName() " <<  action->getName().data();

                            //Check if the action can be applied to this component type
                            if( componentHierarchy.contains( action->getComponent() ) )
                            {
                                std::cout << "componentHierarchy OK : ";
                                action->setInputComponent( comp );

                                status = action->apply();

                                if( status != Action::SUCCESS )
                                {
                                    std::cout << "action apply on " <<  action->getName().data() << " FAILED";
                                    ret = EXIT_FAILURE;
                                }
                                else
                                {
                                    std::cout << "action apply on " <<  action->getName().data() << " SUCCESS";
                                }
                            }
                            else
                            {
                               std::cout << "this action is not compatible with this component type";
                            }
                        }
                    }
                    else
                    {
                        std::cout << "Loading action extension :" <<  o.action() << "FAILED";
                    }
                }
                else
                {
                    std::cout << "Loading file :" <<  o.input() << "FAILED";
                }

                return ret;
            }
        }
        else
        {
            usage(argv[0]);
            return EXIT_SUCCESS;
        }
    }
    catch (camitk::AbortException& e) {
        //QMessageBox::warning(NULL, QString(argv[0]) + " aborted...", "AbortException:" + QString(e.what()));
        std::cout << argv[0] << " aborted..." << std::endl << "camitk AbortException:" << std::endl << e.what() << std::endl;
        return EXIT_FAILURE;
    }
    catch (std::exception& e) {
        //QMessageBox::warning(NULL, QString(argv[0]) + " aborted...", "AbortException:" + QString(e.what()));
        std::cout << argv[0] << " aborted..." << std::endl << "std AbortException:" << std::endl << e.what() << std::endl;
        return EXIT_FAILURE;
    }
    catch (...) {
        //QMessageBox::warning(NULL, QString(argv[0]) + " aborted...", "Unknown Exception");
        std::cout << argv[0] << " aborted..." << std::endl << "Unknown Exception" << std::endl;
        return EXIT_FAILURE;
    }

}
