/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MESH_COMPONENT_EXTENSION_H
#define MESH_COMPONENT_EXTENSION_H


// -- Core image component stuff
#include "CamiTKAPI.h"
#include "MeshComponent.h"

// -- Core stuff
#include "ComponentExtension.h"

// -- QT stuff
#include <QObject>
#include <QMap>


namespace camitk {
/**
 * @ingroup group_sdk_libraries_core_component_mesh
 *
 * @brief
 * Abstract class created to support export file formats for MeshComponent
 * Any data component plugin creating a MeshComponent should inherit from this class.
 *
 */

class CAMITK_API MeshComponentExtension : public ComponentExtension {

public:

    /// get the plugin name
    virtual QString getName() const;

    /// get the plugin description (can be html)
    virtual QString getDescription() const;

    /// get a new instance from data stored in a file (this is the most important method to redefine in your subclass)
    virtual Component * open
    (const QString &) throw (AbortException) = 0;

protected:
    /// Constructor protected because the class is virtual
    MeshComponentExtension();

    /// the destructor
    virtual ~MeshComponentExtension() {};

};

}

#endif // MESH_COMPONENT_EXTENSION_H
