/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "MeshDataModel.h"
#include "MeshComponent.h"

#include <vtkSelection.h>
#include <vtkSelectionNode.h>

namespace camitk {

MeshSelectionModel::MeshSelectionModel ( MeshComponent* const meshComp ) :
    QAbstractTableModel ( meshComp ), meshComponent(meshComp) {
    fieldName[vtkSelectionNode::POINT] = QString ( "Points" );
    fieldName[vtkSelectionNode::CELL] = QString ( "Cells" );

    contentName[vtkSelectionNode::INDICES] = "Indices";
}

int MeshSelectionModel::rowCount ( const QModelIndex& parent ) const {
    if ( !meshComponent )
        return 0;
    return meshComponent->getNumberOfSelections();
}

int MeshSelectionModel::columnCount ( const QModelIndex& parent ) const {
    return 4;
}

QVariant MeshSelectionModel::data ( const QModelIndex& index, int role ) const {
    if ( !meshComponent )
        return QVariant();

    int row = index.row();
    int col = index.column();

    switch ( role ) {
    case Qt::DisplayRole:
        switch ( col ) {
        case 0 :
            return QString ( meshComponent->getSelectionList().keys().at( row ) );
            break;
        case 1 :
            return QString ( fieldName[meshComponent->getSelectionAt ( row )->GetFieldType()] );
            break;
        case 2 :
            return QString ( contentName[meshComponent->getSelectionAt ( row )->GetContentType()] );
            break;
        case 3 :
            if ( meshComponent->getSelectionAt ( row )->GetSelectionList() )
                return QString::number ( meshComponent->getSelectionAt ( row )->GetSelectionList()->GetNumberOfTuples() );
            else
                return QString::number ( 0 );
            break;
        default :
            return QVariant();
            break;
        }
        break;
    default :
        return QVariant();
        break;
    }
    return QVariant();
}

QVariant MeshSelectionModel::headerData ( int section, Qt::Orientation orientation, int role ) const {
    if ( role == Qt::DisplayRole ) {
        if ( orientation == Qt::Horizontal ) {
            switch ( section ) {
            case 0:
                return QString ( "Name" );
                break;
            case 1:
                return QString ( "Type" );
                break;
            case 2:
                return QString ( "Content" );
                break;
            case 3 :
                return QString ( "Count" );
                break;
            default:
                return QVariant();
                break;
            }
        }
    }
    return QVariant();
}

void MeshSelectionModel::updateSelection ( const QString& name ) {
    int index;
    if ((index = meshComponent->getSelectionList().keys().indexOf(name)) > -1) {
        emit dataChanged(this->index(index,0), this->index(index,3));
    }
}

void MeshSelectionModel::refresh() {
    reset();
}

}