(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Image
open OImage
open Info

let _ =
  let files = ref [] in
  Arg.parse [] (fun s -> files := s :: !files) "monochrome src dst";
  let src,dst = 
    match List.rev !files with
    | [src; dst] -> src, dst
    | _ -> raise (Invalid_argument "you need two arguments")
  in
  
  let src = OImage.rgb24 (OImage.load src []) in

  let mono img = 
    (* Make monochrome *)
    for x = 0 to src#width - 1 do
      for y = 0 to src#height - 1 do
	let rgb = src#get x y in
	let mono = Color.brightness rgb in
	src#set x y {r= mono; g= mono; b= mono}
      done
    done
  in
  
  let saver img = img#save dst None [] in
  
  mono src;
  saver src
;;  
