(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Image
open OImage
open Info

let file = ref ""
let scale = ref 1.0

let _ =
  Arg.parse [
    "-scale", Arg.Float (fun sc -> scale := sc), "scale";
]  (fun s -> file := s)
   "resize -scale ? file"

let file = !file
let scale = !scale
let outfile = "out"^file

let _ = 
  Bitmap.maximum_live := 15000000; (* 60MB *)
  Bitmap.maximum_block_size := !Bitmap.maximum_live / 16;
  let r = Gc.get () in
  r.Gc.max_overhead <- 30;
  Gc.set r
;;

let _ =
  let fmt,_ = Image.file_format file in
  let img = OImage.load file [] in

  let img = OImage.rgb24 img in

  let nw = truncate (float img#width *. scale)
  and nh = truncate (float img#height *. scale)
  in
  let newimage = img#resize None nw nh in
  img#destroy;
  newimage#save outfile (Some fmt) [Save_Quality 95] 
;;
