(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Franois Pessaux, projet Cristal, INRIA Rocquencourt     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

val load : string -> Image.load_option list -> Image.t;;
  (* Loads a jpeg image. *)
val load_thumbnail : string -> Image.load_option list -> Geometry.spec -> 
  int * int * Image.t;;

val save : string -> Image.save_option list -> Image.t -> unit;;
  (* Save a full-color image in jpeg format file.
     Raises [Invalid_argument] if the image is not a full-color image. *)

val save_as_cmyk : string -> Image.save_option list -> 
  (Image.rgb -> int * int * int * int) -> Image.t -> unit;;
  (* This converts RGB images to CMYK, but the color conversion is not
     something fancy. *)

val save_cmyk_sample : string -> Image.save_option list -> unit;;
  (* Create CMYK jpeg image sample. Just for developpers. *)

(* Scanline based I/O functions *)
type in_handle
val open_in : string -> int * int * in_handle
val open_in_thumbnail : string -> Geometry.spec -> int * int * (int * int * in_handle)
val read_scanline : in_handle -> string -> unit
val close_in : in_handle -> unit
  
type out_handle
val open_out : string -> int -> int -> int -> out_handle
val write_scanline : out_handle -> string -> unit
val close_out : out_handle -> unit

val check_header : string -> Image.header;;
  (* Checks the file header *)
