open Rtypes
open Xdr
open Rpc
open Procdef

let serverhost = "localhost";;
  (* where the server runs *)


let port =
  lazy (Rpc_portmapper.port_of_program program serverhost Tcp)
;;


let call name v =
  let c =
    Rpc_simple_client.create 
      (Rpc_client.Inet (serverhost, Lazy.force port))
      Tcp
      program 
  in
  let result = Rpc_simple_client.call c name v in
  Rpc_simple_client.shut_down c;
  result
;;


let plus1 = call "plus1";;
let sortarray = call "sortarray";;
let sortlist = call "sortlist";;

