(* $Id: rpc_over_http_cgiforwarder.ml 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)

open Rpc

let env s = try Sys.getenv s with Not_found -> "";;
let intenv s = try int_of_string(env s)
               with _ -> failwith ("Cannot parse environment variable " ^ s)
;;


let forward_to_port proto host port =
  let addr =
    try
      Unix.inet_addr_of_string host
    with
        Failure s ->
          try
            let h = Unix.gethostbyname host in
            h.Unix.h_addr_list.(0)
          with
              Not_found ->
                failwith ("Rpc_over_http_cgiforwarder.forward: unknown host " ^ host)
  in
  let in_length = intenv "CONTENT_LENGTH" in
  let s = String.create in_length in
  really_input stdin s 0 in_length;
  let trans =
    match proto with
	Tcp ->
	  let d = Unix.socket Unix.PF_INET Unix.SOCK_STREAM 0 in
	  Unix.connect d (Unix.ADDR_INET(addr,port));
	  Rpc_transport.create d Tcp Socket
      | Udp ->
	  let d = Unix.socket Unix.PF_INET Unix.SOCK_DGRAM 0 in
	  let t = Rpc_transport.create d Udp Socket in
	  Rpc_transport.set_receiver t (Unix.ADDR_INET(addr,port));
	  t
  in
  Rpc_transport.send_sync trans (Rpc_packer.packed_value_of_string s);
  let s' = Rpc_packer.string_of_packed_value(Rpc_transport.receive_sync trans) in
  Unix.close(Rpc_transport.descriptor trans);
  print_endline "Content-type: application/x-rpc";
  print_endline ("Content-length: " ^ string_of_int(String.length s'));
  print_endline "";
  print_string s';
  flush stdout
;;


let forward_to_program proto host prog vers =
  let pm = Rpc_portmapper.create_inet host in
  let port = Rpc_portmapper.getport pm prog vers proto in
  Rpc_portmapper.shut_down pm;
  forward_to_port proto host port
;;
