(* $Id: rpc_auth_sys.mli 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)

(* This module implements system authentication (AUTH_SYS, also known as
 * AUTH_UNIX).
 *
 * ***********************************************************************
 * WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
 *
 * This authentication method is insecure because it does not use any
 * verifier. I strongly dissuade everybody from using this authentication
 * method for newly written RPC systems. I include it here only for
 * compatibility with older systems.
 *
 * WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
 * ***********************************************************************
 *)

type identity =
    [ `Effective_user
    | `Real_user
    | `This_user of (int * int * int array * string)
	(* (uid, gid, supplementary group IDs, hostname) *)
    ]

val client_auth_method : ?identity : identity ->       (* default: `Real_user *)
                         unit ->
			   Rpc_client.auth_method
  (* Pass the result of this function to Rpc_client.set_auth_methods to
   * configure client authentication.
   *)


val server_auth_method : ?lookup_hostname:bool ->          (* default: true *)
                         ?require_privileged_port:bool ->  (* default: true *)
			 unit ->
			   Rpc_server.auth_method
  (* Pass the result of this function to Rpc_server.set_auth_methods to
   * configure authentication.
   *
   * ~lookup_hostname: if true, the hostname contained in the credentials
   *    is checked (by gethostbyname)
   * ~require_privileged_port: if true, the client must use a privileged
   *    port. Note that Unix domain sockets are rejected in this mode.
   *
   * User name strings have the format:
   *   "<uid>.<gid>.<gid1>.<gid2>...@<hostname>"
   * All user and group IDs are numeric. The first two numbers, <uid> and
   * <gid> are always present. The other numbers are the supplementary
   * group IDs and can be omitted. The <hostname> is the name passed in
   * the credentials.
   *)

val parse_user_name : string -> (int * int * int array * string)
  (* Parses a user name as returned by Rpc_server.get_user in conjunction
   * with the AUTH_SYS authentication.
   *)
