/**
  \brief Audio inputs of a video device
  
  This class describes an audio input on the card... Hopefully there are as 
  many audio input as video inputs (and listed in the same order, but well,
  you never know :))
  
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "VideoAudioInput.h"
#include "VideoDevice.h"

CVideoAudioInput::CVideoAudioInput(CVideoDevice *video, int channel)
{
   pVideo = video;
   Channel = channel;
   
   Flags = 0;
}

// public

int CVideoAudioInput::GetNumber() const
{
   return Channel;
}

QString CVideoAudioInput::GetName() const
{
   return Name;
}

/** Returns true if this audio input can be muted */
bool CVideoAudioInput::IsMutable()
{
   return false;
}

bool CVideoAudioInput::IsMuted()
{
   return false;
}

/** 
  \brief Return volume setting (if supported)
  \return An integer in the range 0..65535, or -1 if not supported or on error
*/  
int CVideoAudioInput::GetVolume() const
{
   return -1;
}

int CVideoAudioInput::GetBass() const
{
   return -1;
}

int CVideoAudioInput::GetTreble() const
{
   return -1;
}



// public slots

void CVideoAudioInput::Mute(bool mute_on)
{
}


void CVideoAudioInput::SetVolume(int volume)
{
}


void CVideoAudioInput::SetBass(int bass)
{
}


void CVideoAudioInput::SetTreble(int treble)
{
}

