/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include "gui_filelist.h"
#include "shared.h"

/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

// TRUE if directory, FALSE if not.
static gboolean
is_dir(gchar *filepathname)
{
	struct stat pstat;
	if(stat(filepathname, &pstat) < 0)
		return(FALSE);
	
	if( S_ISDIR(pstat.st_mode) != 0 )
		return(TRUE);
	
	return(FALSE);
}

// self-explanatory
static gint
get_file_size (gchar *filepathname)
{
	struct stat pstat;
	lstat(filepathname, &pstat);
	return (gint)pstat.st_size;
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/





/**********************************************************************
 * Prints out the given directory to the given clist box
 * Arguments: The ctree to put this rootdir in.
 **********************************************************************/
void
clist_filelist_update(GtkCList *clist, gchar *directory, gboolean showhidden)
{
	struct dirent *pdirent = NULL;
	DIR *dirstream = NULL;
	struct stat filestatus;

	gchar filepathname[2048];
	gchar *output[3];

	GdkColormap *colormap = NULL;
	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;
	gchar *pixmappath = NULL;

	colormap = gtk_widget_get_colormap(gtk_widget_get_toplevel(GTK_WIDGET(clist)));
	
	gtk_clist_freeze(clist);
	
// clear list
	gtk_clist_clear(clist);

// open directory
	if((dirstream = opendir(directory)) == NULL)
		return;

// parse through the whole directory
	while((pdirent = readdir(dirstream)) != NULL)
	{
		if( strrchr(pdirent->d_name, '.') != 0
			&& ( strtoucmp(strrchr(pdirent->d_name, '.'), ".mp3") == 0
				|| strtoucmp(strrchr(pdirent->d_name, '.'), ".flac") == 0
#ifdef HAVE_OGG_H
				|| strtoucmp(strrchr(pdirent->d_name, '.'), ".ogg") == 0
#endif
				)
			&& ( strncmp(pdirent->d_name, ".", 1) != 0 || showhidden )
			&& !is_dir(pdirent->d_name) )
		{
// if this is a valid file (not a directory) we get the data to add to the clist. first of all the files owner, group and mode.
			sprintf (filepathname, "%s%s", directory, pdirent->d_name);
			if ( stat(filepathname, &filestatus) == 0 )
			{
				gchar owner[512];
				gchar group[512];
				
				if( getpwuid (filestatus.st_uid) )
					strncpy (owner, getpwuid(filestatus.st_uid)->pw_name, 511);
				else
					strncpy (owner, "?", 511);
					
				if( getgrgid (filestatus.st_gid) )
					strncpy (group, getgrgid (filestatus.st_gid)->gr_name, 511);
				else
					strncpy (group, "?", 511);

				output[2] = malloc(2048);
				snprintf (output[2], 2047, "%s:%s (%u%u%u)",
					owner,
					group,
					(gint)(filestatus.st_mode & 0700) >> 6,
					(gint)(filestatus.st_mode & 0070) >> 3,
					(gint)(filestatus.st_mode & 0007) );

// then, the filesize and the name
				output[1] = malloc(512);
				sprintf (output[1], "%iK", (gint)get_file_size (filepathname)/1024);
				output[0] = g_strdup (pdirent->d_name);
				
// Initialize icon
				pixmappath = g_strconcat (PACKAGE_PIXMAPS_DIR, "/mp3.xpm", '\0');
				pixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask, NULL, pixmappath);
				g_free (pixmappath);
// append all the the list.
				gtk_clist_set_pixtext (clist, gtk_clist_append(clist, output), 0, output[0], 5, pixmap, mask);
				
				g_free(output[2]);
				g_free(output[1]);
				g_free(output[0]);
			}
		}
	}
	closedir(dirstream);
	
// cleanup
	gtk_clist_sort(clist);
	gtk_clist_thaw(clist);
	gtk_clist_columns_autosize(clist);
}








/**********************************************************************
 * Returns a list of all (full)filenames selected in a filelist-clist
 * the list and the lists data must be free'd by the user!
 **********************************************************************/
GList *
clist_filenames_get_selected(GtkCList *clist, gchar *directory)
{
	GList *selection = NULL;
	GList *fullfilenames = NULL;
	gchar *filename = NULL;
	gchar *fullfilename = NULL;
	gint row = 0;

	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;
	guint8 i = 0;
	
// if nothing is selected, return the empty glist.
	if(!(selection = clist->selection))
		return fullfilenames;

// get selected filenames one by one and append to a list of fullfilenames
	while(selection)
	{
		row = (gint)selection->data;
		gtk_clist_get_pixtext(clist, row, 0, &filename, &i, &pixmap, &mask);
		fullfilename = g_strconcat(directory, filename, '\0');
		fullfilenames = g_list_append(fullfilenames, fullfilename);
		selection = selection->next;
	}
// return the newmade list
	return fullfilenames;
}
