/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "support.h"
#include "gui_rules.h"
#include "rules.h"



/**********************************************************************
 * this will add a list of rules "rules" to the clist "clist".
 **********************************************************************/
void
clist_rules_add_rules(GtkCList *clist, GList *rules)
{
	GList *item = NULL;
	Rule *rule = NULL;
	gchar *output[1];
	gint row = 0;
	
	if(!rules)
		return;
	
	gtk_clist_freeze(clist);
	
	item = g_list_first(rules);
	while(item)
	{
		rule = (Rule *)item->data;
		
		output[0] = (gchar *)rule->text;
		row = gtk_clist_append(clist, output);
		gtk_clist_set_row_data(clist, row, rule);
		
		item = item->next;
	}
	
	gtk_clist_thaw(clist);
}





/**********************************************************************
 * this will set all togglebuttons to not pressed.
 **********************************************************************/
void dialog_rules_init(void)
{
	extern GtkWidget *rules;
	
// tab "standard rules"
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_replace")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_remove")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_forcecc")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_increase")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_stripchar")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_insertspace")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_twodigit")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_stripspace")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_killspace")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_perms")),FALSE);

// tab "more rules"
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_format")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_deletechar")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_delete_occurence")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_move_file_to")),FALSE);
	
// tab "tagging options"
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_v1tag_get")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_v2tag_get")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_vorbistag_get")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_cleanup")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_v1tov2")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_v2tov1")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deleteid3v1")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deleteid3v2")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deletevorbis")),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_twodigit2tag")),FALSE);
	
#ifndef HAVE_OGG_H
	gtk_widget_set_sensitive(GTK_WIDGET(lookup_widget(rules, "entry_rules_vorbistag_get")), FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(lookup_widget(rules, "check_rules_vorbistag_get")), FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(lookup_widget(rules, "check_rules_tag_deletevorbis")), FALSE);
#endif
}






/**********************************************************************
 * this gets the state of the currently chosen rules in the rules dialog,
 * and adds them to a list of rules "rules". Returns the first item of
 * "rules".
 **********************************************************************/
GList *
dialog_rules_get_rules(GList *rulelist)
{
	extern GtkWidget *rules;
	Rule *rule = NULL;
	gchar *foo;

// ADD FILTER: Twodigit number to tag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_twodigit2tag"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "twodigit2tag", 255);
		strncpy(rule->text, "- Copy the twodigit number as track to both tags.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Set permissions.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_perms"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "setperms", 255);
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_perms_mode"))->child),&foo);
		strncpy(rule->option1, foo, 2047);
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_perms_rwx"))->child),&foo);
		strncpy(rule->option2, foo, 2047);
		snprintf(rule->text, 2047, "- Set permissions (%s -> %s).", rule->option1, rule->option2);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Copy ID3V1 tag to V2 tag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_v1tov2"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "v1tov2", 255);
		strncpy(rule->text, "- If present copy the contents of an ID3V1 tag to an ID3V2 tag.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Copy ID3V2 tag to V1 tag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_v2tov1"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "v2tov1", 255);
		strncpy(rule->text, "- If present, copy the contents of an ID3V2 tag to an ID3V1 tag.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Delete ID3V1 tag
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deleteid3v1"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "v1delete", 255);
		strncpy(rule->text, "- Delete the ID3V1 tag.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Delete ID3V2 tag
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deleteid3v2"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "v2delete", 255);
		strncpy(rule->text, "- Delete the ID3V2 tag.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Delete Vorbis tag
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_deletevorbis"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "vorbisdelete", 255);
		strncpy(rule->text, "- Delete the Vorbis tag.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Cleanup ID3V1 tag (=padding spaces to NULL).
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_tag_cleanup"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "tagcleanup", 255);
		strncpy(rule->text, "- Cleanup buggy ID3V1 tags.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Get data out of v1tag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_v1tag_get"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "gettag_v1", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_v1tag_get"))), 2047);
		snprintf(rule->text, 2047, "- Get data from the ID3V1 tag and put it to the filename. Format: \"%s\".", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Get data out of v2tag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_v2tag_get"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "gettag_v2", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_v2tag_get"))), 2047);
		snprintf(rule->text, 2047, "- Get data from the ID3V2 tag and put it to the filename. Format: \"%s\".", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Get data out of vorbistag.
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_vorbistag_get"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "gettag_vorbis", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_vorbistag_get"))), 2047);
		snprintf(rule->text, 2047, "- Get data from the Vorbis tag and put it to the filename. Format: \"%s\".", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: From format to format
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_format"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "format", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_fromformat"))), 2047);
		strncpy(rule->option2, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_toformat"))), 2047);
		snprintf(rule->text, 2047, "- Change format from \"%s\" to \"%s\".", rule->option1, rule->option2);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Kill leading end ending spaces
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_killspace"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "killspace", 255);
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_killspace"))->child),&foo);
		strncpy(rule->option1, foo, 2047);
		snprintf(rule->text, 2047, "- Kill spaces at %s of the filename.", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Replace custom strings
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_replace"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "replace", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_replace_from"))), 2047);
		strncpy(rule->option2, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_replace_to"))), 2047);
		snprintf(rule->text, 2047, "- Replace \"%s\" by \"%s\".", rule->option1, rule->option2);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Remove parentheses
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_remove"))))
	{
		rule = malloc(sizeof(Rule));
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_remove_leading"))->child),&foo);
		strncpy(rule->name, "parentheses", 255);
		strncpy(rule->option1, foo, 2047);
		snprintf(rule->text, 2047, "- Remove %s parentheses.", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Force-set character case
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_forcecc"))))
	{
		rule = malloc(sizeof(Rule));
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_forcecc_case"))->child),&foo);
		strncpy(rule->name, "forcecc", 255);
		strncpy(rule->option1, foo, 2047);
		snprintf(rule->text, 2047, "- Force-set characters case to %s.", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Delete characters from pos to pos
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_deletechar"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "deletechar", 255);
		snprintf(rule->option1, 2047, "%i", gtk_spin_button_get_value_as_int(
									GTK_SPIN_BUTTON(lookup_widget(rules, "spin_rules_deletechar_from"))));
		snprintf(rule->option2, 2047, "%i", gtk_spin_button_get_value_as_int(
									GTK_SPIN_BUTTON(lookup_widget(rules, "spin_rules_deletechar_to"))));
		snprintf(rule->text, 2047, "- Delete character %s to character %s.", rule->option1, rule->option2);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Delete characters to the occurence of a string..
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_delete_occurence"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "stripoccurence", 255);
		gtk_label_get(GTK_LABEL(GTK_BIN(lookup_widget(rules, "option_rules_delete_occurence"))->child),&foo);
		strncpy(rule->option1, foo, 2047);
		strncpy(rule->option2, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_delete_occurence"))), 2047);
		snprintf(rule->text, 2047, "- Delete all characters before the %s of \"%s\".", rule->option1, rule->option2);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: First number increase
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_increase"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "increase", 255);
		snprintf(rule->option1, 2047, "%i", gtk_spin_button_get_value_as_int(
									GTK_SPIN_BUTTON(lookup_widget(rules, "spin_rules_increase_by"))));
		snprintf(rule->text, 2047, "- Increase first number by %s", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Move file to
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_move_file_to"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "movetodir", 255);
		strncpy(rule->option1, gtk_entry_get_text (GTK_ENTRY(lookup_widget(rules, "entry_rules_move_file_to"))), 2047);
		snprintf(rule->text, 2047, "- Move file to directory \"%s\".", rule->option1);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Strip all characters before first digit
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_stripchar"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "stripchar", 255);
		strncpy(rule->text, "- Delete all characters before first digit.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: First number twodigit
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_twodigit"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "twodigit", 255);
		strncpy(rule->text, "- First number twodigit.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Add space before uppercase letters
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_insertspace"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "insertspace", 255);
		strncpy(rule->text, "- Insert a space before every uppercase letter.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
// ADD FILTER: Strip multiple spaces
	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON(lookup_widget (rules, "check_rules_stripspace"))))
	{
		rule = malloc(sizeof(Rule));
		strncpy(rule->name, "stripspace", 255);
		strncpy(rule->text, "- Strip multiple spaces.", 2047);
		rulelist = g_list_append(rulelist, rule);
	}
	if(rulelist)
		rulelist = g_list_first(rulelist);
	return rulelist;
}
